/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoRaWANGatewayMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoRaWANGatewayMetadata> {
    private static final SdkField<String> GATEWAY_EUI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayEui").getter(LoRaWANGatewayMetadata.getter(LoRaWANGatewayMetadata::gatewayEui)).setter(LoRaWANGatewayMetadata.setter(Builder::gatewayEui)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayEui").build()}).build();
    private static final SdkField<Double> SNR_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Snr").getter(LoRaWANGatewayMetadata.getter(LoRaWANGatewayMetadata::snr)).setter(LoRaWANGatewayMetadata.setter(Builder::snr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Snr").build()}).build();
    private static final SdkField<Double> RSSI_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Rssi").getter(LoRaWANGatewayMetadata.getter(LoRaWANGatewayMetadata::rssi)).setter(LoRaWANGatewayMetadata.setter(Builder::rssi)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rssi").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_EUI_FIELD, SNR_FIELD, RSSI_FIELD));
    private static final long serialVersionUID = 1L;
    private final String gatewayEui;
    private final Double snr;
    private final Double rssi;

    private LoRaWANGatewayMetadata(BuilderImpl builder) {
        this.gatewayEui = builder.gatewayEui;
        this.snr = builder.snr;
        this.rssi = builder.rssi;
    }

    public final String gatewayEui() {
        return this.gatewayEui;
    }

    public final Double snr() {
        return this.snr;
    }

    public final Double rssi() {
        return this.rssi;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayEui());
        hashCode = 31 * hashCode + Objects.hashCode(this.snr());
        hashCode = 31 * hashCode + Objects.hashCode(this.rssi());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANGatewayMetadata)) {
            return false;
        }
        LoRaWANGatewayMetadata other = (LoRaWANGatewayMetadata)obj;
        return Objects.equals(this.gatewayEui(), other.gatewayEui()) && Objects.equals(this.snr(), other.snr()) && Objects.equals(this.rssi(), other.rssi());
    }

    public final String toString() {
        return ToString.builder((String)"LoRaWANGatewayMetadata").add("GatewayEui", (Object)this.gatewayEui()).add("Snr", (Object)this.snr()).add("Rssi", (Object)this.rssi()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayEui": {
                return Optional.ofNullable(clazz.cast(this.gatewayEui()));
            }
            case "Snr": {
                return Optional.ofNullable(clazz.cast(this.snr()));
            }
            case "Rssi": {
                return Optional.ofNullable(clazz.cast(this.rssi()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANGatewayMetadata, T> g) {
        return obj -> g.apply((LoRaWANGatewayMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String gatewayEui;
        private Double snr;
        private Double rssi;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANGatewayMetadata model) {
            this.gatewayEui(model.gatewayEui);
            this.snr(model.snr);
            this.rssi(model.rssi);
        }

        public final String getGatewayEui() {
            return this.gatewayEui;
        }

        public final void setGatewayEui(String gatewayEui) {
            this.gatewayEui = gatewayEui;
        }

        @Override
        public final Builder gatewayEui(String gatewayEui) {
            this.gatewayEui = gatewayEui;
            return this;
        }

        public final Double getSnr() {
            return this.snr;
        }

        public final void setSnr(Double snr) {
            this.snr = snr;
        }

        @Override
        public final Builder snr(Double snr) {
            this.snr = snr;
            return this;
        }

        public final Double getRssi() {
            return this.rssi;
        }

        public final void setRssi(Double rssi) {
            this.rssi = rssi;
        }

        @Override
        public final Builder rssi(Double rssi) {
            this.rssi = rssi;
            return this;
        }

        public LoRaWANGatewayMetadata build() {
            return new LoRaWANGatewayMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoRaWANGatewayMetadata> {
        public Builder gatewayEui(String var1);

        public Builder snr(Double var1);

        public Builder rssi(Double var1);
    }
}

