/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WirelessDeviceIdType {
    WIRELESS_DEVICE_ID("WirelessDeviceId"),
    DEV_EUI("DevEui"),
    THING_NAME("ThingName"),
    SIDEWALK_MANUFACTURING_SN("SidewalkManufacturingSn"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WirelessDeviceIdType> VALUE_MAP;
    private final String value;

    private WirelessDeviceIdType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WirelessDeviceIdType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WirelessDeviceIdType> knownValues() {
        EnumSet<WirelessDeviceIdType> knownValues = EnumSet.allOf(WirelessDeviceIdType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WirelessDeviceIdType.class, WirelessDeviceIdType::toString);
    }
}

