/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MetricName {
    DEVICE_RSSI("DeviceRSSI"),
    DEVICE_SNR("DeviceSNR"),
    DEVICE_ROAMING_RSSI("DeviceRoamingRSSI"),
    DEVICE_ROAMING_SNR("DeviceRoamingSNR"),
    DEVICE_UPLINK_COUNT("DeviceUplinkCount"),
    DEVICE_DOWNLINK_COUNT("DeviceDownlinkCount"),
    DEVICE_UPLINK_LOST_COUNT("DeviceUplinkLostCount"),
    DEVICE_UPLINK_LOST_RATE("DeviceUplinkLostRate"),
    DEVICE_JOIN_REQUEST_COUNT("DeviceJoinRequestCount"),
    DEVICE_JOIN_ACCEPT_COUNT("DeviceJoinAcceptCount"),
    DEVICE_ROAMING_UPLINK_COUNT("DeviceRoamingUplinkCount"),
    DEVICE_ROAMING_DOWNLINK_COUNT("DeviceRoamingDownlinkCount"),
    GATEWAY_UP_TIME("GatewayUpTime"),
    GATEWAY_DOWN_TIME("GatewayDownTime"),
    GATEWAY_RSSI("GatewayRSSI"),
    GATEWAY_SNR("GatewaySNR"),
    GATEWAY_UPLINK_COUNT("GatewayUplinkCount"),
    GATEWAY_DOWNLINK_COUNT("GatewayDownlinkCount"),
    GATEWAY_JOIN_REQUEST_COUNT("GatewayJoinRequestCount"),
    GATEWAY_JOIN_ACCEPT_COUNT("GatewayJoinAcceptCount"),
    AWS_ACCOUNT_UPLINK_COUNT("AwsAccountUplinkCount"),
    AWS_ACCOUNT_DOWNLINK_COUNT("AwsAccountDownlinkCount"),
    AWS_ACCOUNT_UPLINK_LOST_COUNT("AwsAccountUplinkLostCount"),
    AWS_ACCOUNT_UPLINK_LOST_RATE("AwsAccountUplinkLostRate"),
    AWS_ACCOUNT_JOIN_REQUEST_COUNT("AwsAccountJoinRequestCount"),
    AWS_ACCOUNT_JOIN_ACCEPT_COUNT("AwsAccountJoinAcceptCount"),
    AWS_ACCOUNT_ROAMING_UPLINK_COUNT("AwsAccountRoamingUplinkCount"),
    AWS_ACCOUNT_ROAMING_DOWNLINK_COUNT("AwsAccountRoamingDownlinkCount"),
    AWS_ACCOUNT_DEVICE_COUNT("AwsAccountDeviceCount"),
    AWS_ACCOUNT_GATEWAY_COUNT("AwsAccountGatewayCount"),
    AWS_ACCOUNT_ACTIVE_DEVICE_COUNT("AwsAccountActiveDeviceCount"),
    AWS_ACCOUNT_ACTIVE_GATEWAY_COUNT("AwsAccountActiveGatewayCount"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MetricName> VALUE_MAP;
    private final String value;

    private MetricName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MetricName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MetricName> knownValues() {
        EnumSet<MetricName> knownValues = EnumSet.allOf(MetricName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MetricName.class, MetricName::toString);
    }
}

