/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotwireless.IotWirelessClient;
import software.amazon.awssdk.services.iotwireless.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsResponse;

public class ListPositionConfigurationsIterable
implements SdkIterable<ListPositionConfigurationsResponse> {
    private final IotWirelessClient client;
    private final ListPositionConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPositionConfigurationsIterable(IotWirelessClient client, ListPositionConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPositionConfigurationsResponseFetcher();
    }

    public Iterator<ListPositionConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPositionConfigurationsResponseFetcher
    implements SyncPageFetcher<ListPositionConfigurationsResponse> {
        private ListPositionConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListPositionConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPositionConfigurationsResponse nextPage(ListPositionConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListPositionConfigurationsIterable.this.client.listPositionConfigurations(ListPositionConfigurationsIterable.this.firstRequest);
            }
            return ListPositionConfigurationsIterable.this.client.listPositionConfigurations((ListPositionConfigurationsRequest)((Object)ListPositionConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

