/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.ImportedWirelessDevice;
import software.amazon.awssdk.services.iotwireless.model.ImportedWirelessDeviceListCopier;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDevicesForWirelessDeviceImportTaskResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, ListDevicesForWirelessDeviceImportTaskResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDevicesForWirelessDeviceImportTaskResponse.getter(ListDevicesForWirelessDeviceImportTaskResponse::nextToken)).setter(ListDevicesForWirelessDeviceImportTaskResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationName").getter(ListDevicesForWirelessDeviceImportTaskResponse.getter(ListDevicesForWirelessDeviceImportTaskResponse::destinationName)).setter(ListDevicesForWirelessDeviceImportTaskResponse.setter(Builder::destinationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationName").build()}).build();
    private static final SdkField<List<ImportedWirelessDevice>> IMPORTED_WIRELESS_DEVICE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImportedWirelessDeviceList").getter(ListDevicesForWirelessDeviceImportTaskResponse.getter(ListDevicesForWirelessDeviceImportTaskResponse::importedWirelessDeviceList)).setter(ListDevicesForWirelessDeviceImportTaskResponse.setter(Builder::importedWirelessDeviceList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportedWirelessDeviceList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImportedWirelessDevice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, DESTINATION_NAME_FIELD, IMPORTED_WIRELESS_DEVICE_LIST_FIELD));
    private final String nextToken;
    private final String destinationName;
    private final List<ImportedWirelessDevice> importedWirelessDeviceList;

    private ListDevicesForWirelessDeviceImportTaskResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.destinationName = builder.destinationName;
        this.importedWirelessDeviceList = builder.importedWirelessDeviceList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String destinationName() {
        return this.destinationName;
    }

    public final boolean hasImportedWirelessDeviceList() {
        return this.importedWirelessDeviceList != null && !(this.importedWirelessDeviceList instanceof SdkAutoConstructList);
    }

    public final List<ImportedWirelessDevice> importedWirelessDeviceList() {
        return this.importedWirelessDeviceList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImportedWirelessDeviceList() ? this.importedWirelessDeviceList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDevicesForWirelessDeviceImportTaskResponse)) {
            return false;
        }
        ListDevicesForWirelessDeviceImportTaskResponse other = (ListDevicesForWirelessDeviceImportTaskResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.destinationName(), other.destinationName()) && this.hasImportedWirelessDeviceList() == other.hasImportedWirelessDeviceList() && Objects.equals(this.importedWirelessDeviceList(), other.importedWirelessDeviceList());
    }

    public final String toString() {
        return ToString.builder((String)"ListDevicesForWirelessDeviceImportTaskResponse").add("NextToken", (Object)this.nextToken()).add("DestinationName", (Object)this.destinationName()).add("ImportedWirelessDeviceList", this.hasImportedWirelessDeviceList() ? this.importedWirelessDeviceList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "DestinationName": {
                return Optional.ofNullable(clazz.cast(this.destinationName()));
            }
            case "ImportedWirelessDeviceList": {
                return Optional.ofNullable(clazz.cast(this.importedWirelessDeviceList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDevicesForWirelessDeviceImportTaskResponse, T> g) {
        return obj -> g.apply((ListDevicesForWirelessDeviceImportTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private String destinationName;
        private List<ImportedWirelessDevice> importedWirelessDeviceList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDevicesForWirelessDeviceImportTaskResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.destinationName(model.destinationName);
            this.importedWirelessDeviceList(model.importedWirelessDeviceList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getDestinationName() {
            return this.destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final List<ImportedWirelessDevice.Builder> getImportedWirelessDeviceList() {
            List<ImportedWirelessDevice.Builder> result = ImportedWirelessDeviceListCopier.copyToBuilder(this.importedWirelessDeviceList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImportedWirelessDeviceList(Collection<ImportedWirelessDevice.BuilderImpl> importedWirelessDeviceList) {
            this.importedWirelessDeviceList = ImportedWirelessDeviceListCopier.copyFromBuilder(importedWirelessDeviceList);
        }

        @Override
        public final Builder importedWirelessDeviceList(Collection<ImportedWirelessDevice> importedWirelessDeviceList) {
            this.importedWirelessDeviceList = ImportedWirelessDeviceListCopier.copy(importedWirelessDeviceList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importedWirelessDeviceList(ImportedWirelessDevice ... importedWirelessDeviceList) {
            this.importedWirelessDeviceList(Arrays.asList(importedWirelessDeviceList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importedWirelessDeviceList(Consumer<ImportedWirelessDevice.Builder> ... importedWirelessDeviceList) {
            this.importedWirelessDeviceList(Stream.of(importedWirelessDeviceList).map(c -> (ImportedWirelessDevice)((ImportedWirelessDevice.Builder)ImportedWirelessDevice.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListDevicesForWirelessDeviceImportTaskResponse build() {
            return new ListDevicesForWirelessDeviceImportTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDevicesForWirelessDeviceImportTaskResponse> {
        public Builder nextToken(String var1);

        public Builder destinationName(String var1);

        public Builder importedWirelessDeviceList(Collection<ImportedWirelessDevice> var1);

        public Builder importedWirelessDeviceList(ImportedWirelessDevice ... var1);

        public Builder importedWirelessDeviceList(Consumer<ImportedWirelessDevice.Builder> ... var1);
    }
}

