/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * LoRaWANGetServiceProfileInfo object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoRaWANGetServiceProfileInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<LoRaWANGetServiceProfileInfo.Builder, LoRaWANGetServiceProfileInfo> {
    private static final SdkField<Integer> UL_RATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UlRate").getter(getter(LoRaWANGetServiceProfileInfo::ulRate)).setter(setter(Builder::ulRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UlRate").build()).build();

    private static final SdkField<Integer> UL_BUCKET_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("UlBucketSize").getter(getter(LoRaWANGetServiceProfileInfo::ulBucketSize))
            .setter(setter(Builder::ulBucketSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UlBucketSize").build()).build();

    private static final SdkField<String> UL_RATE_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UlRatePolicy").getter(getter(LoRaWANGetServiceProfileInfo::ulRatePolicy))
            .setter(setter(Builder::ulRatePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UlRatePolicy").build()).build();

    private static final SdkField<Integer> DL_RATE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DlRate").getter(getter(LoRaWANGetServiceProfileInfo::dlRate)).setter(setter(Builder::dlRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DlRate").build()).build();

    private static final SdkField<Integer> DL_BUCKET_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DlBucketSize").getter(getter(LoRaWANGetServiceProfileInfo::dlBucketSize))
            .setter(setter(Builder::dlBucketSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DlBucketSize").build()).build();

    private static final SdkField<String> DL_RATE_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DlRatePolicy").getter(getter(LoRaWANGetServiceProfileInfo::dlRatePolicy))
            .setter(setter(Builder::dlRatePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DlRatePolicy").build()).build();

    private static final SdkField<Boolean> ADD_GW_METADATA_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AddGwMetadata").getter(getter(LoRaWANGetServiceProfileInfo::addGwMetadata))
            .setter(setter(Builder::addGwMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddGwMetadata").build()).build();

    private static final SdkField<Integer> DEV_STATUS_REQ_FREQ_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DevStatusReqFreq").getter(getter(LoRaWANGetServiceProfileInfo::devStatusReqFreq))
            .setter(setter(Builder::devStatusReqFreq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DevStatusReqFreq").build()).build();

    private static final SdkField<Boolean> REPORT_DEV_STATUS_BATTERY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReportDevStatusBattery").getter(getter(LoRaWANGetServiceProfileInfo::reportDevStatusBattery))
            .setter(setter(Builder::reportDevStatusBattery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportDevStatusBattery").build())
            .build();

    private static final SdkField<Boolean> REPORT_DEV_STATUS_MARGIN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReportDevStatusMargin").getter(getter(LoRaWANGetServiceProfileInfo::reportDevStatusMargin))
            .setter(setter(Builder::reportDevStatusMargin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportDevStatusMargin").build())
            .build();

    private static final SdkField<Integer> DR_MIN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("DrMin")
            .getter(getter(LoRaWANGetServiceProfileInfo::drMin)).setter(setter(Builder::drMin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DrMin").build()).build();

    private static final SdkField<Integer> DR_MAX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("DrMax")
            .getter(getter(LoRaWANGetServiceProfileInfo::drMax)).setter(setter(Builder::drMax))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DrMax").build()).build();

    private static final SdkField<String> CHANNEL_MASK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelMask").getter(getter(LoRaWANGetServiceProfileInfo::channelMask))
            .setter(setter(Builder::channelMask))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelMask").build()).build();

    private static final SdkField<Boolean> PR_ALLOWED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PrAllowed").getter(getter(LoRaWANGetServiceProfileInfo::prAllowed)).setter(setter(Builder::prAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrAllowed").build()).build();

    private static final SdkField<Boolean> HR_ALLOWED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HrAllowed").getter(getter(LoRaWANGetServiceProfileInfo::hrAllowed)).setter(setter(Builder::hrAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HrAllowed").build()).build();

    private static final SdkField<Boolean> RA_ALLOWED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RaAllowed").getter(getter(LoRaWANGetServiceProfileInfo::raAllowed)).setter(setter(Builder::raAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RaAllowed").build()).build();

    private static final SdkField<Boolean> NWK_GEO_LOC_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NwkGeoLoc").getter(getter(LoRaWANGetServiceProfileInfo::nwkGeoLoc)).setter(setter(Builder::nwkGeoLoc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NwkGeoLoc").build()).build();

    private static final SdkField<Integer> TARGET_PER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TargetPer").getter(getter(LoRaWANGetServiceProfileInfo::targetPer)).setter(setter(Builder::targetPer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetPer").build()).build();

    private static final SdkField<Integer> MIN_GW_DIVERSITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinGwDiversity").getter(getter(LoRaWANGetServiceProfileInfo::minGwDiversity))
            .setter(setter(Builder::minGwDiversity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinGwDiversity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UL_RATE_FIELD,
            UL_BUCKET_SIZE_FIELD, UL_RATE_POLICY_FIELD, DL_RATE_FIELD, DL_BUCKET_SIZE_FIELD, DL_RATE_POLICY_FIELD,
            ADD_GW_METADATA_FIELD, DEV_STATUS_REQ_FREQ_FIELD, REPORT_DEV_STATUS_BATTERY_FIELD, REPORT_DEV_STATUS_MARGIN_FIELD,
            DR_MIN_FIELD, DR_MAX_FIELD, CHANNEL_MASK_FIELD, PR_ALLOWED_FIELD, HR_ALLOWED_FIELD, RA_ALLOWED_FIELD,
            NWK_GEO_LOC_FIELD, TARGET_PER_FIELD, MIN_GW_DIVERSITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer ulRate;

    private final Integer ulBucketSize;

    private final String ulRatePolicy;

    private final Integer dlRate;

    private final Integer dlBucketSize;

    private final String dlRatePolicy;

    private final Boolean addGwMetadata;

    private final Integer devStatusReqFreq;

    private final Boolean reportDevStatusBattery;

    private final Boolean reportDevStatusMargin;

    private final Integer drMin;

    private final Integer drMax;

    private final String channelMask;

    private final Boolean prAllowed;

    private final Boolean hrAllowed;

    private final Boolean raAllowed;

    private final Boolean nwkGeoLoc;

    private final Integer targetPer;

    private final Integer minGwDiversity;

    private LoRaWANGetServiceProfileInfo(BuilderImpl builder) {
        this.ulRate = builder.ulRate;
        this.ulBucketSize = builder.ulBucketSize;
        this.ulRatePolicy = builder.ulRatePolicy;
        this.dlRate = builder.dlRate;
        this.dlBucketSize = builder.dlBucketSize;
        this.dlRatePolicy = builder.dlRatePolicy;
        this.addGwMetadata = builder.addGwMetadata;
        this.devStatusReqFreq = builder.devStatusReqFreq;
        this.reportDevStatusBattery = builder.reportDevStatusBattery;
        this.reportDevStatusMargin = builder.reportDevStatusMargin;
        this.drMin = builder.drMin;
        this.drMax = builder.drMax;
        this.channelMask = builder.channelMask;
        this.prAllowed = builder.prAllowed;
        this.hrAllowed = builder.hrAllowed;
        this.raAllowed = builder.raAllowed;
        this.nwkGeoLoc = builder.nwkGeoLoc;
        this.targetPer = builder.targetPer;
        this.minGwDiversity = builder.minGwDiversity;
    }

    /**
     * <p>
     * The ULRate value.
     * </p>
     * 
     * @return The ULRate value.
     */
    public final Integer ulRate() {
        return ulRate;
    }

    /**
     * <p>
     * The ULBucketSize value.
     * </p>
     * 
     * @return The ULBucketSize value.
     */
    public final Integer ulBucketSize() {
        return ulBucketSize;
    }

    /**
     * <p>
     * The ULRatePolicy value.
     * </p>
     * 
     * @return The ULRatePolicy value.
     */
    public final String ulRatePolicy() {
        return ulRatePolicy;
    }

    /**
     * <p>
     * The DLRate value.
     * </p>
     * 
     * @return The DLRate value.
     */
    public final Integer dlRate() {
        return dlRate;
    }

    /**
     * <p>
     * The DLBucketSize value.
     * </p>
     * 
     * @return The DLBucketSize value.
     */
    public final Integer dlBucketSize() {
        return dlBucketSize;
    }

    /**
     * <p>
     * The DLRatePolicy value.
     * </p>
     * 
     * @return The DLRatePolicy value.
     */
    public final String dlRatePolicy() {
        return dlRatePolicy;
    }

    /**
     * <p>
     * The AddGWMetaData value.
     * </p>
     * 
     * @return The AddGWMetaData value.
     */
    public final Boolean addGwMetadata() {
        return addGwMetadata;
    }

    /**
     * <p>
     * The DevStatusReqFreq value.
     * </p>
     * 
     * @return The DevStatusReqFreq value.
     */
    public final Integer devStatusReqFreq() {
        return devStatusReqFreq;
    }

    /**
     * <p>
     * The ReportDevStatusBattery value.
     * </p>
     * 
     * @return The ReportDevStatusBattery value.
     */
    public final Boolean reportDevStatusBattery() {
        return reportDevStatusBattery;
    }

    /**
     * <p>
     * The ReportDevStatusMargin value.
     * </p>
     * 
     * @return The ReportDevStatusMargin value.
     */
    public final Boolean reportDevStatusMargin() {
        return reportDevStatusMargin;
    }

    /**
     * <p>
     * The DRMin value.
     * </p>
     * 
     * @return The DRMin value.
     */
    public final Integer drMin() {
        return drMin;
    }

    /**
     * <p>
     * The DRMax value.
     * </p>
     * 
     * @return The DRMax value.
     */
    public final Integer drMax() {
        return drMax;
    }

    /**
     * <p>
     * The ChannelMask value.
     * </p>
     * 
     * @return The ChannelMask value.
     */
    public final String channelMask() {
        return channelMask;
    }

    /**
     * <p>
     * The PRAllowed value that describes whether passive roaming is allowed.
     * </p>
     * 
     * @return The PRAllowed value that describes whether passive roaming is allowed.
     */
    public final Boolean prAllowed() {
        return prAllowed;
    }

    /**
     * <p>
     * The HRAllowed value that describes whether handover roaming is allowed.
     * </p>
     * 
     * @return The HRAllowed value that describes whether handover roaming is allowed.
     */
    public final Boolean hrAllowed() {
        return hrAllowed;
    }

    /**
     * <p>
     * The RAAllowed value that describes whether roaming activation is allowed.
     * </p>
     * 
     * @return The RAAllowed value that describes whether roaming activation is allowed.
     */
    public final Boolean raAllowed() {
        return raAllowed;
    }

    /**
     * <p>
     * The NwkGeoLoc value.
     * </p>
     * 
     * @return The NwkGeoLoc value.
     */
    public final Boolean nwkGeoLoc() {
        return nwkGeoLoc;
    }

    /**
     * <p>
     * The TargetPER value.
     * </p>
     * 
     * @return The TargetPER value.
     */
    public final Integer targetPer() {
        return targetPer;
    }

    /**
     * <p>
     * The MinGwDiversity value.
     * </p>
     * 
     * @return The MinGwDiversity value.
     */
    public final Integer minGwDiversity() {
        return minGwDiversity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ulRate());
        hashCode = 31 * hashCode + Objects.hashCode(ulBucketSize());
        hashCode = 31 * hashCode + Objects.hashCode(ulRatePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(dlRate());
        hashCode = 31 * hashCode + Objects.hashCode(dlBucketSize());
        hashCode = 31 * hashCode + Objects.hashCode(dlRatePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(addGwMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(devStatusReqFreq());
        hashCode = 31 * hashCode + Objects.hashCode(reportDevStatusBattery());
        hashCode = 31 * hashCode + Objects.hashCode(reportDevStatusMargin());
        hashCode = 31 * hashCode + Objects.hashCode(drMin());
        hashCode = 31 * hashCode + Objects.hashCode(drMax());
        hashCode = 31 * hashCode + Objects.hashCode(channelMask());
        hashCode = 31 * hashCode + Objects.hashCode(prAllowed());
        hashCode = 31 * hashCode + Objects.hashCode(hrAllowed());
        hashCode = 31 * hashCode + Objects.hashCode(raAllowed());
        hashCode = 31 * hashCode + Objects.hashCode(nwkGeoLoc());
        hashCode = 31 * hashCode + Objects.hashCode(targetPer());
        hashCode = 31 * hashCode + Objects.hashCode(minGwDiversity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANGetServiceProfileInfo)) {
            return false;
        }
        LoRaWANGetServiceProfileInfo other = (LoRaWANGetServiceProfileInfo) obj;
        return Objects.equals(ulRate(), other.ulRate()) && Objects.equals(ulBucketSize(), other.ulBucketSize())
                && Objects.equals(ulRatePolicy(), other.ulRatePolicy()) && Objects.equals(dlRate(), other.dlRate())
                && Objects.equals(dlBucketSize(), other.dlBucketSize()) && Objects.equals(dlRatePolicy(), other.dlRatePolicy())
                && Objects.equals(addGwMetadata(), other.addGwMetadata())
                && Objects.equals(devStatusReqFreq(), other.devStatusReqFreq())
                && Objects.equals(reportDevStatusBattery(), other.reportDevStatusBattery())
                && Objects.equals(reportDevStatusMargin(), other.reportDevStatusMargin())
                && Objects.equals(drMin(), other.drMin()) && Objects.equals(drMax(), other.drMax())
                && Objects.equals(channelMask(), other.channelMask()) && Objects.equals(prAllowed(), other.prAllowed())
                && Objects.equals(hrAllowed(), other.hrAllowed()) && Objects.equals(raAllowed(), other.raAllowed())
                && Objects.equals(nwkGeoLoc(), other.nwkGeoLoc()) && Objects.equals(targetPer(), other.targetPer())
                && Objects.equals(minGwDiversity(), other.minGwDiversity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoRaWANGetServiceProfileInfo").add("UlRate", ulRate()).add("UlBucketSize", ulBucketSize())
                .add("UlRatePolicy", ulRatePolicy()).add("DlRate", dlRate()).add("DlBucketSize", dlBucketSize())
                .add("DlRatePolicy", dlRatePolicy()).add("AddGwMetadata", addGwMetadata())
                .add("DevStatusReqFreq", devStatusReqFreq()).add("ReportDevStatusBattery", reportDevStatusBattery())
                .add("ReportDevStatusMargin", reportDevStatusMargin()).add("DrMin", drMin()).add("DrMax", drMax())
                .add("ChannelMask", channelMask()).add("PrAllowed", prAllowed()).add("HrAllowed", hrAllowed())
                .add("RaAllowed", raAllowed()).add("NwkGeoLoc", nwkGeoLoc()).add("TargetPer", targetPer())
                .add("MinGwDiversity", minGwDiversity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UlRate":
            return Optional.ofNullable(clazz.cast(ulRate()));
        case "UlBucketSize":
            return Optional.ofNullable(clazz.cast(ulBucketSize()));
        case "UlRatePolicy":
            return Optional.ofNullable(clazz.cast(ulRatePolicy()));
        case "DlRate":
            return Optional.ofNullable(clazz.cast(dlRate()));
        case "DlBucketSize":
            return Optional.ofNullable(clazz.cast(dlBucketSize()));
        case "DlRatePolicy":
            return Optional.ofNullable(clazz.cast(dlRatePolicy()));
        case "AddGwMetadata":
            return Optional.ofNullable(clazz.cast(addGwMetadata()));
        case "DevStatusReqFreq":
            return Optional.ofNullable(clazz.cast(devStatusReqFreq()));
        case "ReportDevStatusBattery":
            return Optional.ofNullable(clazz.cast(reportDevStatusBattery()));
        case "ReportDevStatusMargin":
            return Optional.ofNullable(clazz.cast(reportDevStatusMargin()));
        case "DrMin":
            return Optional.ofNullable(clazz.cast(drMin()));
        case "DrMax":
            return Optional.ofNullable(clazz.cast(drMax()));
        case "ChannelMask":
            return Optional.ofNullable(clazz.cast(channelMask()));
        case "PrAllowed":
            return Optional.ofNullable(clazz.cast(prAllowed()));
        case "HrAllowed":
            return Optional.ofNullable(clazz.cast(hrAllowed()));
        case "RaAllowed":
            return Optional.ofNullable(clazz.cast(raAllowed()));
        case "NwkGeoLoc":
            return Optional.ofNullable(clazz.cast(nwkGeoLoc()));
        case "TargetPer":
            return Optional.ofNullable(clazz.cast(targetPer()));
        case "MinGwDiversity":
            return Optional.ofNullable(clazz.cast(minGwDiversity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANGetServiceProfileInfo, T> g) {
        return obj -> g.apply((LoRaWANGetServiceProfileInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoRaWANGetServiceProfileInfo> {
        /**
         * <p>
         * The ULRate value.
         * </p>
         * 
         * @param ulRate
         *        The ULRate value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ulRate(Integer ulRate);

        /**
         * <p>
         * The ULBucketSize value.
         * </p>
         * 
         * @param ulBucketSize
         *        The ULBucketSize value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ulBucketSize(Integer ulBucketSize);

        /**
         * <p>
         * The ULRatePolicy value.
         * </p>
         * 
         * @param ulRatePolicy
         *        The ULRatePolicy value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ulRatePolicy(String ulRatePolicy);

        /**
         * <p>
         * The DLRate value.
         * </p>
         * 
         * @param dlRate
         *        The DLRate value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dlRate(Integer dlRate);

        /**
         * <p>
         * The DLBucketSize value.
         * </p>
         * 
         * @param dlBucketSize
         *        The DLBucketSize value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dlBucketSize(Integer dlBucketSize);

        /**
         * <p>
         * The DLRatePolicy value.
         * </p>
         * 
         * @param dlRatePolicy
         *        The DLRatePolicy value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dlRatePolicy(String dlRatePolicy);

        /**
         * <p>
         * The AddGWMetaData value.
         * </p>
         * 
         * @param addGwMetadata
         *        The AddGWMetaData value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addGwMetadata(Boolean addGwMetadata);

        /**
         * <p>
         * The DevStatusReqFreq value.
         * </p>
         * 
         * @param devStatusReqFreq
         *        The DevStatusReqFreq value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devStatusReqFreq(Integer devStatusReqFreq);

        /**
         * <p>
         * The ReportDevStatusBattery value.
         * </p>
         * 
         * @param reportDevStatusBattery
         *        The ReportDevStatusBattery value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportDevStatusBattery(Boolean reportDevStatusBattery);

        /**
         * <p>
         * The ReportDevStatusMargin value.
         * </p>
         * 
         * @param reportDevStatusMargin
         *        The ReportDevStatusMargin value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportDevStatusMargin(Boolean reportDevStatusMargin);

        /**
         * <p>
         * The DRMin value.
         * </p>
         * 
         * @param drMin
         *        The DRMin value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder drMin(Integer drMin);

        /**
         * <p>
         * The DRMax value.
         * </p>
         * 
         * @param drMax
         *        The DRMax value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder drMax(Integer drMax);

        /**
         * <p>
         * The ChannelMask value.
         * </p>
         * 
         * @param channelMask
         *        The ChannelMask value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelMask(String channelMask);

        /**
         * <p>
         * The PRAllowed value that describes whether passive roaming is allowed.
         * </p>
         * 
         * @param prAllowed
         *        The PRAllowed value that describes whether passive roaming is allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prAllowed(Boolean prAllowed);

        /**
         * <p>
         * The HRAllowed value that describes whether handover roaming is allowed.
         * </p>
         * 
         * @param hrAllowed
         *        The HRAllowed value that describes whether handover roaming is allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hrAllowed(Boolean hrAllowed);

        /**
         * <p>
         * The RAAllowed value that describes whether roaming activation is allowed.
         * </p>
         * 
         * @param raAllowed
         *        The RAAllowed value that describes whether roaming activation is allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder raAllowed(Boolean raAllowed);

        /**
         * <p>
         * The NwkGeoLoc value.
         * </p>
         * 
         * @param nwkGeoLoc
         *        The NwkGeoLoc value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nwkGeoLoc(Boolean nwkGeoLoc);

        /**
         * <p>
         * The TargetPER value.
         * </p>
         * 
         * @param targetPer
         *        The TargetPER value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetPer(Integer targetPer);

        /**
         * <p>
         * The MinGwDiversity value.
         * </p>
         * 
         * @param minGwDiversity
         *        The MinGwDiversity value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minGwDiversity(Integer minGwDiversity);
    }

    static final class BuilderImpl implements Builder {
        private Integer ulRate;

        private Integer ulBucketSize;

        private String ulRatePolicy;

        private Integer dlRate;

        private Integer dlBucketSize;

        private String dlRatePolicy;

        private Boolean addGwMetadata;

        private Integer devStatusReqFreq;

        private Boolean reportDevStatusBattery;

        private Boolean reportDevStatusMargin;

        private Integer drMin;

        private Integer drMax;

        private String channelMask;

        private Boolean prAllowed;

        private Boolean hrAllowed;

        private Boolean raAllowed;

        private Boolean nwkGeoLoc;

        private Integer targetPer;

        private Integer minGwDiversity;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANGetServiceProfileInfo model) {
            ulRate(model.ulRate);
            ulBucketSize(model.ulBucketSize);
            ulRatePolicy(model.ulRatePolicy);
            dlRate(model.dlRate);
            dlBucketSize(model.dlBucketSize);
            dlRatePolicy(model.dlRatePolicy);
            addGwMetadata(model.addGwMetadata);
            devStatusReqFreq(model.devStatusReqFreq);
            reportDevStatusBattery(model.reportDevStatusBattery);
            reportDevStatusMargin(model.reportDevStatusMargin);
            drMin(model.drMin);
            drMax(model.drMax);
            channelMask(model.channelMask);
            prAllowed(model.prAllowed);
            hrAllowed(model.hrAllowed);
            raAllowed(model.raAllowed);
            nwkGeoLoc(model.nwkGeoLoc);
            targetPer(model.targetPer);
            minGwDiversity(model.minGwDiversity);
        }

        public final Integer getUlRate() {
            return ulRate;
        }

        public final void setUlRate(Integer ulRate) {
            this.ulRate = ulRate;
        }

        @Override
        public final Builder ulRate(Integer ulRate) {
            this.ulRate = ulRate;
            return this;
        }

        public final Integer getUlBucketSize() {
            return ulBucketSize;
        }

        public final void setUlBucketSize(Integer ulBucketSize) {
            this.ulBucketSize = ulBucketSize;
        }

        @Override
        public final Builder ulBucketSize(Integer ulBucketSize) {
            this.ulBucketSize = ulBucketSize;
            return this;
        }

        public final String getUlRatePolicy() {
            return ulRatePolicy;
        }

        public final void setUlRatePolicy(String ulRatePolicy) {
            this.ulRatePolicy = ulRatePolicy;
        }

        @Override
        public final Builder ulRatePolicy(String ulRatePolicy) {
            this.ulRatePolicy = ulRatePolicy;
            return this;
        }

        public final Integer getDlRate() {
            return dlRate;
        }

        public final void setDlRate(Integer dlRate) {
            this.dlRate = dlRate;
        }

        @Override
        public final Builder dlRate(Integer dlRate) {
            this.dlRate = dlRate;
            return this;
        }

        public final Integer getDlBucketSize() {
            return dlBucketSize;
        }

        public final void setDlBucketSize(Integer dlBucketSize) {
            this.dlBucketSize = dlBucketSize;
        }

        @Override
        public final Builder dlBucketSize(Integer dlBucketSize) {
            this.dlBucketSize = dlBucketSize;
            return this;
        }

        public final String getDlRatePolicy() {
            return dlRatePolicy;
        }

        public final void setDlRatePolicy(String dlRatePolicy) {
            this.dlRatePolicy = dlRatePolicy;
        }

        @Override
        public final Builder dlRatePolicy(String dlRatePolicy) {
            this.dlRatePolicy = dlRatePolicy;
            return this;
        }

        public final Boolean getAddGwMetadata() {
            return addGwMetadata;
        }

        public final void setAddGwMetadata(Boolean addGwMetadata) {
            this.addGwMetadata = addGwMetadata;
        }

        @Override
        public final Builder addGwMetadata(Boolean addGwMetadata) {
            this.addGwMetadata = addGwMetadata;
            return this;
        }

        public final Integer getDevStatusReqFreq() {
            return devStatusReqFreq;
        }

        public final void setDevStatusReqFreq(Integer devStatusReqFreq) {
            this.devStatusReqFreq = devStatusReqFreq;
        }

        @Override
        public final Builder devStatusReqFreq(Integer devStatusReqFreq) {
            this.devStatusReqFreq = devStatusReqFreq;
            return this;
        }

        public final Boolean getReportDevStatusBattery() {
            return reportDevStatusBattery;
        }

        public final void setReportDevStatusBattery(Boolean reportDevStatusBattery) {
            this.reportDevStatusBattery = reportDevStatusBattery;
        }

        @Override
        public final Builder reportDevStatusBattery(Boolean reportDevStatusBattery) {
            this.reportDevStatusBattery = reportDevStatusBattery;
            return this;
        }

        public final Boolean getReportDevStatusMargin() {
            return reportDevStatusMargin;
        }

        public final void setReportDevStatusMargin(Boolean reportDevStatusMargin) {
            this.reportDevStatusMargin = reportDevStatusMargin;
        }

        @Override
        public final Builder reportDevStatusMargin(Boolean reportDevStatusMargin) {
            this.reportDevStatusMargin = reportDevStatusMargin;
            return this;
        }

        public final Integer getDrMin() {
            return drMin;
        }

        public final void setDrMin(Integer drMin) {
            this.drMin = drMin;
        }

        @Override
        public final Builder drMin(Integer drMin) {
            this.drMin = drMin;
            return this;
        }

        public final Integer getDrMax() {
            return drMax;
        }

        public final void setDrMax(Integer drMax) {
            this.drMax = drMax;
        }

        @Override
        public final Builder drMax(Integer drMax) {
            this.drMax = drMax;
            return this;
        }

        public final String getChannelMask() {
            return channelMask;
        }

        public final void setChannelMask(String channelMask) {
            this.channelMask = channelMask;
        }

        @Override
        public final Builder channelMask(String channelMask) {
            this.channelMask = channelMask;
            return this;
        }

        public final Boolean getPrAllowed() {
            return prAllowed;
        }

        public final void setPrAllowed(Boolean prAllowed) {
            this.prAllowed = prAllowed;
        }

        @Override
        public final Builder prAllowed(Boolean prAllowed) {
            this.prAllowed = prAllowed;
            return this;
        }

        public final Boolean getHrAllowed() {
            return hrAllowed;
        }

        public final void setHrAllowed(Boolean hrAllowed) {
            this.hrAllowed = hrAllowed;
        }

        @Override
        public final Builder hrAllowed(Boolean hrAllowed) {
            this.hrAllowed = hrAllowed;
            return this;
        }

        public final Boolean getRaAllowed() {
            return raAllowed;
        }

        public final void setRaAllowed(Boolean raAllowed) {
            this.raAllowed = raAllowed;
        }

        @Override
        public final Builder raAllowed(Boolean raAllowed) {
            this.raAllowed = raAllowed;
            return this;
        }

        public final Boolean getNwkGeoLoc() {
            return nwkGeoLoc;
        }

        public final void setNwkGeoLoc(Boolean nwkGeoLoc) {
            this.nwkGeoLoc = nwkGeoLoc;
        }

        @Override
        public final Builder nwkGeoLoc(Boolean nwkGeoLoc) {
            this.nwkGeoLoc = nwkGeoLoc;
            return this;
        }

        public final Integer getTargetPer() {
            return targetPer;
        }

        public final void setTargetPer(Integer targetPer) {
            this.targetPer = targetPer;
        }

        @Override
        public final Builder targetPer(Integer targetPer) {
            this.targetPer = targetPer;
            return this;
        }

        public final Integer getMinGwDiversity() {
            return minGwDiversity;
        }

        public final void setMinGwDiversity(Integer minGwDiversity) {
            this.minGwDiversity = minGwDiversity;
        }

        @Override
        public final Builder minGwDiversity(Integer minGwDiversity) {
            this.minGwDiversity = minGwDiversity;
            return this;
        }

        @Override
        public LoRaWANGetServiceProfileInfo build() {
            return new LoRaWANGetServiceProfileInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
