/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWirelessDeviceRequest extends IotWirelessRequest implements
        ToCopyableBuilder<GetWirelessDeviceRequest.Builder, GetWirelessDeviceRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(GetWirelessDeviceRequest::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()).build();

    private static final SdkField<String> IDENTIFIER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentifierType").getter(getter(GetWirelessDeviceRequest::identifierTypeAsString))
            .setter(setter(Builder::identifierType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("identifierType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            IDENTIFIER_TYPE_FIELD));

    private final String identifier;

    private final String identifierType;

    private GetWirelessDeviceRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.identifierType = builder.identifierType;
    }

    /**
     * <p>
     * The identifier of the wireless device to get.
     * </p>
     * 
     * @return The identifier of the wireless device to get.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The type of identifier used in <code>identifier</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identifierType}
     * will return {@link WirelessDeviceIdType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #identifierTypeAsString}.
     * </p>
     * 
     * @return The type of identifier used in <code>identifier</code>.
     * @see WirelessDeviceIdType
     */
    public final WirelessDeviceIdType identifierType() {
        return WirelessDeviceIdType.fromValue(identifierType);
    }

    /**
     * <p>
     * The type of identifier used in <code>identifier</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #identifierType}
     * will return {@link WirelessDeviceIdType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #identifierTypeAsString}.
     * </p>
     * 
     * @return The type of identifier used in <code>identifier</code>.
     * @see WirelessDeviceIdType
     */
    public final String identifierTypeAsString() {
        return identifierType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(identifierTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWirelessDeviceRequest)) {
            return false;
        }
        GetWirelessDeviceRequest other = (GetWirelessDeviceRequest) obj;
        return Objects.equals(identifier(), other.identifier())
                && Objects.equals(identifierTypeAsString(), other.identifierTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWirelessDeviceRequest").add("Identifier", identifier())
                .add("IdentifierType", identifierTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "IdentifierType":
            return Optional.ofNullable(clazz.cast(identifierTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWirelessDeviceRequest, T> g) {
        return obj -> g.apply((GetWirelessDeviceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetWirelessDeviceRequest> {
        /**
         * <p>
         * The identifier of the wireless device to get.
         * </p>
         * 
         * @param identifier
         *        The identifier of the wireless device to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The type of identifier used in <code>identifier</code>.
         * </p>
         * 
         * @param identifierType
         *        The type of identifier used in <code>identifier</code>.
         * @see WirelessDeviceIdType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WirelessDeviceIdType
         */
        Builder identifierType(String identifierType);

        /**
         * <p>
         * The type of identifier used in <code>identifier</code>.
         * </p>
         * 
         * @param identifierType
         *        The type of identifier used in <code>identifier</code>.
         * @see WirelessDeviceIdType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WirelessDeviceIdType
         */
        Builder identifierType(WirelessDeviceIdType identifierType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotWirelessRequest.BuilderImpl implements Builder {
        private String identifier;

        private String identifierType;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWirelessDeviceRequest model) {
            super(model);
            identifier(model.identifier);
            identifierType(model.identifierType);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getIdentifierType() {
            return identifierType;
        }

        public final void setIdentifierType(String identifierType) {
            this.identifierType = identifierType;
        }

        @Override
        public final Builder identifierType(String identifierType) {
            this.identifierType = identifierType;
            return this;
        }

        @Override
        public final Builder identifierType(WirelessDeviceIdType identifierType) {
            this.identifierType(identifierType == null ? null : identifierType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetWirelessDeviceRequest build() {
            return new GetWirelessDeviceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
