/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteQueuedMessagesRequest extends IotWirelessRequest implements
        ToCopyableBuilder<DeleteQueuedMessagesRequest.Builder, DeleteQueuedMessagesRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(DeleteQueuedMessagesRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").build()).build();

    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageId").getter(getter(DeleteQueuedMessagesRequest::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("messageId").build()).build();

    private static final SdkField<String> WIRELESS_DEVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WirelessDeviceType").getter(getter(DeleteQueuedMessagesRequest::wirelessDeviceTypeAsString))
            .setter(setter(Builder::wirelessDeviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("WirelessDeviceType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, MESSAGE_ID_FIELD,
            WIRELESS_DEVICE_TYPE_FIELD));

    private final String id;

    private final String messageId;

    private final String wirelessDeviceType;

    private DeleteQueuedMessagesRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.messageId = builder.messageId;
        this.wirelessDeviceType = builder.wirelessDeviceType;
    }

    /**
     * <p>
     * The ID of a given wireless device for which downlink messages will be deleted.
     * </p>
     * 
     * @return The ID of a given wireless device for which downlink messages will be deleted.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * If message ID is <code>"*"</code>, it cleares the entire downlink queue for a given device, specified by the
     * wireless device ID. Otherwise, the downlink message with the specified message ID will be deleted.
     * </p>
     * 
     * @return If message ID is <code>"*"</code>, it cleares the entire downlink queue for a given device, specified by
     *         the wireless device ID. Otherwise, the downlink message with the specified message ID will be deleted.
     */
    public final String messageId() {
        return messageId;
    }

    /**
     * <p>
     * The wireless device type, which can be either Sidewalk or LoRaWAN.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #wirelessDeviceType} will return {@link WirelessDeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #wirelessDeviceTypeAsString}.
     * </p>
     * 
     * @return The wireless device type, which can be either Sidewalk or LoRaWAN.
     * @see WirelessDeviceType
     */
    public final WirelessDeviceType wirelessDeviceType() {
        return WirelessDeviceType.fromValue(wirelessDeviceType);
    }

    /**
     * <p>
     * The wireless device type, which can be either Sidewalk or LoRaWAN.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #wirelessDeviceType} will return {@link WirelessDeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #wirelessDeviceTypeAsString}.
     * </p>
     * 
     * @return The wireless device type, which can be either Sidewalk or LoRaWAN.
     * @see WirelessDeviceType
     */
    public final String wirelessDeviceTypeAsString() {
        return wirelessDeviceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(wirelessDeviceTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteQueuedMessagesRequest)) {
            return false;
        }
        DeleteQueuedMessagesRequest other = (DeleteQueuedMessagesRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(messageId(), other.messageId())
                && Objects.equals(wirelessDeviceTypeAsString(), other.wirelessDeviceTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteQueuedMessagesRequest").add("Id", id()).add("MessageId", messageId())
                .add("WirelessDeviceType", wirelessDeviceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "MessageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        case "WirelessDeviceType":
            return Optional.ofNullable(clazz.cast(wirelessDeviceTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteQueuedMessagesRequest, T> g) {
        return obj -> g.apply((DeleteQueuedMessagesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotWirelessRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteQueuedMessagesRequest> {
        /**
         * <p>
         * The ID of a given wireless device for which downlink messages will be deleted.
         * </p>
         * 
         * @param id
         *        The ID of a given wireless device for which downlink messages will be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * If message ID is <code>"*"</code>, it cleares the entire downlink queue for a given device, specified by the
         * wireless device ID. Otherwise, the downlink message with the specified message ID will be deleted.
         * </p>
         * 
         * @param messageId
         *        If message ID is <code>"*"</code>, it cleares the entire downlink queue for a given device, specified
         *        by the wireless device ID. Otherwise, the downlink message with the specified message ID will be
         *        deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * The wireless device type, which can be either Sidewalk or LoRaWAN.
         * </p>
         * 
         * @param wirelessDeviceType
         *        The wireless device type, which can be either Sidewalk or LoRaWAN.
         * @see WirelessDeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WirelessDeviceType
         */
        Builder wirelessDeviceType(String wirelessDeviceType);

        /**
         * <p>
         * The wireless device type, which can be either Sidewalk or LoRaWAN.
         * </p>
         * 
         * @param wirelessDeviceType
         *        The wireless device type, which can be either Sidewalk or LoRaWAN.
         * @see WirelessDeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WirelessDeviceType
         */
        Builder wirelessDeviceType(WirelessDeviceType wirelessDeviceType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotWirelessRequest.BuilderImpl implements Builder {
        private String id;

        private String messageId;

        private String wirelessDeviceType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteQueuedMessagesRequest model) {
            super(model);
            id(model.id);
            messageId(model.messageId);
            wirelessDeviceType(model.wirelessDeviceType);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getMessageId() {
            return messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final String getWirelessDeviceType() {
            return wirelessDeviceType;
        }

        public final void setWirelessDeviceType(String wirelessDeviceType) {
            this.wirelessDeviceType = wirelessDeviceType;
        }

        @Override
        public final Builder wirelessDeviceType(String wirelessDeviceType) {
            this.wirelessDeviceType = wirelessDeviceType;
            return this;
        }

        @Override
        public final Builder wirelessDeviceType(WirelessDeviceType wirelessDeviceType) {
            this.wirelessDeviceType(wirelessDeviceType == null ? null : wirelessDeviceType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteQueuedMessagesRequest build() {
            return new DeleteQueuedMessagesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
