/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * ABP device object for LoRaWAN specification v1.0.x
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AbpV1_0_x implements SdkPojo, Serializable, ToCopyableBuilder<AbpV1_0_x.Builder, AbpV1_0_x> {
    private static final SdkField<String> DEV_ADDR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DevAddr").getter(getter(AbpV1_0_x::devAddr)).setter(setter(Builder::devAddr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DevAddr").build()).build();

    private static final SdkField<SessionKeysAbpV1_0_x> SESSION_KEYS_FIELD = SdkField
            .<SessionKeysAbpV1_0_x> builder(MarshallingType.SDK_POJO).memberName("SessionKeys")
            .getter(getter(AbpV1_0_x::sessionKeys)).setter(setter(Builder::sessionKeys))
            .constructor(SessionKeysAbpV1_0_x::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionKeys").build()).build();

    private static final SdkField<Integer> F_CNT_START_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FCntStart").getter(getter(AbpV1_0_x::fCntStart)).setter(setter(Builder::fCntStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FCntStart").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEV_ADDR_FIELD,
            SESSION_KEYS_FIELD, F_CNT_START_FIELD));

    private static final long serialVersionUID = 1L;

    private final String devAddr;

    private final SessionKeysAbpV1_0_x sessionKeys;

    private final Integer fCntStart;

    private AbpV1_0_x(BuilderImpl builder) {
        this.devAddr = builder.devAddr;
        this.sessionKeys = builder.sessionKeys;
        this.fCntStart = builder.fCntStart;
    }

    /**
     * <p>
     * The DevAddr value.
     * </p>
     * 
     * @return The DevAddr value.
     */
    public final String devAddr() {
        return devAddr;
    }

    /**
     * <p>
     * Session keys for ABP v1.0.x
     * </p>
     * 
     * @return Session keys for ABP v1.0.x
     */
    public final SessionKeysAbpV1_0_x sessionKeys() {
        return sessionKeys;
    }

    /**
     * <p>
     * The FCnt init value.
     * </p>
     * 
     * @return The FCnt init value.
     */
    public final Integer fCntStart() {
        return fCntStart;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(devAddr());
        hashCode = 31 * hashCode + Objects.hashCode(sessionKeys());
        hashCode = 31 * hashCode + Objects.hashCode(fCntStart());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbpV1_0_x)) {
            return false;
        }
        AbpV1_0_x other = (AbpV1_0_x) obj;
        return Objects.equals(devAddr(), other.devAddr()) && Objects.equals(sessionKeys(), other.sessionKeys())
                && Objects.equals(fCntStart(), other.fCntStart());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AbpV1_0_x").add("DevAddr", devAddr()).add("SessionKeys", sessionKeys())
                .add("FCntStart", fCntStart()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DevAddr":
            return Optional.ofNullable(clazz.cast(devAddr()));
        case "SessionKeys":
            return Optional.ofNullable(clazz.cast(sessionKeys()));
        case "FCntStart":
            return Optional.ofNullable(clazz.cast(fCntStart()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AbpV1_0_x, T> g) {
        return obj -> g.apply((AbpV1_0_x) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AbpV1_0_x> {
        /**
         * <p>
         * The DevAddr value.
         * </p>
         * 
         * @param devAddr
         *        The DevAddr value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devAddr(String devAddr);

        /**
         * <p>
         * Session keys for ABP v1.0.x
         * </p>
         * 
         * @param sessionKeys
         *        Session keys for ABP v1.0.x
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionKeys(SessionKeysAbpV1_0_x sessionKeys);

        /**
         * <p>
         * Session keys for ABP v1.0.x
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionKeysAbpV1_0_x.Builder} avoiding
         * the need to create one manually via {@link SessionKeysAbpV1_0_x#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionKeysAbpV1_0_x.Builder#build()} is called immediately and
         * its result is passed to {@link #sessionKeys(SessionKeysAbpV1_0_x)}.
         * 
         * @param sessionKeys
         *        a consumer that will call methods on {@link SessionKeysAbpV1_0_x.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionKeys(SessionKeysAbpV1_0_x)
         */
        default Builder sessionKeys(Consumer<SessionKeysAbpV1_0_x.Builder> sessionKeys) {
            return sessionKeys(SessionKeysAbpV1_0_x.builder().applyMutation(sessionKeys).build());
        }

        /**
         * <p>
         * The FCnt init value.
         * </p>
         * 
         * @param fCntStart
         *        The FCnt init value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fCntStart(Integer fCntStart);
    }

    static final class BuilderImpl implements Builder {
        private String devAddr;

        private SessionKeysAbpV1_0_x sessionKeys;

        private Integer fCntStart;

        private BuilderImpl() {
        }

        private BuilderImpl(AbpV1_0_x model) {
            devAddr(model.devAddr);
            sessionKeys(model.sessionKeys);
            fCntStart(model.fCntStart);
        }

        public final String getDevAddr() {
            return devAddr;
        }

        public final void setDevAddr(String devAddr) {
            this.devAddr = devAddr;
        }

        @Override
        public final Builder devAddr(String devAddr) {
            this.devAddr = devAddr;
            return this;
        }

        public final SessionKeysAbpV1_0_x.Builder getSessionKeys() {
            return sessionKeys != null ? sessionKeys.toBuilder() : null;
        }

        public final void setSessionKeys(SessionKeysAbpV1_0_x.BuilderImpl sessionKeys) {
            this.sessionKeys = sessionKeys != null ? sessionKeys.build() : null;
        }

        @Override
        public final Builder sessionKeys(SessionKeysAbpV1_0_x sessionKeys) {
            this.sessionKeys = sessionKeys;
            return this;
        }

        public final Integer getFCntStart() {
            return fCntStart;
        }

        public final void setFCntStart(Integer fCntStart) {
            this.fCntStart = fCntStart;
        }

        @Override
        public final Builder fCntStart(Integer fCntStart) {
            this.fCntStart = fCntStart;
            return this;
        }

        @Override
        public AbpV1_0_x build() {
            return new AbpV1_0_x(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
