/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotwireless.IotWirelessClient;
import software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksRequest;
import software.amazon.awssdk.services.iotwireless.model.ListFuotaTasksResponse;

public class ListFuotaTasksIterable
implements SdkIterable<ListFuotaTasksResponse> {
    private final IotWirelessClient client;
    private final ListFuotaTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFuotaTasksIterable(IotWirelessClient client, ListFuotaTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFuotaTasksResponseFetcher();
    }

    public Iterator<ListFuotaTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListFuotaTasksResponseFetcher
    implements SyncPageFetcher<ListFuotaTasksResponse> {
        private ListFuotaTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListFuotaTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFuotaTasksResponse nextPage(ListFuotaTasksResponse previousPage) {
            if (previousPage == null) {
                return ListFuotaTasksIterable.this.client.listFuotaTasks(ListFuotaTasksIterable.this.firstRequest);
            }
            return ListFuotaTasksIterable.this.client.listFuotaTasks((ListFuotaTasksRequest)((Object)ListFuotaTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

