/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DownlinkMode {
    SEQUENTIAL("SEQUENTIAL"),
    CONCURRENT("CONCURRENT"),
    USING_UPLINK_GATEWAY("USING_UPLINK_GATEWAY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DownlinkMode> VALUE_MAP;
    private final String value;

    private DownlinkMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DownlinkMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DownlinkMode> knownValues() {
        EnumSet<DownlinkMode> knownValues = EnumSet.allOf(DownlinkMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DownlinkMode.class, DownlinkMode::toString);
    }
}

