/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.services.iotwireless.model.TraceContent;
import software.amazon.awssdk.services.iotwireless.model.WirelessDeviceListCopier;
import software.amazon.awssdk.services.iotwireless.model.WirelessGatewayListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetNetworkAnalyzerConfigurationResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, GetNetworkAnalyzerConfigurationResponse> {
    private static final SdkField<TraceContent> TRACE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TraceContent").getter(GetNetworkAnalyzerConfigurationResponse.getter(GetNetworkAnalyzerConfigurationResponse::traceContent)).setter(GetNetworkAnalyzerConfigurationResponse.setter(Builder::traceContent)).constructor(TraceContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceContent").build()}).build();
    private static final SdkField<List<String>> WIRELESS_DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WirelessDevices").getter(GetNetworkAnalyzerConfigurationResponse.getter(GetNetworkAnalyzerConfigurationResponse::wirelessDevices)).setter(GetNetworkAnalyzerConfigurationResponse.setter(Builder::wirelessDevices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessDevices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> WIRELESS_GATEWAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WirelessGateways").getter(GetNetworkAnalyzerConfigurationResponse.getter(GetNetworkAnalyzerConfigurationResponse::wirelessGateways)).setter(GetNetworkAnalyzerConfigurationResponse.setter(Builder::wirelessGateways)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessGateways").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetNetworkAnalyzerConfigurationResponse.getter(GetNetworkAnalyzerConfigurationResponse::description)).setter(GetNetworkAnalyzerConfigurationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetNetworkAnalyzerConfigurationResponse.getter(GetNetworkAnalyzerConfigurationResponse::arn)).setter(GetNetworkAnalyzerConfigurationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetNetworkAnalyzerConfigurationResponse.getter(GetNetworkAnalyzerConfigurationResponse::name)).setter(GetNetworkAnalyzerConfigurationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACE_CONTENT_FIELD, WIRELESS_DEVICES_FIELD, WIRELESS_GATEWAYS_FIELD, DESCRIPTION_FIELD, ARN_FIELD, NAME_FIELD));
    private final TraceContent traceContent;
    private final List<String> wirelessDevices;
    private final List<String> wirelessGateways;
    private final String description;
    private final String arn;
    private final String name;

    private GetNetworkAnalyzerConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.traceContent = builder.traceContent;
        this.wirelessDevices = builder.wirelessDevices;
        this.wirelessGateways = builder.wirelessGateways;
        this.description = builder.description;
        this.arn = builder.arn;
        this.name = builder.name;
    }

    public final TraceContent traceContent() {
        return this.traceContent;
    }

    public final boolean hasWirelessDevices() {
        return this.wirelessDevices != null && !(this.wirelessDevices instanceof SdkAutoConstructList);
    }

    public final List<String> wirelessDevices() {
        return this.wirelessDevices;
    }

    public final boolean hasWirelessGateways() {
        return this.wirelessGateways != null && !(this.wirelessGateways instanceof SdkAutoConstructList);
    }

    public final List<String> wirelessGateways() {
        return this.wirelessGateways;
    }

    public final String description() {
        return this.description;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.traceContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWirelessDevices() ? this.wirelessDevices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWirelessGateways() ? this.wirelessGateways() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNetworkAnalyzerConfigurationResponse)) {
            return false;
        }
        GetNetworkAnalyzerConfigurationResponse other = (GetNetworkAnalyzerConfigurationResponse)((Object)obj);
        return Objects.equals(this.traceContent(), other.traceContent()) && this.hasWirelessDevices() == other.hasWirelessDevices() && Objects.equals(this.wirelessDevices(), other.wirelessDevices()) && this.hasWirelessGateways() == other.hasWirelessGateways() && Objects.equals(this.wirelessGateways(), other.wirelessGateways()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"GetNetworkAnalyzerConfigurationResponse").add("TraceContent", (Object)this.traceContent()).add("WirelessDevices", this.hasWirelessDevices() ? this.wirelessDevices() : null).add("WirelessGateways", this.hasWirelessGateways() ? this.wirelessGateways() : null).add("Description", (Object)this.description()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TraceContent": {
                return Optional.ofNullable(clazz.cast(this.traceContent()));
            }
            case "WirelessDevices": {
                return Optional.ofNullable(clazz.cast(this.wirelessDevices()));
            }
            case "WirelessGateways": {
                return Optional.ofNullable(clazz.cast(this.wirelessGateways()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetNetworkAnalyzerConfigurationResponse, T> g) {
        return obj -> g.apply((GetNetworkAnalyzerConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private TraceContent traceContent;
        private List<String> wirelessDevices = DefaultSdkAutoConstructList.getInstance();
        private List<String> wirelessGateways = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String arn;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNetworkAnalyzerConfigurationResponse model) {
            super(model);
            this.traceContent(model.traceContent);
            this.wirelessDevices(model.wirelessDevices);
            this.wirelessGateways(model.wirelessGateways);
            this.description(model.description);
            this.arn(model.arn);
            this.name(model.name);
        }

        public final TraceContent.Builder getTraceContent() {
            return this.traceContent != null ? this.traceContent.toBuilder() : null;
        }

        public final void setTraceContent(TraceContent.BuilderImpl traceContent) {
            this.traceContent = traceContent != null ? traceContent.build() : null;
        }

        @Override
        public final Builder traceContent(TraceContent traceContent) {
            this.traceContent = traceContent;
            return this;
        }

        public final Collection<String> getWirelessDevices() {
            if (this.wirelessDevices instanceof SdkAutoConstructList) {
                return null;
            }
            return this.wirelessDevices;
        }

        public final void setWirelessDevices(Collection<String> wirelessDevices) {
            this.wirelessDevices = WirelessDeviceListCopier.copy(wirelessDevices);
        }

        @Override
        public final Builder wirelessDevices(Collection<String> wirelessDevices) {
            this.wirelessDevices = WirelessDeviceListCopier.copy(wirelessDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessDevices(String ... wirelessDevices) {
            this.wirelessDevices(Arrays.asList(wirelessDevices));
            return this;
        }

        public final Collection<String> getWirelessGateways() {
            if (this.wirelessGateways instanceof SdkAutoConstructList) {
                return null;
            }
            return this.wirelessGateways;
        }

        public final void setWirelessGateways(Collection<String> wirelessGateways) {
            this.wirelessGateways = WirelessGatewayListCopier.copy(wirelessGateways);
        }

        @Override
        public final Builder wirelessGateways(Collection<String> wirelessGateways) {
            this.wirelessGateways = WirelessGatewayListCopier.copy(wirelessGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessGateways(String ... wirelessGateways) {
            this.wirelessGateways(Arrays.asList(wirelessGateways));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public GetNetworkAnalyzerConfigurationResponse build() {
            return new GetNetworkAnalyzerConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetNetworkAnalyzerConfigurationResponse> {
        public Builder traceContent(TraceContent var1);

        default public Builder traceContent(Consumer<TraceContent.Builder> traceContent) {
            return this.traceContent((TraceContent)((TraceContent.Builder)TraceContent.builder().applyMutation(traceContent)).build());
        }

        public Builder wirelessDevices(Collection<String> var1);

        public Builder wirelessDevices(String ... var1);

        public Builder wirelessGateways(Collection<String> var1);

        public Builder wirelessGateways(String ... var1);

        public Builder description(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);
    }
}

