/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.CertificateList;
import software.amazon.awssdk.services.iotwireless.model.DeviceCertificateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SidewalkDevice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SidewalkDevice> {
    private static final SdkField<String> AMAZON_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmazonId").getter(SidewalkDevice.getter(SidewalkDevice::amazonId)).setter(SidewalkDevice.setter(Builder::amazonId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonId").build()}).build();
    private static final SdkField<String> SIDEWALK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SidewalkId").getter(SidewalkDevice.getter(SidewalkDevice::sidewalkId)).setter(SidewalkDevice.setter(Builder::sidewalkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SidewalkId").build()}).build();
    private static final SdkField<String> SIDEWALK_MANUFACTURING_SN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SidewalkManufacturingSn").getter(SidewalkDevice.getter(SidewalkDevice::sidewalkManufacturingSn)).setter(SidewalkDevice.setter(Builder::sidewalkManufacturingSn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SidewalkManufacturingSn").build()}).build();
    private static final SdkField<List<CertificateList>> DEVICE_CERTIFICATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeviceCertificates").getter(SidewalkDevice.getter(SidewalkDevice::deviceCertificates)).setter(SidewalkDevice.setter(Builder::deviceCertificates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceCertificates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CertificateList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMAZON_ID_FIELD, SIDEWALK_ID_FIELD, SIDEWALK_MANUFACTURING_SN_FIELD, DEVICE_CERTIFICATES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String amazonId;
    private final String sidewalkId;
    private final String sidewalkManufacturingSn;
    private final List<CertificateList> deviceCertificates;

    private SidewalkDevice(BuilderImpl builder) {
        this.amazonId = builder.amazonId;
        this.sidewalkId = builder.sidewalkId;
        this.sidewalkManufacturingSn = builder.sidewalkManufacturingSn;
        this.deviceCertificates = builder.deviceCertificates;
    }

    public final String amazonId() {
        return this.amazonId;
    }

    public final String sidewalkId() {
        return this.sidewalkId;
    }

    public final String sidewalkManufacturingSn() {
        return this.sidewalkManufacturingSn;
    }

    public final boolean hasDeviceCertificates() {
        return this.deviceCertificates != null && !(this.deviceCertificates instanceof SdkAutoConstructList);
    }

    public final List<CertificateList> deviceCertificates() {
        return this.deviceCertificates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sidewalkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sidewalkManufacturingSn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeviceCertificates() ? this.deviceCertificates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SidewalkDevice)) {
            return false;
        }
        SidewalkDevice other = (SidewalkDevice)obj;
        return Objects.equals(this.amazonId(), other.amazonId()) && Objects.equals(this.sidewalkId(), other.sidewalkId()) && Objects.equals(this.sidewalkManufacturingSn(), other.sidewalkManufacturingSn()) && this.hasDeviceCertificates() == other.hasDeviceCertificates() && Objects.equals(this.deviceCertificates(), other.deviceCertificates());
    }

    public final String toString() {
        return ToString.builder((String)"SidewalkDevice").add("AmazonId", (Object)this.amazonId()).add("SidewalkId", (Object)this.sidewalkId()).add("SidewalkManufacturingSn", (Object)this.sidewalkManufacturingSn()).add("DeviceCertificates", this.hasDeviceCertificates() ? this.deviceCertificates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmazonId": {
                return Optional.ofNullable(clazz.cast(this.amazonId()));
            }
            case "SidewalkId": {
                return Optional.ofNullable(clazz.cast(this.sidewalkId()));
            }
            case "SidewalkManufacturingSn": {
                return Optional.ofNullable(clazz.cast(this.sidewalkManufacturingSn()));
            }
            case "DeviceCertificates": {
                return Optional.ofNullable(clazz.cast(this.deviceCertificates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SidewalkDevice, T> g) {
        return obj -> g.apply((SidewalkDevice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String amazonId;
        private String sidewalkId;
        private String sidewalkManufacturingSn;
        private List<CertificateList> deviceCertificates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SidewalkDevice model) {
            this.amazonId(model.amazonId);
            this.sidewalkId(model.sidewalkId);
            this.sidewalkManufacturingSn(model.sidewalkManufacturingSn);
            this.deviceCertificates(model.deviceCertificates);
        }

        public final String getAmazonId() {
            return this.amazonId;
        }

        public final void setAmazonId(String amazonId) {
            this.amazonId = amazonId;
        }

        @Override
        public final Builder amazonId(String amazonId) {
            this.amazonId = amazonId;
            return this;
        }

        public final String getSidewalkId() {
            return this.sidewalkId;
        }

        public final void setSidewalkId(String sidewalkId) {
            this.sidewalkId = sidewalkId;
        }

        @Override
        public final Builder sidewalkId(String sidewalkId) {
            this.sidewalkId = sidewalkId;
            return this;
        }

        public final String getSidewalkManufacturingSn() {
            return this.sidewalkManufacturingSn;
        }

        public final void setSidewalkManufacturingSn(String sidewalkManufacturingSn) {
            this.sidewalkManufacturingSn = sidewalkManufacturingSn;
        }

        @Override
        public final Builder sidewalkManufacturingSn(String sidewalkManufacturingSn) {
            this.sidewalkManufacturingSn = sidewalkManufacturingSn;
            return this;
        }

        public final List<CertificateList.Builder> getDeviceCertificates() {
            List<CertificateList.Builder> result = DeviceCertificateListCopier.copyToBuilder(this.deviceCertificates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeviceCertificates(Collection<CertificateList.BuilderImpl> deviceCertificates) {
            this.deviceCertificates = DeviceCertificateListCopier.copyFromBuilder(deviceCertificates);
        }

        @Override
        public final Builder deviceCertificates(Collection<CertificateList> deviceCertificates) {
            this.deviceCertificates = DeviceCertificateListCopier.copy(deviceCertificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceCertificates(CertificateList ... deviceCertificates) {
            this.deviceCertificates(Arrays.asList(deviceCertificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceCertificates(Consumer<CertificateList.Builder> ... deviceCertificates) {
            this.deviceCertificates(Stream.of(deviceCertificates).map(c -> (CertificateList)((CertificateList.Builder)CertificateList.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SidewalkDevice build() {
            return new SidewalkDevice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SidewalkDevice> {
        public Builder amazonId(String var1);

        public Builder sidewalkId(String var1);

        public Builder sidewalkManufacturingSn(String var1);

        public Builder deviceCertificates(Collection<CertificateList> var1);

        public Builder deviceCertificates(CertificateList ... var1);

        public Builder deviceCertificates(Consumer<CertificateList.Builder> ... var1);
    }
}

