/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.UpdateAbpV1_0_x;
import software.amazon.awssdk.services.iotwireless.model.UpdateAbpV1_1;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoRaWANUpdateDevice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoRaWANUpdateDevice> {
    private static final SdkField<String> DEVICE_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceProfileId").getter(LoRaWANUpdateDevice.getter(LoRaWANUpdateDevice::deviceProfileId)).setter(LoRaWANUpdateDevice.setter(Builder::deviceProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceProfileId").build()}).build();
    private static final SdkField<String> SERVICE_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceProfileId").getter(LoRaWANUpdateDevice.getter(LoRaWANUpdateDevice::serviceProfileId)).setter(LoRaWANUpdateDevice.setter(Builder::serviceProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceProfileId").build()}).build();
    private static final SdkField<UpdateAbpV1_1> ABP_V1_1_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AbpV1_1").getter(LoRaWANUpdateDevice.getter(LoRaWANUpdateDevice::abpV1_1)).setter(LoRaWANUpdateDevice.setter(Builder::abpV1_1)).constructor(UpdateAbpV1_1::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbpV1_1").build()}).build();
    private static final SdkField<UpdateAbpV1_0_x> ABP_V1_0_X_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AbpV1_0_x").getter(LoRaWANUpdateDevice.getter(LoRaWANUpdateDevice::abpV1_0_x)).setter(LoRaWANUpdateDevice.setter(Builder::abpV1_0_x)).constructor(UpdateAbpV1_0_x::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbpV1_0_x").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_PROFILE_ID_FIELD, SERVICE_PROFILE_ID_FIELD, ABP_V1_1_FIELD, ABP_V1_0_X_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deviceProfileId;
    private final String serviceProfileId;
    private final UpdateAbpV1_1 abpV1_1;
    private final UpdateAbpV1_0_x abpV1_0_x;

    private LoRaWANUpdateDevice(BuilderImpl builder) {
        this.deviceProfileId = builder.deviceProfileId;
        this.serviceProfileId = builder.serviceProfileId;
        this.abpV1_1 = builder.abpV1_1;
        this.abpV1_0_x = builder.abpV1_0_x;
    }

    public final String deviceProfileId() {
        return this.deviceProfileId;
    }

    public final String serviceProfileId() {
        return this.serviceProfileId;
    }

    public final UpdateAbpV1_1 abpV1_1() {
        return this.abpV1_1;
    }

    public final UpdateAbpV1_0_x abpV1_0_x() {
        return this.abpV1_0_x;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.abpV1_1());
        hashCode = 31 * hashCode + Objects.hashCode(this.abpV1_0_x());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANUpdateDevice)) {
            return false;
        }
        LoRaWANUpdateDevice other = (LoRaWANUpdateDevice)obj;
        return Objects.equals(this.deviceProfileId(), other.deviceProfileId()) && Objects.equals(this.serviceProfileId(), other.serviceProfileId()) && Objects.equals(this.abpV1_1(), other.abpV1_1()) && Objects.equals(this.abpV1_0_x(), other.abpV1_0_x());
    }

    public final String toString() {
        return ToString.builder((String)"LoRaWANUpdateDevice").add("DeviceProfileId", (Object)this.deviceProfileId()).add("ServiceProfileId", (Object)this.serviceProfileId()).add("AbpV1_1", (Object)this.abpV1_1()).add("AbpV1_0_x", (Object)this.abpV1_0_x()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceProfileId": {
                return Optional.ofNullable(clazz.cast(this.deviceProfileId()));
            }
            case "ServiceProfileId": {
                return Optional.ofNullable(clazz.cast(this.serviceProfileId()));
            }
            case "AbpV1_1": {
                return Optional.ofNullable(clazz.cast(this.abpV1_1()));
            }
            case "AbpV1_0_x": {
                return Optional.ofNullable(clazz.cast(this.abpV1_0_x()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANUpdateDevice, T> g) {
        return obj -> g.apply((LoRaWANUpdateDevice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceProfileId;
        private String serviceProfileId;
        private UpdateAbpV1_1 abpV1_1;
        private UpdateAbpV1_0_x abpV1_0_x;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANUpdateDevice model) {
            this.deviceProfileId(model.deviceProfileId);
            this.serviceProfileId(model.serviceProfileId);
            this.abpV1_1(model.abpV1_1);
            this.abpV1_0_x(model.abpV1_0_x);
        }

        public final String getDeviceProfileId() {
            return this.deviceProfileId;
        }

        public final void setDeviceProfileId(String deviceProfileId) {
            this.deviceProfileId = deviceProfileId;
        }

        @Override
        public final Builder deviceProfileId(String deviceProfileId) {
            this.deviceProfileId = deviceProfileId;
            return this;
        }

        public final String getServiceProfileId() {
            return this.serviceProfileId;
        }

        public final void setServiceProfileId(String serviceProfileId) {
            this.serviceProfileId = serviceProfileId;
        }

        @Override
        public final Builder serviceProfileId(String serviceProfileId) {
            this.serviceProfileId = serviceProfileId;
            return this;
        }

        public final UpdateAbpV1_1.Builder getAbpV1_1() {
            return this.abpV1_1 != null ? this.abpV1_1.toBuilder() : null;
        }

        public final void setAbpV1_1(UpdateAbpV1_1.BuilderImpl abpV1_1) {
            this.abpV1_1 = abpV1_1 != null ? abpV1_1.build() : null;
        }

        @Override
        public final Builder abpV1_1(UpdateAbpV1_1 abpV1_1) {
            this.abpV1_1 = abpV1_1;
            return this;
        }

        public final UpdateAbpV1_0_x.Builder getAbpV1_0_x() {
            return this.abpV1_0_x != null ? this.abpV1_0_x.toBuilder() : null;
        }

        public final void setAbpV1_0_x(UpdateAbpV1_0_x.BuilderImpl abpV1_0_x) {
            this.abpV1_0_x = abpV1_0_x != null ? abpV1_0_x.build() : null;
        }

        @Override
        public final Builder abpV1_0_x(UpdateAbpV1_0_x abpV1_0_x) {
            this.abpV1_0_x = abpV1_0_x;
            return this;
        }

        public LoRaWANUpdateDevice build() {
            return new LoRaWANUpdateDevice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoRaWANUpdateDevice> {
        public Builder deviceProfileId(String var1);

        public Builder serviceProfileId(String var1);

        public Builder abpV1_1(UpdateAbpV1_1 var1);

        default public Builder abpV1_1(Consumer<UpdateAbpV1_1.Builder> abpV1_1) {
            return this.abpV1_1((UpdateAbpV1_1)((UpdateAbpV1_1.Builder)UpdateAbpV1_1.builder().applyMutation(abpV1_1)).build());
        }

        public Builder abpV1_0_x(UpdateAbpV1_0_x var1);

        default public Builder abpV1_0_x(Consumer<UpdateAbpV1_0_x.Builder> abpV1_0_x) {
            return this.abpV1_0_x((UpdateAbpV1_0_x)((UpdateAbpV1_0_x.Builder)UpdateAbpV1_0_x.builder().applyMutation(abpV1_0_x)).build());
        }
    }
}

