/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.DeviceRegistrationStateEventConfiguration;
import software.amazon.awssdk.services.iotwireless.model.EventNotificationPartnerType;
import software.amazon.awssdk.services.iotwireless.model.IdentifierType;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessRequest;
import software.amazon.awssdk.services.iotwireless.model.ProximityEventConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateResourceEventConfigurationRequest
extends IotWirelessRequest
implements ToCopyableBuilder<Builder, UpdateResourceEventConfigurationRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(UpdateResourceEventConfigurationRequest.getter(UpdateResourceEventConfigurationRequest::identifier)).setter(UpdateResourceEventConfigurationRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Identifier").build()}).build();
    private static final SdkField<String> IDENTIFIER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentifierType").getter(UpdateResourceEventConfigurationRequest.getter(UpdateResourceEventConfigurationRequest::identifierTypeAsString)).setter(UpdateResourceEventConfigurationRequest.setter(Builder::identifierType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("identifierType").build()}).build();
    private static final SdkField<String> PARTNER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartnerType").getter(UpdateResourceEventConfigurationRequest.getter(UpdateResourceEventConfigurationRequest::partnerTypeAsString)).setter(UpdateResourceEventConfigurationRequest.setter(Builder::partnerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("partnerType").build()}).build();
    private static final SdkField<DeviceRegistrationStateEventConfiguration> DEVICE_REGISTRATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeviceRegistrationState").getter(UpdateResourceEventConfigurationRequest.getter(UpdateResourceEventConfigurationRequest::deviceRegistrationState)).setter(UpdateResourceEventConfigurationRequest.setter(Builder::deviceRegistrationState)).constructor(DeviceRegistrationStateEventConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceRegistrationState").build()}).build();
    private static final SdkField<ProximityEventConfiguration> PROXIMITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Proximity").getter(UpdateResourceEventConfigurationRequest.getter(UpdateResourceEventConfigurationRequest::proximity)).setter(UpdateResourceEventConfigurationRequest.setter(Builder::proximity)).constructor(ProximityEventConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Proximity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, IDENTIFIER_TYPE_FIELD, PARTNER_TYPE_FIELD, DEVICE_REGISTRATION_STATE_FIELD, PROXIMITY_FIELD));
    private final String identifier;
    private final String identifierType;
    private final String partnerType;
    private final DeviceRegistrationStateEventConfiguration deviceRegistrationState;
    private final ProximityEventConfiguration proximity;

    private UpdateResourceEventConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.identifierType = builder.identifierType;
        this.partnerType = builder.partnerType;
        this.deviceRegistrationState = builder.deviceRegistrationState;
        this.proximity = builder.proximity;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final IdentifierType identifierType() {
        return IdentifierType.fromValue(this.identifierType);
    }

    public final String identifierTypeAsString() {
        return this.identifierType;
    }

    public final EventNotificationPartnerType partnerType() {
        return EventNotificationPartnerType.fromValue(this.partnerType);
    }

    public final String partnerTypeAsString() {
        return this.partnerType;
    }

    public final DeviceRegistrationStateEventConfiguration deviceRegistrationState() {
        return this.deviceRegistrationState;
    }

    public final ProximityEventConfiguration proximity() {
        return this.proximity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifierTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.partnerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceRegistrationState());
        hashCode = 31 * hashCode + Objects.hashCode(this.proximity());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourceEventConfigurationRequest)) {
            return false;
        }
        UpdateResourceEventConfigurationRequest other = (UpdateResourceEventConfigurationRequest)((Object)obj);
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.identifierTypeAsString(), other.identifierTypeAsString()) && Objects.equals(this.partnerTypeAsString(), other.partnerTypeAsString()) && Objects.equals(this.deviceRegistrationState(), other.deviceRegistrationState()) && Objects.equals(this.proximity(), other.proximity());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateResourceEventConfigurationRequest").add("Identifier", (Object)this.identifier()).add("IdentifierType", (Object)this.identifierTypeAsString()).add("PartnerType", (Object)this.partnerTypeAsString()).add("DeviceRegistrationState", (Object)this.deviceRegistrationState()).add("Proximity", (Object)this.proximity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "IdentifierType": {
                return Optional.ofNullable(clazz.cast(this.identifierTypeAsString()));
            }
            case "PartnerType": {
                return Optional.ofNullable(clazz.cast(this.partnerTypeAsString()));
            }
            case "DeviceRegistrationState": {
                return Optional.ofNullable(clazz.cast(this.deviceRegistrationState()));
            }
            case "Proximity": {
                return Optional.ofNullable(clazz.cast(this.proximity()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateResourceEventConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateResourceEventConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessRequest.BuilderImpl
    implements Builder {
        private String identifier;
        private String identifierType;
        private String partnerType;
        private DeviceRegistrationStateEventConfiguration deviceRegistrationState;
        private ProximityEventConfiguration proximity;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResourceEventConfigurationRequest model) {
            super(model);
            this.identifier(model.identifier);
            this.identifierType(model.identifierType);
            this.partnerType(model.partnerType);
            this.deviceRegistrationState(model.deviceRegistrationState);
            this.proximity(model.proximity);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getIdentifierType() {
            return this.identifierType;
        }

        public final void setIdentifierType(String identifierType) {
            this.identifierType = identifierType;
        }

        @Override
        public final Builder identifierType(String identifierType) {
            this.identifierType = identifierType;
            return this;
        }

        @Override
        public final Builder identifierType(IdentifierType identifierType) {
            this.identifierType(identifierType == null ? null : identifierType.toString());
            return this;
        }

        public final String getPartnerType() {
            return this.partnerType;
        }

        public final void setPartnerType(String partnerType) {
            this.partnerType = partnerType;
        }

        @Override
        public final Builder partnerType(String partnerType) {
            this.partnerType = partnerType;
            return this;
        }

        @Override
        public final Builder partnerType(EventNotificationPartnerType partnerType) {
            this.partnerType(partnerType == null ? null : partnerType.toString());
            return this;
        }

        public final DeviceRegistrationStateEventConfiguration.Builder getDeviceRegistrationState() {
            return this.deviceRegistrationState != null ? this.deviceRegistrationState.toBuilder() : null;
        }

        public final void setDeviceRegistrationState(DeviceRegistrationStateEventConfiguration.BuilderImpl deviceRegistrationState) {
            this.deviceRegistrationState = deviceRegistrationState != null ? deviceRegistrationState.build() : null;
        }

        @Override
        public final Builder deviceRegistrationState(DeviceRegistrationStateEventConfiguration deviceRegistrationState) {
            this.deviceRegistrationState = deviceRegistrationState;
            return this;
        }

        public final ProximityEventConfiguration.Builder getProximity() {
            return this.proximity != null ? this.proximity.toBuilder() : null;
        }

        public final void setProximity(ProximityEventConfiguration.BuilderImpl proximity) {
            this.proximity = proximity != null ? proximity.build() : null;
        }

        @Override
        public final Builder proximity(ProximityEventConfiguration proximity) {
            this.proximity = proximity;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResourceEventConfigurationRequest build() {
            return new UpdateResourceEventConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotWirelessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateResourceEventConfigurationRequest> {
        public Builder identifier(String var1);

        public Builder identifierType(String var1);

        public Builder identifierType(IdentifierType var1);

        public Builder partnerType(String var1);

        public Builder partnerType(EventNotificationPartnerType var1);

        public Builder deviceRegistrationState(DeviceRegistrationStateEventConfiguration var1);

        default public Builder deviceRegistrationState(Consumer<DeviceRegistrationStateEventConfiguration.Builder> deviceRegistrationState) {
            return this.deviceRegistrationState((DeviceRegistrationStateEventConfiguration)((DeviceRegistrationStateEventConfiguration.Builder)DeviceRegistrationStateEventConfiguration.builder().applyMutation(deviceRegistrationState)).build());
        }

        public Builder proximity(ProximityEventConfiguration var1);

        default public Builder proximity(Consumer<ProximityEventConfiguration.Builder> proximity) {
            return this.proximity((ProximityEventConfiguration)((ProximityEventConfiguration.Builder)ProximityEventConfiguration.builder().applyMutation(proximity)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

