/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.services.iotwireless.model.WirelessGatewayTaskStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWirelessGatewayTaskResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, GetWirelessGatewayTaskResponse> {
    private static final SdkField<String> WIRELESS_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WirelessGatewayId").getter(GetWirelessGatewayTaskResponse.getter(GetWirelessGatewayTaskResponse::wirelessGatewayId)).setter(GetWirelessGatewayTaskResponse.setter(Builder::wirelessGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessGatewayId").build()}).build();
    private static final SdkField<String> WIRELESS_GATEWAY_TASK_DEFINITION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WirelessGatewayTaskDefinitionId").getter(GetWirelessGatewayTaskResponse.getter(GetWirelessGatewayTaskResponse::wirelessGatewayTaskDefinitionId)).setter(GetWirelessGatewayTaskResponse.setter(Builder::wirelessGatewayTaskDefinitionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessGatewayTaskDefinitionId").build()}).build();
    private static final SdkField<String> LAST_UPLINK_RECEIVED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastUplinkReceivedAt").getter(GetWirelessGatewayTaskResponse.getter(GetWirelessGatewayTaskResponse::lastUplinkReceivedAt)).setter(GetWirelessGatewayTaskResponse.setter(Builder::lastUplinkReceivedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUplinkReceivedAt").build()}).build();
    private static final SdkField<String> TASK_CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskCreatedAt").getter(GetWirelessGatewayTaskResponse.getter(GetWirelessGatewayTaskResponse::taskCreatedAt)).setter(GetWirelessGatewayTaskResponse.setter(Builder::taskCreatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskCreatedAt").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetWirelessGatewayTaskResponse.getter(GetWirelessGatewayTaskResponse::statusAsString)).setter(GetWirelessGatewayTaskResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WIRELESS_GATEWAY_ID_FIELD, WIRELESS_GATEWAY_TASK_DEFINITION_ID_FIELD, LAST_UPLINK_RECEIVED_AT_FIELD, TASK_CREATED_AT_FIELD, STATUS_FIELD));
    private final String wirelessGatewayId;
    private final String wirelessGatewayTaskDefinitionId;
    private final String lastUplinkReceivedAt;
    private final String taskCreatedAt;
    private final String status;

    private GetWirelessGatewayTaskResponse(BuilderImpl builder) {
        super(builder);
        this.wirelessGatewayId = builder.wirelessGatewayId;
        this.wirelessGatewayTaskDefinitionId = builder.wirelessGatewayTaskDefinitionId;
        this.lastUplinkReceivedAt = builder.lastUplinkReceivedAt;
        this.taskCreatedAt = builder.taskCreatedAt;
        this.status = builder.status;
    }

    public final String wirelessGatewayId() {
        return this.wirelessGatewayId;
    }

    public final String wirelessGatewayTaskDefinitionId() {
        return this.wirelessGatewayTaskDefinitionId;
    }

    public final String lastUplinkReceivedAt() {
        return this.lastUplinkReceivedAt;
    }

    public final String taskCreatedAt() {
        return this.taskCreatedAt;
    }

    public final WirelessGatewayTaskStatus status() {
        return WirelessGatewayTaskStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.wirelessGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.wirelessGatewayTaskDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUplinkReceivedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWirelessGatewayTaskResponse)) {
            return false;
        }
        GetWirelessGatewayTaskResponse other = (GetWirelessGatewayTaskResponse)((Object)obj);
        return Objects.equals(this.wirelessGatewayId(), other.wirelessGatewayId()) && Objects.equals(this.wirelessGatewayTaskDefinitionId(), other.wirelessGatewayTaskDefinitionId()) && Objects.equals(this.lastUplinkReceivedAt(), other.lastUplinkReceivedAt()) && Objects.equals(this.taskCreatedAt(), other.taskCreatedAt()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetWirelessGatewayTaskResponse").add("WirelessGatewayId", (Object)this.wirelessGatewayId()).add("WirelessGatewayTaskDefinitionId", (Object)this.wirelessGatewayTaskDefinitionId()).add("LastUplinkReceivedAt", (Object)this.lastUplinkReceivedAt()).add("TaskCreatedAt", (Object)this.taskCreatedAt()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WirelessGatewayId": {
                return Optional.ofNullable(clazz.cast(this.wirelessGatewayId()));
            }
            case "WirelessGatewayTaskDefinitionId": {
                return Optional.ofNullable(clazz.cast(this.wirelessGatewayTaskDefinitionId()));
            }
            case "LastUplinkReceivedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUplinkReceivedAt()));
            }
            case "TaskCreatedAt": {
                return Optional.ofNullable(clazz.cast(this.taskCreatedAt()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWirelessGatewayTaskResponse, T> g) {
        return obj -> g.apply((GetWirelessGatewayTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private String wirelessGatewayId;
        private String wirelessGatewayTaskDefinitionId;
        private String lastUplinkReceivedAt;
        private String taskCreatedAt;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWirelessGatewayTaskResponse model) {
            super(model);
            this.wirelessGatewayId(model.wirelessGatewayId);
            this.wirelessGatewayTaskDefinitionId(model.wirelessGatewayTaskDefinitionId);
            this.lastUplinkReceivedAt(model.lastUplinkReceivedAt);
            this.taskCreatedAt(model.taskCreatedAt);
            this.status(model.status);
        }

        public final String getWirelessGatewayId() {
            return this.wirelessGatewayId;
        }

        public final void setWirelessGatewayId(String wirelessGatewayId) {
            this.wirelessGatewayId = wirelessGatewayId;
        }

        @Override
        @Transient
        public final Builder wirelessGatewayId(String wirelessGatewayId) {
            this.wirelessGatewayId = wirelessGatewayId;
            return this;
        }

        public final String getWirelessGatewayTaskDefinitionId() {
            return this.wirelessGatewayTaskDefinitionId;
        }

        public final void setWirelessGatewayTaskDefinitionId(String wirelessGatewayTaskDefinitionId) {
            this.wirelessGatewayTaskDefinitionId = wirelessGatewayTaskDefinitionId;
        }

        @Override
        @Transient
        public final Builder wirelessGatewayTaskDefinitionId(String wirelessGatewayTaskDefinitionId) {
            this.wirelessGatewayTaskDefinitionId = wirelessGatewayTaskDefinitionId;
            return this;
        }

        public final String getLastUplinkReceivedAt() {
            return this.lastUplinkReceivedAt;
        }

        public final void setLastUplinkReceivedAt(String lastUplinkReceivedAt) {
            this.lastUplinkReceivedAt = lastUplinkReceivedAt;
        }

        @Override
        @Transient
        public final Builder lastUplinkReceivedAt(String lastUplinkReceivedAt) {
            this.lastUplinkReceivedAt = lastUplinkReceivedAt;
            return this;
        }

        public final String getTaskCreatedAt() {
            return this.taskCreatedAt;
        }

        public final void setTaskCreatedAt(String taskCreatedAt) {
            this.taskCreatedAt = taskCreatedAt;
        }

        @Override
        @Transient
        public final Builder taskCreatedAt(String taskCreatedAt) {
            this.taskCreatedAt = taskCreatedAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(WirelessGatewayTaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetWirelessGatewayTaskResponse build() {
            return new GetWirelessGatewayTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWirelessGatewayTaskResponse> {
        public Builder wirelessGatewayId(String var1);

        public Builder wirelessGatewayTaskDefinitionId(String var1);

        public Builder lastUplinkReceivedAt(String var1);

        public Builder taskCreatedAt(String var1);

        public Builder status(String var1);

        public Builder status(WirelessGatewayTaskStatus var1);
    }
}

