/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.FuotaTaskStatus;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.services.iotwireless.model.LoRaWANFuotaTaskGetInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFuotaTaskResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, GetFuotaTaskResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetFuotaTaskResponse.getter(GetFuotaTaskResponse::arn)).setter(GetFuotaTaskResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetFuotaTaskResponse.getter(GetFuotaTaskResponse::id)).setter(GetFuotaTaskResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GetFuotaTaskResponse.getter(GetFuotaTaskResponse::statusAsString)).setter(GetFuotaTaskResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetFuotaTaskResponse.getter(GetFuotaTaskResponse::name)).setter(GetFuotaTaskResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetFuotaTaskResponse.getter(GetFuotaTaskResponse::description)).setter(GetFuotaTaskResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<LoRaWANFuotaTaskGetInfo> LO_RA_WAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoRaWAN").getter(GetFuotaTaskResponse.getter(GetFuotaTaskResponse::loRaWAN)).setter(GetFuotaTaskResponse.setter(Builder::loRaWAN)).constructor(LoRaWANFuotaTaskGetInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()}).build();
    private static final SdkField<String> FIRMWARE_UPDATE_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirmwareUpdateImage").getter(GetFuotaTaskResponse.getter(GetFuotaTaskResponse::firmwareUpdateImage)).setter(GetFuotaTaskResponse.setter(Builder::firmwareUpdateImage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirmwareUpdateImage").build()}).build();
    private static final SdkField<String> FIRMWARE_UPDATE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirmwareUpdateRole").getter(GetFuotaTaskResponse.getter(GetFuotaTaskResponse::firmwareUpdateRole)).setter(GetFuotaTaskResponse.setter(Builder::firmwareUpdateRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirmwareUpdateRole").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetFuotaTaskResponse.getter(GetFuotaTaskResponse::createdAt)).setter(GetFuotaTaskResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, STATUS_FIELD, NAME_FIELD, DESCRIPTION_FIELD, LO_RA_WAN_FIELD, FIRMWARE_UPDATE_IMAGE_FIELD, FIRMWARE_UPDATE_ROLE_FIELD, CREATED_AT_FIELD));
    private final String arn;
    private final String id;
    private final String status;
    private final String name;
    private final String description;
    private final LoRaWANFuotaTaskGetInfo loRaWAN;
    private final String firmwareUpdateImage;
    private final String firmwareUpdateRole;
    private final Instant createdAt;

    private GetFuotaTaskResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.status = builder.status;
        this.name = builder.name;
        this.description = builder.description;
        this.loRaWAN = builder.loRaWAN;
        this.firmwareUpdateImage = builder.firmwareUpdateImage;
        this.firmwareUpdateRole = builder.firmwareUpdateRole;
        this.createdAt = builder.createdAt;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final FuotaTaskStatus status() {
        return FuotaTaskStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final LoRaWANFuotaTaskGetInfo loRaWAN() {
        return this.loRaWAN;
    }

    public final String firmwareUpdateImage() {
        return this.firmwareUpdateImage;
    }

    public final String firmwareUpdateRole() {
        return this.firmwareUpdateRole;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.loRaWAN());
        hashCode = 31 * hashCode + Objects.hashCode(this.firmwareUpdateImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.firmwareUpdateRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFuotaTaskResponse)) {
            return false;
        }
        GetFuotaTaskResponse other = (GetFuotaTaskResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.loRaWAN(), other.loRaWAN()) && Objects.equals(this.firmwareUpdateImage(), other.firmwareUpdateImage()) && Objects.equals(this.firmwareUpdateRole(), other.firmwareUpdateRole()) && Objects.equals(this.createdAt(), other.createdAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetFuotaTaskResponse").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("Status", (Object)this.statusAsString()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("LoRaWAN", (Object)this.loRaWAN()).add("FirmwareUpdateImage", (Object)this.firmwareUpdateImage()).add("FirmwareUpdateRole", (Object)this.firmwareUpdateRole()).add("CreatedAt", (Object)this.createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LoRaWAN": {
                return Optional.ofNullable(clazz.cast(this.loRaWAN()));
            }
            case "FirmwareUpdateImage": {
                return Optional.ofNullable(clazz.cast(this.firmwareUpdateImage()));
            }
            case "FirmwareUpdateRole": {
                return Optional.ofNullable(clazz.cast(this.firmwareUpdateRole()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFuotaTaskResponse, T> g) {
        return obj -> g.apply((GetFuotaTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String status;
        private String name;
        private String description;
        private LoRaWANFuotaTaskGetInfo loRaWAN;
        private String firmwareUpdateImage;
        private String firmwareUpdateRole;
        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFuotaTaskResponse model) {
            super(model);
            this.arn(model.arn);
            this.id(model.id);
            this.status(model.status);
            this.name(model.name);
            this.description(model.description);
            this.loRaWAN(model.loRaWAN);
            this.firmwareUpdateImage(model.firmwareUpdateImage);
            this.firmwareUpdateRole(model.firmwareUpdateRole);
            this.createdAt(model.createdAt);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(FuotaTaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final LoRaWANFuotaTaskGetInfo.Builder getLoRaWAN() {
            return this.loRaWAN != null ? this.loRaWAN.toBuilder() : null;
        }

        public final void setLoRaWAN(LoRaWANFuotaTaskGetInfo.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        @Transient
        public final Builder loRaWAN(LoRaWANFuotaTaskGetInfo loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        public final String getFirmwareUpdateImage() {
            return this.firmwareUpdateImage;
        }

        public final void setFirmwareUpdateImage(String firmwareUpdateImage) {
            this.firmwareUpdateImage = firmwareUpdateImage;
        }

        @Override
        @Transient
        public final Builder firmwareUpdateImage(String firmwareUpdateImage) {
            this.firmwareUpdateImage = firmwareUpdateImage;
            return this;
        }

        public final String getFirmwareUpdateRole() {
            return this.firmwareUpdateRole;
        }

        public final void setFirmwareUpdateRole(String firmwareUpdateRole) {
            this.firmwareUpdateRole = firmwareUpdateRole;
        }

        @Override
        @Transient
        public final Builder firmwareUpdateRole(String firmwareUpdateRole) {
            this.firmwareUpdateRole = firmwareUpdateRole;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public GetFuotaTaskResponse build() {
            return new GetFuotaTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFuotaTaskResponse> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder status(String var1);

        public Builder status(FuotaTaskStatus var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder loRaWAN(LoRaWANFuotaTaskGetInfo var1);

        default public Builder loRaWAN(Consumer<LoRaWANFuotaTaskGetInfo.Builder> loRaWAN) {
            return this.loRaWAN((LoRaWANFuotaTaskGetInfo)((LoRaWANFuotaTaskGetInfo.Builder)LoRaWANFuotaTaskGetInfo.builder().applyMutation(loRaWAN)).build());
        }

        public Builder firmwareUpdateImage(String var1);

        public Builder firmwareUpdateRole(String var1);

        public Builder createdAt(Instant var1);
    }
}

