/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessRequest;
import software.amazon.awssdk.services.iotwireless.model.WirelessDeviceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteQueuedMessagesRequest
extends IotWirelessRequest
implements ToCopyableBuilder<Builder, DeleteQueuedMessagesRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(DeleteQueuedMessagesRequest.getter(DeleteQueuedMessagesRequest::id)).setter(DeleteQueuedMessagesRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").build()}).build();
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageId").getter(DeleteQueuedMessagesRequest.getter(DeleteQueuedMessagesRequest::messageId)).setter(DeleteQueuedMessagesRequest.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("messageId").build()}).build();
    private static final SdkField<String> WIRELESS_DEVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WirelessDeviceType").getter(DeleteQueuedMessagesRequest.getter(DeleteQueuedMessagesRequest::wirelessDeviceTypeAsString)).setter(DeleteQueuedMessagesRequest.setter(Builder::wirelessDeviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("WirelessDeviceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, MESSAGE_ID_FIELD, WIRELESS_DEVICE_TYPE_FIELD));
    private final String id;
    private final String messageId;
    private final String wirelessDeviceType;

    private DeleteQueuedMessagesRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.messageId = builder.messageId;
        this.wirelessDeviceType = builder.wirelessDeviceType;
    }

    public final String id() {
        return this.id;
    }

    public final String messageId() {
        return this.messageId;
    }

    public final WirelessDeviceType wirelessDeviceType() {
        return WirelessDeviceType.fromValue(this.wirelessDeviceType);
    }

    public final String wirelessDeviceTypeAsString() {
        return this.wirelessDeviceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.wirelessDeviceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteQueuedMessagesRequest)) {
            return false;
        }
        DeleteQueuedMessagesRequest other = (DeleteQueuedMessagesRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.messageId(), other.messageId()) && Objects.equals(this.wirelessDeviceTypeAsString(), other.wirelessDeviceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteQueuedMessagesRequest").add("Id", (Object)this.id()).add("MessageId", (Object)this.messageId()).add("WirelessDeviceType", (Object)this.wirelessDeviceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "MessageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
            case "WirelessDeviceType": {
                return Optional.ofNullable(clazz.cast(this.wirelessDeviceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteQueuedMessagesRequest, T> g) {
        return obj -> g.apply((DeleteQueuedMessagesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessRequest.BuilderImpl
    implements Builder {
        private String id;
        private String messageId;
        private String wirelessDeviceType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteQueuedMessagesRequest model) {
            super(model);
            this.id(model.id);
            this.messageId(model.messageId);
            this.wirelessDeviceType(model.wirelessDeviceType);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getMessageId() {
            return this.messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        @Transient
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final String getWirelessDeviceType() {
            return this.wirelessDeviceType;
        }

        public final void setWirelessDeviceType(String wirelessDeviceType) {
            this.wirelessDeviceType = wirelessDeviceType;
        }

        @Override
        @Transient
        public final Builder wirelessDeviceType(String wirelessDeviceType) {
            this.wirelessDeviceType = wirelessDeviceType;
            return this;
        }

        @Override
        @Transient
        public final Builder wirelessDeviceType(WirelessDeviceType wirelessDeviceType) {
            this.wirelessDeviceType(wirelessDeviceType == null ? null : wirelessDeviceType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteQueuedMessagesRequest build() {
            return new DeleteQueuedMessagesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotWirelessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteQueuedMessagesRequest> {
        public Builder id(String var1);

        public Builder messageId(String var1);

        public Builder wirelessDeviceType(String var1);

        public Builder wirelessDeviceType(WirelessDeviceType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

