/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoRaWANUpdateDevice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoRaWANUpdateDevice> {
    private static final SdkField<String> DEVICE_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceProfileId").getter(LoRaWANUpdateDevice.getter(LoRaWANUpdateDevice::deviceProfileId)).setter(LoRaWANUpdateDevice.setter(Builder::deviceProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceProfileId").build()}).build();
    private static final SdkField<String> SERVICE_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceProfileId").getter(LoRaWANUpdateDevice.getter(LoRaWANUpdateDevice::serviceProfileId)).setter(LoRaWANUpdateDevice.setter(Builder::serviceProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceProfileId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_PROFILE_ID_FIELD, SERVICE_PROFILE_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deviceProfileId;
    private final String serviceProfileId;

    private LoRaWANUpdateDevice(BuilderImpl builder) {
        this.deviceProfileId = builder.deviceProfileId;
        this.serviceProfileId = builder.serviceProfileId;
    }

    public final String deviceProfileId() {
        return this.deviceProfileId;
    }

    public final String serviceProfileId() {
        return this.serviceProfileId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceProfileId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANUpdateDevice)) {
            return false;
        }
        LoRaWANUpdateDevice other = (LoRaWANUpdateDevice)obj;
        return Objects.equals(this.deviceProfileId(), other.deviceProfileId()) && Objects.equals(this.serviceProfileId(), other.serviceProfileId());
    }

    public final String toString() {
        return ToString.builder((String)"LoRaWANUpdateDevice").add("DeviceProfileId", (Object)this.deviceProfileId()).add("ServiceProfileId", (Object)this.serviceProfileId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceProfileId": {
                return Optional.ofNullable(clazz.cast(this.deviceProfileId()));
            }
            case "ServiceProfileId": {
                return Optional.ofNullable(clazz.cast(this.serviceProfileId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANUpdateDevice, T> g) {
        return obj -> g.apply((LoRaWANUpdateDevice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceProfileId;
        private String serviceProfileId;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANUpdateDevice model) {
            this.deviceProfileId(model.deviceProfileId);
            this.serviceProfileId(model.serviceProfileId);
        }

        public final String getDeviceProfileId() {
            return this.deviceProfileId;
        }

        @Override
        public final Builder deviceProfileId(String deviceProfileId) {
            this.deviceProfileId = deviceProfileId;
            return this;
        }

        public final void setDeviceProfileId(String deviceProfileId) {
            this.deviceProfileId = deviceProfileId;
        }

        public final String getServiceProfileId() {
            return this.serviceProfileId;
        }

        @Override
        public final Builder serviceProfileId(String serviceProfileId) {
            this.serviceProfileId = serviceProfileId;
            return this;
        }

        public final void setServiceProfileId(String serviceProfileId) {
            this.serviceProfileId = serviceProfileId;
        }

        public LoRaWANUpdateDevice build() {
            return new LoRaWANUpdateDevice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoRaWANUpdateDevice> {
        public Builder deviceProfileId(String var1);

        public Builder serviceProfileId(String var1);
    }
}

