/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a wireless gateway's operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WirelessGatewayStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<WirelessGatewayStatistics.Builder, WirelessGatewayStatistics> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(WirelessGatewayStatistics::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(WirelessGatewayStatistics::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(WirelessGatewayStatistics::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(WirelessGatewayStatistics::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<LoRaWANGateway> LO_RA_WAN_FIELD = SdkField.<LoRaWANGateway> builder(MarshallingType.SDK_POJO)
            .memberName("LoRaWAN").getter(getter(WirelessGatewayStatistics::loRaWAN)).setter(setter(Builder::loRaWAN))
            .constructor(LoRaWANGateway::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()).build();

    private static final SdkField<String> LAST_UPLINK_RECEIVED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastUplinkReceivedAt").getter(getter(WirelessGatewayStatistics::lastUplinkReceivedAt))
            .setter(setter(Builder::lastUplinkReceivedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUplinkReceivedAt").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, LO_RA_WAN_FIELD, LAST_UPLINK_RECEIVED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String id;

    private final String name;

    private final String description;

    private final LoRaWANGateway loRaWAN;

    private final String lastUplinkReceivedAt;

    private WirelessGatewayStatistics(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.loRaWAN = builder.loRaWAN;
        this.lastUplinkReceivedAt = builder.lastUplinkReceivedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name of the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The ID of the wireless gateway reporting the data.
     * </p>
     * 
     * @return The ID of the wireless gateway reporting the data.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the resource.
     * </p>
     * 
     * @return The name of the resource.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the resource.
     * </p>
     * 
     * @return The description of the resource.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * LoRaWAN gateway info.
     * </p>
     * 
     * @return LoRaWAN gateway info.
     */
    public final LoRaWANGateway loRaWAN() {
        return loRaWAN;
    }

    /**
     * <p>
     * The date and time when the most recent uplink was received.
     * </p>
     * 
     * @return The date and time when the most recent uplink was received.
     */
    public final String lastUplinkReceivedAt() {
        return lastUplinkReceivedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(loRaWAN());
        hashCode = 31 * hashCode + Objects.hashCode(lastUplinkReceivedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WirelessGatewayStatistics)) {
            return false;
        }
        WirelessGatewayStatistics other = (WirelessGatewayStatistics) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(loRaWAN(), other.loRaWAN())
                && Objects.equals(lastUplinkReceivedAt(), other.lastUplinkReceivedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WirelessGatewayStatistics").add("Arn", arn()).add("Id", id()).add("Name", name())
                .add("Description", description()).add("LoRaWAN", loRaWAN()).add("LastUplinkReceivedAt", lastUplinkReceivedAt())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LoRaWAN":
            return Optional.ofNullable(clazz.cast(loRaWAN()));
        case "LastUplinkReceivedAt":
            return Optional.ofNullable(clazz.cast(lastUplinkReceivedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WirelessGatewayStatistics, T> g) {
        return obj -> g.apply((WirelessGatewayStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WirelessGatewayStatistics> {
        /**
         * <p>
         * The Amazon Resource Name of the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The ID of the wireless gateway reporting the data.
         * </p>
         * 
         * @param id
         *        The ID of the wireless gateway reporting the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the resource.
         * </p>
         * 
         * @param name
         *        The name of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the resource.
         * </p>
         * 
         * @param description
         *        The description of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * LoRaWAN gateway info.
         * </p>
         * 
         * @param loRaWAN
         *        LoRaWAN gateway info.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loRaWAN(LoRaWANGateway loRaWAN);

        /**
         * <p>
         * LoRaWAN gateway info.
         * </p>
         * This is a convenience that creates an instance of the {@link LoRaWANGateway.Builder} avoiding the need to
         * create one manually via {@link LoRaWANGateway#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoRaWANGateway.Builder#build()} is called immediately and its
         * result is passed to {@link #loRaWAN(LoRaWANGateway)}.
         * 
         * @param loRaWAN
         *        a consumer that will call methods on {@link LoRaWANGateway.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loRaWAN(LoRaWANGateway)
         */
        default Builder loRaWAN(Consumer<LoRaWANGateway.Builder> loRaWAN) {
            return loRaWAN(LoRaWANGateway.builder().applyMutation(loRaWAN).build());
        }

        /**
         * <p>
         * The date and time when the most recent uplink was received.
         * </p>
         * 
         * @param lastUplinkReceivedAt
         *        The date and time when the most recent uplink was received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUplinkReceivedAt(String lastUplinkReceivedAt);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String name;

        private String description;

        private LoRaWANGateway loRaWAN;

        private String lastUplinkReceivedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(WirelessGatewayStatistics model) {
            arn(model.arn);
            id(model.id);
            name(model.name);
            description(model.description);
            loRaWAN(model.loRaWAN);
            lastUplinkReceivedAt(model.lastUplinkReceivedAt);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final LoRaWANGateway.Builder getLoRaWAN() {
            return loRaWAN != null ? loRaWAN.toBuilder() : null;
        }

        @Override
        public final Builder loRaWAN(LoRaWANGateway loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        public final void setLoRaWAN(LoRaWANGateway.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        public final String getLastUplinkReceivedAt() {
            return lastUplinkReceivedAt;
        }

        @Override
        public final Builder lastUplinkReceivedAt(String lastUplinkReceivedAt) {
            this.lastUplinkReceivedAt = lastUplinkReceivedAt;
            return this;
        }

        public final void setLastUplinkReceivedAt(String lastUplinkReceivedAt) {
            this.lastUplinkReceivedAt = lastUplinkReceivedAt;
        }

        @Override
        public WirelessGatewayStatistics build() {
            return new WirelessGatewayStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
