/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.services.iotwireless.model.WirelessGatewayTaskStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateWirelessGatewayTaskResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, CreateWirelessGatewayTaskResponse> {
    private static final SdkField<String> WIRELESS_GATEWAY_TASK_DEFINITION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WirelessGatewayTaskDefinitionId").getter(CreateWirelessGatewayTaskResponse.getter(CreateWirelessGatewayTaskResponse::wirelessGatewayTaskDefinitionId)).setter(CreateWirelessGatewayTaskResponse.setter(Builder::wirelessGatewayTaskDefinitionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessGatewayTaskDefinitionId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CreateWirelessGatewayTaskResponse.getter(CreateWirelessGatewayTaskResponse::statusAsString)).setter(CreateWirelessGatewayTaskResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WIRELESS_GATEWAY_TASK_DEFINITION_ID_FIELD, STATUS_FIELD));
    private final String wirelessGatewayTaskDefinitionId;
    private final String status;

    private CreateWirelessGatewayTaskResponse(BuilderImpl builder) {
        super(builder);
        this.wirelessGatewayTaskDefinitionId = builder.wirelessGatewayTaskDefinitionId;
        this.status = builder.status;
    }

    public final String wirelessGatewayTaskDefinitionId() {
        return this.wirelessGatewayTaskDefinitionId;
    }

    public final WirelessGatewayTaskStatus status() {
        return WirelessGatewayTaskStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.wirelessGatewayTaskDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWirelessGatewayTaskResponse)) {
            return false;
        }
        CreateWirelessGatewayTaskResponse other = (CreateWirelessGatewayTaskResponse)((Object)obj);
        return Objects.equals(this.wirelessGatewayTaskDefinitionId(), other.wirelessGatewayTaskDefinitionId()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateWirelessGatewayTaskResponse").add("WirelessGatewayTaskDefinitionId", (Object)this.wirelessGatewayTaskDefinitionId()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WirelessGatewayTaskDefinitionId": {
                return Optional.ofNullable(clazz.cast(this.wirelessGatewayTaskDefinitionId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWirelessGatewayTaskResponse, T> g) {
        return obj -> g.apply((CreateWirelessGatewayTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private String wirelessGatewayTaskDefinitionId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWirelessGatewayTaskResponse model) {
            super(model);
            this.wirelessGatewayTaskDefinitionId(model.wirelessGatewayTaskDefinitionId);
            this.status(model.status);
        }

        public final String getWirelessGatewayTaskDefinitionId() {
            return this.wirelessGatewayTaskDefinitionId;
        }

        @Override
        public final Builder wirelessGatewayTaskDefinitionId(String wirelessGatewayTaskDefinitionId) {
            this.wirelessGatewayTaskDefinitionId = wirelessGatewayTaskDefinitionId;
            return this;
        }

        public final void setWirelessGatewayTaskDefinitionId(String wirelessGatewayTaskDefinitionId) {
            this.wirelessGatewayTaskDefinitionId = wirelessGatewayTaskDefinitionId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WirelessGatewayTaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public CreateWirelessGatewayTaskResponse build() {
            return new CreateWirelessGatewayTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateWirelessGatewayTaskResponse> {
        public Builder wirelessGatewayTaskDefinitionId(String var1);

        public Builder status(String var1);

        public Builder status(WirelessGatewayTaskStatus var1);
    }
}

