/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.DeviceProfile;
import software.amazon.awssdk.services.iotwireless.model.DeviceProfileListCopier;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDeviceProfilesResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, ListDeviceProfilesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDeviceProfilesResponse.getter(ListDeviceProfilesResponse::nextToken)).setter(ListDeviceProfilesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<DeviceProfile>> DEVICE_PROFILE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeviceProfileList").getter(ListDeviceProfilesResponse.getter(ListDeviceProfilesResponse::deviceProfileList)).setter(ListDeviceProfilesResponse.setter(Builder::deviceProfileList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceProfileList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeviceProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, DEVICE_PROFILE_LIST_FIELD));
    private final String nextToken;
    private final List<DeviceProfile> deviceProfileList;

    private ListDeviceProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.deviceProfileList = builder.deviceProfileList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasDeviceProfileList() {
        return this.deviceProfileList != null && !(this.deviceProfileList instanceof SdkAutoConstructList);
    }

    public final List<DeviceProfile> deviceProfileList() {
        return this.deviceProfileList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeviceProfileList() ? this.deviceProfileList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeviceProfilesResponse)) {
            return false;
        }
        ListDeviceProfilesResponse other = (ListDeviceProfilesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasDeviceProfileList() == other.hasDeviceProfileList() && Objects.equals(this.deviceProfileList(), other.deviceProfileList());
    }

    public final String toString() {
        return ToString.builder((String)"ListDeviceProfilesResponse").add("NextToken", (Object)this.nextToken()).add("DeviceProfileList", this.hasDeviceProfileList() ? this.deviceProfileList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "DeviceProfileList": {
                return Optional.ofNullable(clazz.cast(this.deviceProfileList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeviceProfilesResponse, T> g) {
        return obj -> g.apply((ListDeviceProfilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<DeviceProfile> deviceProfileList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeviceProfilesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.deviceProfileList(model.deviceProfileList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<DeviceProfile.Builder> getDeviceProfileList() {
            if (this.deviceProfileList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deviceProfileList != null ? (Collection)this.deviceProfileList.stream().map(DeviceProfile::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deviceProfileList(Collection<DeviceProfile> deviceProfileList) {
            this.deviceProfileList = DeviceProfileListCopier.copy(deviceProfileList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceProfileList(DeviceProfile ... deviceProfileList) {
            this.deviceProfileList(Arrays.asList(deviceProfileList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceProfileList(Consumer<DeviceProfile.Builder> ... deviceProfileList) {
            this.deviceProfileList(Stream.of(deviceProfileList).map(c -> (DeviceProfile)((DeviceProfile.Builder)DeviceProfile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDeviceProfileList(Collection<DeviceProfile.BuilderImpl> deviceProfileList) {
            this.deviceProfileList = DeviceProfileListCopier.copyFromBuilder(deviceProfileList);
        }

        @Override
        public ListDeviceProfilesResponse build() {
            return new ListDeviceProfilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDeviceProfilesResponse> {
        public Builder nextToken(String var1);

        public Builder deviceProfileList(Collection<DeviceProfile> var1);

        public Builder deviceProfileList(DeviceProfile ... var1);

        public Builder deviceProfileList(Consumer<DeviceProfile.Builder> ... var1);
    }
}

