/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.services.iotwireless.model.WirelessGatewayServiceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetServiceEndpointResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, GetServiceEndpointResponse> {
    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceType").getter(GetServiceEndpointResponse.getter(GetServiceEndpointResponse::serviceTypeAsString)).setter(GetServiceEndpointResponse.setter(Builder::serviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType").build()}).build();
    private static final SdkField<String> SERVICE_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceEndpoint").getter(GetServiceEndpointResponse.getter(GetServiceEndpointResponse::serviceEndpoint)).setter(GetServiceEndpointResponse.setter(Builder::serviceEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceEndpoint").build()}).build();
    private static final SdkField<String> SERVER_TRUST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerTrust").getter(GetServiceEndpointResponse.getter(GetServiceEndpointResponse::serverTrust)).setter(GetServiceEndpointResponse.setter(Builder::serverTrust)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerTrust").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_TYPE_FIELD, SERVICE_ENDPOINT_FIELD, SERVER_TRUST_FIELD));
    private final String serviceType;
    private final String serviceEndpoint;
    private final String serverTrust;

    private GetServiceEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.serviceType = builder.serviceType;
        this.serviceEndpoint = builder.serviceEndpoint;
        this.serverTrust = builder.serverTrust;
    }

    public final WirelessGatewayServiceType serviceType() {
        return WirelessGatewayServiceType.fromValue(this.serviceType);
    }

    public final String serviceTypeAsString() {
        return this.serviceType;
    }

    public final String serviceEndpoint() {
        return this.serviceEndpoint;
    }

    public final String serverTrust() {
        return this.serverTrust;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverTrust());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceEndpointResponse)) {
            return false;
        }
        GetServiceEndpointResponse other = (GetServiceEndpointResponse)((Object)obj);
        return Objects.equals(this.serviceTypeAsString(), other.serviceTypeAsString()) && Objects.equals(this.serviceEndpoint(), other.serviceEndpoint()) && Objects.equals(this.serverTrust(), other.serverTrust());
    }

    public final String toString() {
        return ToString.builder((String)"GetServiceEndpointResponse").add("ServiceType", (Object)this.serviceTypeAsString()).add("ServiceEndpoint", (Object)this.serviceEndpoint()).add("ServerTrust", (Object)this.serverTrust()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceType": {
                return Optional.ofNullable(clazz.cast(this.serviceTypeAsString()));
            }
            case "ServiceEndpoint": {
                return Optional.ofNullable(clazz.cast(this.serviceEndpoint()));
            }
            case "ServerTrust": {
                return Optional.ofNullable(clazz.cast(this.serverTrust()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServiceEndpointResponse, T> g) {
        return obj -> g.apply((GetServiceEndpointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private String serviceType;
        private String serviceEndpoint;
        private String serverTrust;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceEndpointResponse model) {
            super(model);
            this.serviceType(model.serviceType);
            this.serviceEndpoint(model.serviceEndpoint);
            this.serverTrust(model.serverTrust);
        }

        public final String getServiceType() {
            return this.serviceType;
        }

        @Override
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        public final Builder serviceType(WirelessGatewayServiceType serviceType) {
            this.serviceType(serviceType == null ? null : serviceType.toString());
            return this;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        public final String getServiceEndpoint() {
            return this.serviceEndpoint;
        }

        @Override
        public final Builder serviceEndpoint(String serviceEndpoint) {
            this.serviceEndpoint = serviceEndpoint;
            return this;
        }

        public final void setServiceEndpoint(String serviceEndpoint) {
            this.serviceEndpoint = serviceEndpoint;
        }

        public final String getServerTrust() {
            return this.serverTrust;
        }

        @Override
        public final Builder serverTrust(String serverTrust) {
            this.serverTrust = serverTrust;
            return this;
        }

        public final void setServerTrust(String serverTrust) {
            this.serverTrust = serverTrust;
        }

        @Override
        public GetServiceEndpointResponse build() {
            return new GetServiceEndpointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetServiceEndpointResponse> {
        public Builder serviceType(String var1);

        public Builder serviceType(WirelessGatewayServiceType var1);

        public Builder serviceEndpoint(String var1);

        public Builder serverTrust(String var1);
    }
}

