/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayTaskEntry;
import software.amazon.awssdk.services.iotwireless.model.WirelessGatewayTaskDefinitionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWirelessGatewayTaskDefinitionsResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, ListWirelessGatewayTaskDefinitionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListWirelessGatewayTaskDefinitionsResponse.getter(ListWirelessGatewayTaskDefinitionsResponse::nextToken)).setter(ListWirelessGatewayTaskDefinitionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<UpdateWirelessGatewayTaskEntry>> TASK_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TaskDefinitions").getter(ListWirelessGatewayTaskDefinitionsResponse.getter(ListWirelessGatewayTaskDefinitionsResponse::taskDefinitions)).setter(ListWirelessGatewayTaskDefinitionsResponse.setter(Builder::taskDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdateWirelessGatewayTaskEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TASK_DEFINITIONS_FIELD));
    private final String nextToken;
    private final List<UpdateWirelessGatewayTaskEntry> taskDefinitions;

    private ListWirelessGatewayTaskDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.taskDefinitions = builder.taskDefinitions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasTaskDefinitions() {
        return this.taskDefinitions != null && !(this.taskDefinitions instanceof SdkAutoConstructList);
    }

    public List<UpdateWirelessGatewayTaskEntry> taskDefinitions() {
        return this.taskDefinitions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTaskDefinitions() ? this.taskDefinitions() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWirelessGatewayTaskDefinitionsResponse)) {
            return false;
        }
        ListWirelessGatewayTaskDefinitionsResponse other = (ListWirelessGatewayTaskDefinitionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTaskDefinitions() == other.hasTaskDefinitions() && Objects.equals(this.taskDefinitions(), other.taskDefinitions());
    }

    public String toString() {
        return ToString.builder((String)"ListWirelessGatewayTaskDefinitionsResponse").add("NextToken", (Object)this.nextToken()).add("TaskDefinitions", this.hasTaskDefinitions() ? this.taskDefinitions() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "TaskDefinitions": {
                return Optional.ofNullable(clazz.cast(this.taskDefinitions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWirelessGatewayTaskDefinitionsResponse, T> g) {
        return obj -> g.apply((ListWirelessGatewayTaskDefinitionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<UpdateWirelessGatewayTaskEntry> taskDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWirelessGatewayTaskDefinitionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.taskDefinitions(model.taskDefinitions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<UpdateWirelessGatewayTaskEntry.Builder> getTaskDefinitions() {
            if (this.taskDefinitions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.taskDefinitions != null ? (Collection)this.taskDefinitions.stream().map(UpdateWirelessGatewayTaskEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder taskDefinitions(Collection<UpdateWirelessGatewayTaskEntry> taskDefinitions) {
            this.taskDefinitions = WirelessGatewayTaskDefinitionListCopier.copy(taskDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskDefinitions(UpdateWirelessGatewayTaskEntry ... taskDefinitions) {
            this.taskDefinitions(Arrays.asList(taskDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskDefinitions(Consumer<UpdateWirelessGatewayTaskEntry.Builder> ... taskDefinitions) {
            this.taskDefinitions(Stream.of(taskDefinitions).map(c -> (UpdateWirelessGatewayTaskEntry)((UpdateWirelessGatewayTaskEntry.Builder)UpdateWirelessGatewayTaskEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTaskDefinitions(Collection<UpdateWirelessGatewayTaskEntry.BuilderImpl> taskDefinitions) {
            this.taskDefinitions = WirelessGatewayTaskDefinitionListCopier.copyFromBuilder(taskDefinitions);
        }

        @Override
        public ListWirelessGatewayTaskDefinitionsResponse build() {
            return new ListWirelessGatewayTaskDefinitionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWirelessGatewayTaskDefinitionsResponse> {
        public Builder nextToken(String var1);

        public Builder taskDefinitions(Collection<UpdateWirelessGatewayTaskEntry> var1);

        public Builder taskDefinitions(UpdateWirelessGatewayTaskEntry ... var1);

        public Builder taskDefinitions(Consumer<UpdateWirelessGatewayTaskEntry.Builder> ... var1);
    }
}

