/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SidewalkAccountInfoWithFingerprint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SidewalkAccountInfoWithFingerprint> {
    private static final SdkField<String> AMAZON_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AmazonId").getter(SidewalkAccountInfoWithFingerprint.getter(SidewalkAccountInfoWithFingerprint::amazonId)).setter(SidewalkAccountInfoWithFingerprint.setter(Builder::amazonId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonId").build()}).build();
    private static final SdkField<String> APP_SERVER_PRIVATE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppServerPrivateKey").getter(SidewalkAccountInfoWithFingerprint.getter(SidewalkAccountInfoWithFingerprint::appServerPrivateKey)).setter(SidewalkAccountInfoWithFingerprint.setter(Builder::appServerPrivateKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppServerPrivateKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMAZON_ID_FIELD, APP_SERVER_PRIVATE_KEY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String amazonId;
    private final String appServerPrivateKey;

    private SidewalkAccountInfoWithFingerprint(BuilderImpl builder) {
        this.amazonId = builder.amazonId;
        this.appServerPrivateKey = builder.appServerPrivateKey;
    }

    public String amazonId() {
        return this.amazonId;
    }

    public String appServerPrivateKey() {
        return this.appServerPrivateKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amazonId());
        hashCode = 31 * hashCode + Objects.hashCode(this.appServerPrivateKey());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SidewalkAccountInfoWithFingerprint)) {
            return false;
        }
        SidewalkAccountInfoWithFingerprint other = (SidewalkAccountInfoWithFingerprint)obj;
        return Objects.equals(this.amazonId(), other.amazonId()) && Objects.equals(this.appServerPrivateKey(), other.appServerPrivateKey());
    }

    public String toString() {
        return ToString.builder((String)"SidewalkAccountInfoWithFingerprint").add("AmazonId", (Object)this.amazonId()).add("AppServerPrivateKey", (Object)(this.appServerPrivateKey() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AmazonId": {
                return Optional.ofNullable(clazz.cast(this.amazonId()));
            }
            case "AppServerPrivateKey": {
                return Optional.ofNullable(clazz.cast(this.appServerPrivateKey()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SidewalkAccountInfoWithFingerprint, T> g) {
        return obj -> g.apply((SidewalkAccountInfoWithFingerprint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String amazonId;
        private String appServerPrivateKey;

        private BuilderImpl() {
        }

        private BuilderImpl(SidewalkAccountInfoWithFingerprint model) {
            this.amazonId(model.amazonId);
            this.appServerPrivateKey(model.appServerPrivateKey);
        }

        public final String getAmazonId() {
            return this.amazonId;
        }

        @Override
        public final Builder amazonId(String amazonId) {
            this.amazonId = amazonId;
            return this;
        }

        public final void setAmazonId(String amazonId) {
            this.amazonId = amazonId;
        }

        public final String getAppServerPrivateKey() {
            return this.appServerPrivateKey;
        }

        @Override
        public final Builder appServerPrivateKey(String appServerPrivateKey) {
            this.appServerPrivateKey = appServerPrivateKey;
            return this;
        }

        public final void setAppServerPrivateKey(String appServerPrivateKey) {
            this.appServerPrivateKey = appServerPrivateKey;
        }

        public SidewalkAccountInfoWithFingerprint build() {
            return new SidewalkAccountInfoWithFingerprint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SidewalkAccountInfoWithFingerprint> {
        public Builder amazonId(String var1);

        public Builder appServerPrivateKey(String var1);
    }
}

