/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iottwinmaker.model.ComponentPropertyGroupResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ComponentPropertyGroupResponsesCopier;
import software.amazon.awssdk.services.iottwinmaker.model.ComponentSummary;
import software.amazon.awssdk.services.iottwinmaker.model.CompositeComponentResponseCopier;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyResponse;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyResponsesCopier;
import software.amazon.awssdk.services.iottwinmaker.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentResponse> {
    private static final SdkField<String> COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentName").getter(ComponentResponse.getter(ComponentResponse::componentName)).setter(ComponentResponse.setter(Builder::componentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ComponentResponse.getter(ComponentResponse::description)).setter(ComponentResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> COMPONENT_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentTypeId").getter(ComponentResponse.getter(ComponentResponse::componentTypeId)).setter(ComponentResponse.setter(Builder::componentTypeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentTypeId").build()}).build();
    private static final SdkField<Status> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("status").getter(ComponentResponse.getter(ComponentResponse::status)).setter(ComponentResponse.setter(Builder::status)).constructor(Status::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> DEFINED_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("definedIn").getter(ComponentResponse.getter(ComponentResponse::definedIn)).setter(ComponentResponse.setter(Builder::definedIn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definedIn").build()}).build();
    private static final SdkField<Map<String, PropertyResponse>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("properties").getter(ComponentResponse.getter(ComponentResponse::properties)).setter(ComponentResponse.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, ComponentPropertyGroupResponse>> PROPERTY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("propertyGroups").getter(ComponentResponse.getter(ComponentResponse::propertyGroups)).setter(ComponentResponse.setter(Builder::propertyGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyGroups").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentPropertyGroupResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SYNC_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("syncSource").getter(ComponentResponse.getter(ComponentResponse::syncSource)).setter(ComponentResponse.setter(Builder::syncSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncSource").build()}).build();
    private static final SdkField<Boolean> ARE_ALL_PROPERTIES_RETURNED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("areAllPropertiesReturned").getter(ComponentResponse.getter(ComponentResponse::areAllPropertiesReturned)).setter(ComponentResponse.setter(Builder::areAllPropertiesReturned)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("areAllPropertiesReturned").build()}).build();
    private static final SdkField<Map<String, ComponentSummary>> COMPOSITE_COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("compositeComponents").getter(ComponentResponse.getter(ComponentResponse::compositeComponents)).setter(ComponentResponse.setter(Builder::compositeComponents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compositeComponents").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ARE_ALL_COMPOSITE_COMPONENTS_RETURNED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("areAllCompositeComponentsReturned").getter(ComponentResponse.getter(ComponentResponse::areAllCompositeComponentsReturned)).setter(ComponentResponse.setter(Builder::areAllCompositeComponentsReturned)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("areAllCompositeComponentsReturned").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_NAME_FIELD, DESCRIPTION_FIELD, COMPONENT_TYPE_ID_FIELD, STATUS_FIELD, DEFINED_IN_FIELD, PROPERTIES_FIELD, PROPERTY_GROUPS_FIELD, SYNC_SOURCE_FIELD, ARE_ALL_PROPERTIES_RETURNED_FIELD, COMPOSITE_COMPONENTS_FIELD, ARE_ALL_COMPOSITE_COMPONENTS_RETURNED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ComponentResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String componentName;
    private final String description;
    private final String componentTypeId;
    private final Status status;
    private final String definedIn;
    private final Map<String, PropertyResponse> properties;
    private final Map<String, ComponentPropertyGroupResponse> propertyGroups;
    private final String syncSource;
    private final Boolean areAllPropertiesReturned;
    private final Map<String, ComponentSummary> compositeComponents;
    private final Boolean areAllCompositeComponentsReturned;

    private ComponentResponse(BuilderImpl builder) {
        this.componentName = builder.componentName;
        this.description = builder.description;
        this.componentTypeId = builder.componentTypeId;
        this.status = builder.status;
        this.definedIn = builder.definedIn;
        this.properties = builder.properties;
        this.propertyGroups = builder.propertyGroups;
        this.syncSource = builder.syncSource;
        this.areAllPropertiesReturned = builder.areAllPropertiesReturned;
        this.compositeComponents = builder.compositeComponents;
        this.areAllCompositeComponentsReturned = builder.areAllCompositeComponentsReturned;
    }

    public final String componentName() {
        return this.componentName;
    }

    public final String description() {
        return this.description;
    }

    public final String componentTypeId() {
        return this.componentTypeId;
    }

    public final Status status() {
        return this.status;
    }

    public final String definedIn() {
        return this.definedIn;
    }

    public final boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructMap);
    }

    public final Map<String, PropertyResponse> properties() {
        return this.properties;
    }

    public final boolean hasPropertyGroups() {
        return this.propertyGroups != null && !(this.propertyGroups instanceof SdkAutoConstructMap);
    }

    public final Map<String, ComponentPropertyGroupResponse> propertyGroups() {
        return this.propertyGroups;
    }

    public final String syncSource() {
        return this.syncSource;
    }

    public final Boolean areAllPropertiesReturned() {
        return this.areAllPropertiesReturned;
    }

    public final boolean hasCompositeComponents() {
        return this.compositeComponents != null && !(this.compositeComponents instanceof SdkAutoConstructMap);
    }

    public final Map<String, ComponentSummary> compositeComponents() {
        return this.compositeComponents;
    }

    public final Boolean areAllCompositeComponentsReturned() {
        return this.areAllCompositeComponentsReturned;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.componentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.definedIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertyGroups() ? this.propertyGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.syncSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.areAllPropertiesReturned());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCompositeComponents() ? this.compositeComponents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.areAllCompositeComponentsReturned());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentResponse)) {
            return false;
        }
        ComponentResponse other = (ComponentResponse)obj;
        return Objects.equals(this.componentName(), other.componentName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.componentTypeId(), other.componentTypeId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.definedIn(), other.definedIn()) && this.hasProperties() == other.hasProperties() && Objects.equals(this.properties(), other.properties()) && this.hasPropertyGroups() == other.hasPropertyGroups() && Objects.equals(this.propertyGroups(), other.propertyGroups()) && Objects.equals(this.syncSource(), other.syncSource()) && Objects.equals(this.areAllPropertiesReturned(), other.areAllPropertiesReturned()) && this.hasCompositeComponents() == other.hasCompositeComponents() && Objects.equals(this.compositeComponents(), other.compositeComponents()) && Objects.equals(this.areAllCompositeComponentsReturned(), other.areAllCompositeComponentsReturned());
    }

    public final String toString() {
        return ToString.builder((String)"ComponentResponse").add("ComponentName", (Object)this.componentName()).add("Description", (Object)this.description()).add("ComponentTypeId", (Object)this.componentTypeId()).add("Status", (Object)this.status()).add("DefinedIn", (Object)this.definedIn()).add("Properties", this.hasProperties() ? this.properties() : null).add("PropertyGroups", this.hasPropertyGroups() ? this.propertyGroups() : null).add("SyncSource", (Object)this.syncSource()).add("AreAllPropertiesReturned", (Object)this.areAllPropertiesReturned()).add("CompositeComponents", this.hasCompositeComponents() ? this.compositeComponents() : null).add("AreAllCompositeComponentsReturned", (Object)this.areAllCompositeComponentsReturned()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "componentName": {
                return Optional.ofNullable(clazz.cast(this.componentName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "componentTypeId": {
                return Optional.ofNullable(clazz.cast(this.componentTypeId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "definedIn": {
                return Optional.ofNullable(clazz.cast(this.definedIn()));
            }
            case "properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
            case "propertyGroups": {
                return Optional.ofNullable(clazz.cast(this.propertyGroups()));
            }
            case "syncSource": {
                return Optional.ofNullable(clazz.cast(this.syncSource()));
            }
            case "areAllPropertiesReturned": {
                return Optional.ofNullable(clazz.cast(this.areAllPropertiesReturned()));
            }
            case "compositeComponents": {
                return Optional.ofNullable(clazz.cast(this.compositeComponents()));
            }
            case "areAllCompositeComponentsReturned": {
                return Optional.ofNullable(clazz.cast(this.areAllCompositeComponentsReturned()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("componentName", COMPONENT_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("componentTypeId", COMPONENT_TYPE_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("definedIn", DEFINED_IN_FIELD);
        map.put("properties", PROPERTIES_FIELD);
        map.put("propertyGroups", PROPERTY_GROUPS_FIELD);
        map.put("syncSource", SYNC_SOURCE_FIELD);
        map.put("areAllPropertiesReturned", ARE_ALL_PROPERTIES_RETURNED_FIELD);
        map.put("compositeComponents", COMPOSITE_COMPONENTS_FIELD);
        map.put("areAllCompositeComponentsReturned", ARE_ALL_COMPOSITE_COMPONENTS_RETURNED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComponentResponse, T> g) {
        return obj -> g.apply((ComponentResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String componentName;
        private String description;
        private String componentTypeId;
        private Status status;
        private String definedIn;
        private Map<String, PropertyResponse> properties = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, ComponentPropertyGroupResponse> propertyGroups = DefaultSdkAutoConstructMap.getInstance();
        private String syncSource;
        private Boolean areAllPropertiesReturned;
        private Map<String, ComponentSummary> compositeComponents = DefaultSdkAutoConstructMap.getInstance();
        private Boolean areAllCompositeComponentsReturned;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentResponse model) {
            this.componentName(model.componentName);
            this.description(model.description);
            this.componentTypeId(model.componentTypeId);
            this.status(model.status);
            this.definedIn(model.definedIn);
            this.properties(model.properties);
            this.propertyGroups(model.propertyGroups);
            this.syncSource(model.syncSource);
            this.areAllPropertiesReturned(model.areAllPropertiesReturned);
            this.compositeComponents(model.compositeComponents);
            this.areAllCompositeComponentsReturned(model.areAllCompositeComponentsReturned);
        }

        public final String getComponentName() {
            return this.componentName;
        }

        public final void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public final Builder componentName(String componentName) {
            this.componentName = componentName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getComponentTypeId() {
            return this.componentTypeId;
        }

        public final void setComponentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
        }

        @Override
        public final Builder componentTypeId(String componentTypeId) {
            this.componentTypeId = componentTypeId;
            return this;
        }

        public final Status.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(Status.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(Status status) {
            this.status = status;
            return this;
        }

        public final String getDefinedIn() {
            return this.definedIn;
        }

        public final void setDefinedIn(String definedIn) {
            this.definedIn = definedIn;
        }

        @Override
        public final Builder definedIn(String definedIn) {
            this.definedIn = definedIn;
            return this;
        }

        public final Map<String, PropertyResponse.Builder> getProperties() {
            Map<String, PropertyResponse.Builder> result = PropertyResponsesCopier.copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setProperties(Map<String, PropertyResponse.BuilderImpl> properties) {
            this.properties = PropertyResponsesCopier.copyFromBuilder(properties);
        }

        @Override
        public final Builder properties(Map<String, PropertyResponse> properties) {
            this.properties = PropertyResponsesCopier.copy(properties);
            return this;
        }

        public final Map<String, ComponentPropertyGroupResponse.Builder> getPropertyGroups() {
            Map<String, ComponentPropertyGroupResponse.Builder> result = ComponentPropertyGroupResponsesCopier.copyToBuilder(this.propertyGroups);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPropertyGroups(Map<String, ComponentPropertyGroupResponse.BuilderImpl> propertyGroups) {
            this.propertyGroups = ComponentPropertyGroupResponsesCopier.copyFromBuilder(propertyGroups);
        }

        @Override
        public final Builder propertyGroups(Map<String, ComponentPropertyGroupResponse> propertyGroups) {
            this.propertyGroups = ComponentPropertyGroupResponsesCopier.copy(propertyGroups);
            return this;
        }

        public final String getSyncSource() {
            return this.syncSource;
        }

        public final void setSyncSource(String syncSource) {
            this.syncSource = syncSource;
        }

        @Override
        public final Builder syncSource(String syncSource) {
            this.syncSource = syncSource;
            return this;
        }

        public final Boolean getAreAllPropertiesReturned() {
            return this.areAllPropertiesReturned;
        }

        public final void setAreAllPropertiesReturned(Boolean areAllPropertiesReturned) {
            this.areAllPropertiesReturned = areAllPropertiesReturned;
        }

        @Override
        public final Builder areAllPropertiesReturned(Boolean areAllPropertiesReturned) {
            this.areAllPropertiesReturned = areAllPropertiesReturned;
            return this;
        }

        public final Map<String, ComponentSummary.Builder> getCompositeComponents() {
            Map<String, ComponentSummary.Builder> result = CompositeComponentResponseCopier.copyToBuilder(this.compositeComponents);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCompositeComponents(Map<String, ComponentSummary.BuilderImpl> compositeComponents) {
            this.compositeComponents = CompositeComponentResponseCopier.copyFromBuilder(compositeComponents);
        }

        @Override
        public final Builder compositeComponents(Map<String, ComponentSummary> compositeComponents) {
            this.compositeComponents = CompositeComponentResponseCopier.copy(compositeComponents);
            return this;
        }

        public final Boolean getAreAllCompositeComponentsReturned() {
            return this.areAllCompositeComponentsReturned;
        }

        public final void setAreAllCompositeComponentsReturned(Boolean areAllCompositeComponentsReturned) {
            this.areAllCompositeComponentsReturned = areAllCompositeComponentsReturned;
        }

        @Override
        public final Builder areAllCompositeComponentsReturned(Boolean areAllCompositeComponentsReturned) {
            this.areAllCompositeComponentsReturned = areAllCompositeComponentsReturned;
            return this;
        }

        public ComponentResponse build() {
            return new ComponentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentResponse> {
        public Builder componentName(String var1);

        public Builder description(String var1);

        public Builder componentTypeId(String var1);

        public Builder status(Status var1);

        default public Builder status(Consumer<Status.Builder> status) {
            return this.status((Status)((Status.Builder)Status.builder().applyMutation(status)).build());
        }

        public Builder definedIn(String var1);

        public Builder properties(Map<String, PropertyResponse> var1);

        public Builder propertyGroups(Map<String, ComponentPropertyGroupResponse> var1);

        public Builder syncSource(String var1);

        public Builder areAllPropertiesReturned(Boolean var1);

        public Builder compositeComponents(Map<String, ComponentSummary> var1);

        public Builder areAllCompositeComponentsReturned(Boolean var1);
    }
}

