/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iottwinmaker.model.DataConnector;
import software.amazon.awssdk.services.iottwinmaker.model.RequiredPropertiesCopier;
import software.amazon.awssdk.services.iottwinmaker.model.Scope;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FunctionResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FunctionResponse> {
    private static final SdkField<List<String>> REQUIRED_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("requiredProperties").getter(FunctionResponse.getter(FunctionResponse::requiredProperties)).setter(FunctionResponse.setter(Builder::requiredProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiredProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scope").getter(FunctionResponse.getter(FunctionResponse::scopeAsString)).setter(FunctionResponse.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()}).build();
    private static final SdkField<DataConnector> IMPLEMENTED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("implementedBy").getter(FunctionResponse.getter(FunctionResponse::implementedBy)).setter(FunctionResponse.setter(Builder::implementedBy)).constructor(DataConnector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("implementedBy").build()}).build();
    private static final SdkField<Boolean> IS_INHERITED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isInherited").getter(FunctionResponse.getter(FunctionResponse::isInherited)).setter(FunctionResponse.setter(Builder::isInherited)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isInherited").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUIRED_PROPERTIES_FIELD, SCOPE_FIELD, IMPLEMENTED_BY_FIELD, IS_INHERITED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FunctionResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> requiredProperties;
    private final String scope;
    private final DataConnector implementedBy;
    private final Boolean isInherited;

    private FunctionResponse(BuilderImpl builder) {
        this.requiredProperties = builder.requiredProperties;
        this.scope = builder.scope;
        this.implementedBy = builder.implementedBy;
        this.isInherited = builder.isInherited;
    }

    public final boolean hasRequiredProperties() {
        return this.requiredProperties != null && !(this.requiredProperties instanceof SdkAutoConstructList);
    }

    public final List<String> requiredProperties() {
        return this.requiredProperties;
    }

    public final Scope scope() {
        return Scope.fromValue(this.scope);
    }

    public final String scopeAsString() {
        return this.scope;
    }

    public final DataConnector implementedBy() {
        return this.implementedBy;
    }

    public final Boolean isInherited() {
        return this.isInherited;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequiredProperties() ? this.requiredProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.implementedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.isInherited());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionResponse)) {
            return false;
        }
        FunctionResponse other = (FunctionResponse)obj;
        return this.hasRequiredProperties() == other.hasRequiredProperties() && Objects.equals(this.requiredProperties(), other.requiredProperties()) && Objects.equals(this.scopeAsString(), other.scopeAsString()) && Objects.equals(this.implementedBy(), other.implementedBy()) && Objects.equals(this.isInherited(), other.isInherited());
    }

    public final String toString() {
        return ToString.builder((String)"FunctionResponse").add("RequiredProperties", this.hasRequiredProperties() ? this.requiredProperties() : null).add("Scope", (Object)this.scopeAsString()).add("ImplementedBy", (Object)this.implementedBy()).add("IsInherited", (Object)this.isInherited()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requiredProperties": {
                return Optional.ofNullable(clazz.cast(this.requiredProperties()));
            }
            case "scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsString()));
            }
            case "implementedBy": {
                return Optional.ofNullable(clazz.cast(this.implementedBy()));
            }
            case "isInherited": {
                return Optional.ofNullable(clazz.cast(this.isInherited()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("requiredProperties", REQUIRED_PROPERTIES_FIELD);
        map.put("scope", SCOPE_FIELD);
        map.put("implementedBy", IMPLEMENTED_BY_FIELD);
        map.put("isInherited", IS_INHERITED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FunctionResponse, T> g) {
        return obj -> g.apply((FunctionResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> requiredProperties = DefaultSdkAutoConstructList.getInstance();
        private String scope;
        private DataConnector implementedBy;
        private Boolean isInherited;

        private BuilderImpl() {
        }

        private BuilderImpl(FunctionResponse model) {
            this.requiredProperties(model.requiredProperties);
            this.scope(model.scope);
            this.implementedBy(model.implementedBy);
            this.isInherited(model.isInherited);
        }

        public final Collection<String> getRequiredProperties() {
            if (this.requiredProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return this.requiredProperties;
        }

        public final void setRequiredProperties(Collection<String> requiredProperties) {
            this.requiredProperties = RequiredPropertiesCopier.copy(requiredProperties);
        }

        @Override
        public final Builder requiredProperties(Collection<String> requiredProperties) {
            this.requiredProperties = RequiredPropertiesCopier.copy(requiredProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredProperties(String ... requiredProperties) {
            this.requiredProperties(Arrays.asList(requiredProperties));
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final DataConnector.Builder getImplementedBy() {
            return this.implementedBy != null ? this.implementedBy.toBuilder() : null;
        }

        public final void setImplementedBy(DataConnector.BuilderImpl implementedBy) {
            this.implementedBy = implementedBy != null ? implementedBy.build() : null;
        }

        @Override
        public final Builder implementedBy(DataConnector implementedBy) {
            this.implementedBy = implementedBy;
            return this;
        }

        public final Boolean getIsInherited() {
            return this.isInherited;
        }

        public final void setIsInherited(Boolean isInherited) {
            this.isInherited = isInherited;
        }

        @Override
        public final Builder isInherited(Boolean isInherited) {
            this.isInherited = isInherited;
            return this;
        }

        public FunctionResponse build() {
            return new FunctionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FunctionResponse> {
        public Builder requiredProperties(Collection<String> var1);

        public Builder requiredProperties(String ... var1);

        public Builder scope(String var1);

        public Builder scope(Scope var1);

        public Builder implementedBy(DataConnector var1);

        default public Builder implementedBy(Consumer<DataConnector.Builder> implementedBy) {
            return this.implementedBy((DataConnector)((DataConnector.Builder)DataConnector.builder().applyMutation(implementedBy)).build());
        }

        public Builder isInherited(Boolean var1);
    }
}

