/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerResponse;
import software.amazon.awssdk.services.iottwinmaker.model.SyncResourceSummariesCopier;
import software.amazon.awssdk.services.iottwinmaker.model.SyncResourceSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSyncResourcesResponse
extends IoTTwinMakerResponse
implements ToCopyableBuilder<Builder, ListSyncResourcesResponse> {
    private static final SdkField<List<SyncResourceSummary>> SYNC_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("syncResources").getter(ListSyncResourcesResponse.getter(ListSyncResourcesResponse::syncResources)).setter(ListSyncResourcesResponse.setter(Builder::syncResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SyncResourceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSyncResourcesResponse.getter(ListSyncResourcesResponse::nextToken)).setter(ListSyncResourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYNC_RESOURCES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("syncResources", SYNC_RESOURCES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<SyncResourceSummary> syncResources;
    private final String nextToken;

    private ListSyncResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.syncResources = builder.syncResources;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSyncResources() {
        return this.syncResources != null && !(this.syncResources instanceof SdkAutoConstructList);
    }

    public final List<SyncResourceSummary> syncResources() {
        return this.syncResources;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSyncResources() ? this.syncResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSyncResourcesResponse)) {
            return false;
        }
        ListSyncResourcesResponse other = (ListSyncResourcesResponse)((Object)obj);
        return this.hasSyncResources() == other.hasSyncResources() && Objects.equals(this.syncResources(), other.syncResources()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSyncResourcesResponse").add("SyncResources", this.hasSyncResources() ? this.syncResources() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "syncResources": {
                return Optional.ofNullable(clazz.cast(this.syncResources()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListSyncResourcesResponse, T> g) {
        return obj -> g.apply((ListSyncResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerResponse.BuilderImpl
    implements Builder {
        private List<SyncResourceSummary> syncResources = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSyncResourcesResponse model) {
            super(model);
            this.syncResources(model.syncResources);
            this.nextToken(model.nextToken);
        }

        public final List<SyncResourceSummary.Builder> getSyncResources() {
            List<SyncResourceSummary.Builder> result = SyncResourceSummariesCopier.copyToBuilder(this.syncResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSyncResources(Collection<SyncResourceSummary.BuilderImpl> syncResources) {
            this.syncResources = SyncResourceSummariesCopier.copyFromBuilder(syncResources);
        }

        @Override
        public final Builder syncResources(Collection<SyncResourceSummary> syncResources) {
            this.syncResources = SyncResourceSummariesCopier.copy(syncResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder syncResources(SyncResourceSummary ... syncResources) {
            this.syncResources(Arrays.asList(syncResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder syncResources(Consumer<SyncResourceSummary.Builder> ... syncResources) {
            this.syncResources(Stream.of(syncResources).map(c -> (SyncResourceSummary)((SyncResourceSummary.Builder)SyncResourceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSyncResourcesResponse build() {
            return new ListSyncResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTTwinMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSyncResourcesResponse> {
        public Builder syncResources(Collection<SyncResourceSummary> var1);

        public Builder syncResources(SyncResourceSummary ... var1);

        public Builder syncResources(Consumer<SyncResourceSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

