/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iottwinmaker.model.DataValue;
import software.amazon.awssdk.services.iottwinmaker.model.DataValueListCopier;
import software.amazon.awssdk.services.iottwinmaker.model.Relationship;
import software.amazon.awssdk.services.iottwinmaker.model.Type;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataType> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(DataType.getter(DataType::typeAsString)).setter(DataType.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<DataType> NESTED_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("nestedType").getter(DataType.getter(DataType::nestedType)).setter(DataType.setter(Builder::nestedType)).constructor(DataType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nestedType").build()}).build();
    private static final SdkField<List<DataValue>> ALLOWED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedValues").getter(DataType.getter(DataType::allowedValues)).setter(DataType.setter(Builder::allowedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> UNIT_OF_MEASURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("unitOfMeasure").getter(DataType.getter(DataType::unitOfMeasure)).setter(DataType.setter(Builder::unitOfMeasure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unitOfMeasure").build()}).build();
    private static final SdkField<Relationship> RELATIONSHIP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("relationship").getter(DataType.getter(DataType::relationship)).setter(DataType.setter(Builder::relationship)).constructor(Relationship::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationship").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, NESTED_TYPE_FIELD, ALLOWED_VALUES_FIELD, UNIT_OF_MEASURE_FIELD, RELATIONSHIP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("type", TYPE_FIELD);
            this.put("nestedType", NESTED_TYPE_FIELD);
            this.put("allowedValues", ALLOWED_VALUES_FIELD);
            this.put("unitOfMeasure", UNIT_OF_MEASURE_FIELD);
            this.put("relationship", RELATIONSHIP_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String type;
    private final DataType nestedType;
    private final List<DataValue> allowedValues;
    private final String unitOfMeasure;
    private final Relationship relationship;

    private DataType(BuilderImpl builder) {
        this.type = builder.type;
        this.nestedType = builder.nestedType;
        this.allowedValues = builder.allowedValues;
        this.unitOfMeasure = builder.unitOfMeasure;
        this.relationship = builder.relationship;
    }

    public final Type type() {
        return Type.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final DataType nestedType() {
        return this.nestedType;
    }

    public final boolean hasAllowedValues() {
        return this.allowedValues != null && !(this.allowedValues instanceof SdkAutoConstructList);
    }

    public final List<DataValue> allowedValues() {
        return this.allowedValues;
    }

    public final String unitOfMeasure() {
        return this.unitOfMeasure;
    }

    public final Relationship relationship() {
        return this.relationship;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nestedType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedValues() ? this.allowedValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.unitOfMeasure());
        hashCode = 31 * hashCode + Objects.hashCode(this.relationship());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataType)) {
            return false;
        }
        DataType other = (DataType)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.nestedType(), other.nestedType()) && this.hasAllowedValues() == other.hasAllowedValues() && Objects.equals(this.allowedValues(), other.allowedValues()) && Objects.equals(this.unitOfMeasure(), other.unitOfMeasure()) && Objects.equals(this.relationship(), other.relationship());
    }

    public final String toString() {
        return ToString.builder((String)"DataType").add("Type", (Object)this.typeAsString()).add("NestedType", (Object)this.nestedType()).add("AllowedValues", this.hasAllowedValues() ? this.allowedValues() : null).add("UnitOfMeasure", (Object)this.unitOfMeasure()).add("Relationship", (Object)this.relationship()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "nestedType": {
                return Optional.ofNullable(clazz.cast(this.nestedType()));
            }
            case "allowedValues": {
                return Optional.ofNullable(clazz.cast(this.allowedValues()));
            }
            case "unitOfMeasure": {
                return Optional.ofNullable(clazz.cast(this.unitOfMeasure()));
            }
            case "relationship": {
                return Optional.ofNullable(clazz.cast(this.relationship()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DataType, T> g) {
        return obj -> g.apply((DataType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private DataType nestedType;
        private List<DataValue> allowedValues = DefaultSdkAutoConstructList.getInstance();
        private String unitOfMeasure;
        private Relationship relationship;

        private BuilderImpl() {
        }

        private BuilderImpl(DataType model) {
            this.type(model.type);
            this.nestedType(model.nestedType);
            this.allowedValues(model.allowedValues);
            this.unitOfMeasure(model.unitOfMeasure);
            this.relationship(model.relationship);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Builder getNestedType() {
            return this.nestedType != null ? this.nestedType.toBuilder() : null;
        }

        public final void setNestedType(BuilderImpl nestedType) {
            this.nestedType = nestedType != null ? nestedType.build() : null;
        }

        @Override
        public final Builder nestedType(DataType nestedType) {
            this.nestedType = nestedType;
            return this;
        }

        public final List<DataValue.Builder> getAllowedValues() {
            List<DataValue.Builder> result = DataValueListCopier.copyToBuilder(this.allowedValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAllowedValues(Collection<DataValue.BuilderImpl> allowedValues) {
            this.allowedValues = DataValueListCopier.copyFromBuilder(allowedValues);
        }

        @Override
        public final Builder allowedValues(Collection<DataValue> allowedValues) {
            this.allowedValues = DataValueListCopier.copy(allowedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(DataValue ... allowedValues) {
            this.allowedValues(Arrays.asList(allowedValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(Consumer<DataValue.Builder> ... allowedValues) {
            this.allowedValues(Stream.of(allowedValues).map(c -> (DataValue)((DataValue.Builder)DataValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUnitOfMeasure() {
            return this.unitOfMeasure;
        }

        public final void setUnitOfMeasure(String unitOfMeasure) {
            this.unitOfMeasure = unitOfMeasure;
        }

        @Override
        public final Builder unitOfMeasure(String unitOfMeasure) {
            this.unitOfMeasure = unitOfMeasure;
            return this;
        }

        public final Relationship.Builder getRelationship() {
            return this.relationship != null ? this.relationship.toBuilder() : null;
        }

        public final void setRelationship(Relationship.BuilderImpl relationship) {
            this.relationship = relationship != null ? relationship.build() : null;
        }

        @Override
        public final Builder relationship(Relationship relationship) {
            this.relationship = relationship;
            return this;
        }

        public DataType build() {
            return new DataType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataType> {
        public Builder type(String var1);

        public Builder type(Type var1);

        public Builder nestedType(DataType var1);

        default public Builder nestedType(Consumer<Builder> nestedType) {
            return this.nestedType((DataType)((Builder)DataType.builder().applyMutation(nestedType)).build());
        }

        public Builder allowedValues(Collection<DataValue> var1);

        public Builder allowedValues(DataValue ... var1);

        public Builder allowedValues(Consumer<DataValue.Builder> ... var1);

        public Builder unitOfMeasure(String var1);

        public Builder relationship(Relationship var1);

        default public Builder relationship(Consumer<Relationship.Builder> relationship) {
            return this.relationship((Relationship)((Relationship.Builder)Relationship.builder().applyMutation(relationship)).build());
        }
    }
}

