/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteEntityRequest
extends IoTTwinMakerRequest
implements ToCopyableBuilder<Builder, DeleteEntityRequest> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(DeleteEntityRequest.getter(DeleteEntityRequest::workspaceId)).setter(DeleteEntityRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()}).build();
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityId").getter(DeleteEntityRequest.getter(DeleteEntityRequest::entityId)).setter(DeleteEntityRequest.setter(Builder::entityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityId").build()}).build();
    private static final SdkField<Boolean> IS_RECURSIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isRecursive").getter(DeleteEntityRequest.getter(DeleteEntityRequest::isRecursive)).setter(DeleteEntityRequest.setter(Builder::isRecursive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("isRecursive").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD, ENTITY_ID_FIELD, IS_RECURSIVE_FIELD));
    private final String workspaceId;
    private final String entityId;
    private final Boolean isRecursive;

    private DeleteEntityRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.entityId = builder.entityId;
        this.isRecursive = builder.isRecursive;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    public final String entityId() {
        return this.entityId;
    }

    public final Boolean isRecursive() {
        return this.isRecursive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isRecursive());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEntityRequest)) {
            return false;
        }
        DeleteEntityRequest other = (DeleteEntityRequest)((Object)obj);
        return Objects.equals(this.workspaceId(), other.workspaceId()) && Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.isRecursive(), other.isRecursive());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteEntityRequest").add("WorkspaceId", (Object)this.workspaceId()).add("EntityId", (Object)this.entityId()).add("IsRecursive", (Object)this.isRecursive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
            case "entityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "isRecursive": {
                return Optional.ofNullable(clazz.cast(this.isRecursive()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteEntityRequest, T> g) {
        return obj -> g.apply((DeleteEntityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerRequest.BuilderImpl
    implements Builder {
        private String workspaceId;
        private String entityId;
        private Boolean isRecursive;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEntityRequest model) {
            super(model);
            this.workspaceId(model.workspaceId);
            this.entityId(model.entityId);
            this.isRecursive(model.isRecursive);
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getEntityId() {
            return this.entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final Boolean getIsRecursive() {
            return this.isRecursive;
        }

        public final void setIsRecursive(Boolean isRecursive) {
            this.isRecursive = isRecursive;
        }

        @Override
        public final Builder isRecursive(Boolean isRecursive) {
            this.isRecursive = isRecursive;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteEntityRequest build() {
            return new DeleteEntityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTTwinMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteEntityRequest> {
        public Builder workspaceId(String var1);

        public Builder entityId(String var1);

        public Builder isRecursive(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

