/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerResponse;
import software.amazon.awssdk.services.iottwinmaker.model.MetadataTransferJobSummariesCopier;
import software.amazon.awssdk.services.iottwinmaker.model.MetadataTransferJobSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMetadataTransferJobsResponse
extends IoTTwinMakerResponse
implements ToCopyableBuilder<Builder, ListMetadataTransferJobsResponse> {
    private static final SdkField<List<MetadataTransferJobSummary>> METADATA_TRANSFER_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metadataTransferJobSummaries").getter(ListMetadataTransferJobsResponse.getter(ListMetadataTransferJobsResponse::metadataTransferJobSummaries)).setter(ListMetadataTransferJobsResponse.setter(Builder::metadataTransferJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataTransferJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetadataTransferJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListMetadataTransferJobsResponse.getter(ListMetadataTransferJobsResponse::nextToken)).setter(ListMetadataTransferJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_TRANSFER_JOB_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<MetadataTransferJobSummary> metadataTransferJobSummaries;
    private final String nextToken;

    private ListMetadataTransferJobsResponse(BuilderImpl builder) {
        super(builder);
        this.metadataTransferJobSummaries = builder.metadataTransferJobSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMetadataTransferJobSummaries() {
        return this.metadataTransferJobSummaries != null && !(this.metadataTransferJobSummaries instanceof SdkAutoConstructList);
    }

    public final List<MetadataTransferJobSummary> metadataTransferJobSummaries() {
        return this.metadataTransferJobSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadataTransferJobSummaries() ? this.metadataTransferJobSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetadataTransferJobsResponse)) {
            return false;
        }
        ListMetadataTransferJobsResponse other = (ListMetadataTransferJobsResponse)((Object)obj);
        return this.hasMetadataTransferJobSummaries() == other.hasMetadataTransferJobSummaries() && Objects.equals(this.metadataTransferJobSummaries(), other.metadataTransferJobSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMetadataTransferJobsResponse").add("MetadataTransferJobSummaries", this.hasMetadataTransferJobSummaries() ? this.metadataTransferJobSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metadataTransferJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.metadataTransferJobSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMetadataTransferJobsResponse, T> g) {
        return obj -> g.apply((ListMetadataTransferJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerResponse.BuilderImpl
    implements Builder {
        private List<MetadataTransferJobSummary> metadataTransferJobSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMetadataTransferJobsResponse model) {
            super(model);
            this.metadataTransferJobSummaries(model.metadataTransferJobSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<MetadataTransferJobSummary.Builder> getMetadataTransferJobSummaries() {
            List<MetadataTransferJobSummary.Builder> result = MetadataTransferJobSummariesCopier.copyToBuilder(this.metadataTransferJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetadataTransferJobSummaries(Collection<MetadataTransferJobSummary.BuilderImpl> metadataTransferJobSummaries) {
            this.metadataTransferJobSummaries = MetadataTransferJobSummariesCopier.copyFromBuilder(metadataTransferJobSummaries);
        }

        @Override
        public final Builder metadataTransferJobSummaries(Collection<MetadataTransferJobSummary> metadataTransferJobSummaries) {
            this.metadataTransferJobSummaries = MetadataTransferJobSummariesCopier.copy(metadataTransferJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataTransferJobSummaries(MetadataTransferJobSummary ... metadataTransferJobSummaries) {
            this.metadataTransferJobSummaries(Arrays.asList(metadataTransferJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataTransferJobSummaries(Consumer<MetadataTransferJobSummary.Builder> ... metadataTransferJobSummaries) {
            this.metadataTransferJobSummaries(Stream.of(metadataTransferJobSummaries).map(c -> (MetadataTransferJobSummary)((MetadataTransferJobSummary.Builder)MetadataTransferJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMetadataTransferJobsResponse build() {
            return new ListMetadataTransferJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTTwinMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMetadataTransferJobsResponse> {
        public Builder metadataTransferJobSummaries(Collection<MetadataTransferJobSummary> var1);

        public Builder metadataTransferJobSummaries(MetadataTransferJobSummary ... var1);

        public Builder metadataTransferJobSummaries(Consumer<MetadataTransferJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

