/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iottwinmaker.DefaultIoTTwinMakerBaseClientBuilder;
import software.amazon.awssdk.services.iottwinmaker.DefaultIoTTwinMakerClient;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerClient;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerClientBuilder;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerServiceClientConfiguration;
import software.amazon.awssdk.services.iottwinmaker.endpoints.IoTTwinMakerEndpointProvider;

@SdkInternalApi
final class DefaultIoTTwinMakerClientBuilder
extends DefaultIoTTwinMakerBaseClientBuilder<IoTTwinMakerClientBuilder, IoTTwinMakerClient>
implements IoTTwinMakerClientBuilder {
    DefaultIoTTwinMakerClientBuilder() {
    }

    @Override
    public DefaultIoTTwinMakerClientBuilder endpointProvider(IoTTwinMakerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IoTTwinMakerClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultIoTTwinMakerClientBuilder.validateClientOptions(clientConfiguration);
        IoTTwinMakerServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultIoTTwinMakerClient client = new DefaultIoTTwinMakerClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private IoTTwinMakerServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return IoTTwinMakerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

