/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.iottwinmaker.model.AccessDeniedException;
import software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyValuesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyValuesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ConflictException;
import software.amazon.awssdk.services.iottwinmaker.model.ConnectorFailureException;
import software.amazon.awssdk.services.iottwinmaker.model.ConnectorTimeoutException;
import software.amazon.awssdk.services.iottwinmaker.model.CreateComponentTypeRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CreateComponentTypeResponse;
import software.amazon.awssdk.services.iottwinmaker.model.CreateEntityRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CreateEntityResponse;
import software.amazon.awssdk.services.iottwinmaker.model.CreateSceneRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CreateSceneResponse;
import software.amazon.awssdk.services.iottwinmaker.model.CreateSyncJobRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CreateSyncJobResponse;
import software.amazon.awssdk.services.iottwinmaker.model.CreateWorkspaceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.CreateWorkspaceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteComponentTypeRequest;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteComponentTypeResponse;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteEntityRequest;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteEntityResponse;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteSceneRequest;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteSceneResponse;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteSyncJobRequest;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteSyncJobResponse;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteWorkspaceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.DeleteWorkspaceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetComponentTypeResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetEntityRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetEntityResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetPricingPlanRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetPricingPlanResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetSceneRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetSceneResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetSyncJobRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetSyncJobResponse;
import software.amazon.awssdk.services.iottwinmaker.model.GetWorkspaceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetWorkspaceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.InternalServerException;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerException;
import software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListComponentTypesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListScenesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListScenesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncResourcesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesResponse;
import software.amazon.awssdk.services.iottwinmaker.model.QueryTimeoutException;
import software.amazon.awssdk.services.iottwinmaker.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iottwinmaker.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.iottwinmaker.model.TagResourceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.TagResourceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ThrottlingException;
import software.amazon.awssdk.services.iottwinmaker.model.TooManyTagsException;
import software.amazon.awssdk.services.iottwinmaker.model.UntagResourceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UntagResourceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateComponentTypeRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateComponentTypeResponse;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateEntityRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateEntityResponse;
import software.amazon.awssdk.services.iottwinmaker.model.UpdatePricingPlanRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UpdatePricingPlanResponse;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateSceneRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateSceneResponse;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateWorkspaceRequest;
import software.amazon.awssdk.services.iottwinmaker.model.UpdateWorkspaceResponse;
import software.amazon.awssdk.services.iottwinmaker.model.ValidationException;
import software.amazon.awssdk.services.iottwinmaker.transform.BatchPutPropertyValuesRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.CreateComponentTypeRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.CreateEntityRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.CreateSceneRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.CreateSyncJobRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.CreateWorkspaceRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.DeleteComponentTypeRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.DeleteEntityRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.DeleteSceneRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.DeleteSyncJobRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.DeleteWorkspaceRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.ExecuteQueryRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.GetComponentTypeRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.GetEntityRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.GetPricingPlanRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.GetPropertyValueHistoryRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.GetPropertyValueRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.GetSceneRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.GetSyncJobRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.GetWorkspaceRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.ListComponentTypesRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.ListEntitiesRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.ListScenesRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.ListSyncJobsRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.ListSyncResourcesRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.ListWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.UpdateComponentTypeRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.UpdateEntityRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.UpdatePricingPlanRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.UpdateSceneRequestMarshaller;
import software.amazon.awssdk.services.iottwinmaker.transform.UpdateWorkspaceRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link IoTTwinMakerClient}.
 *
 * @see IoTTwinMakerClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultIoTTwinMakerClient implements IoTTwinMakerClient {
    private static final Logger log = Logger.loggerFor(DefaultIoTTwinMakerClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final IoTTwinMakerServiceClientConfiguration serviceClientConfiguration;

    protected DefaultIoTTwinMakerClient(IoTTwinMakerServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Sets values for multiple time series properties.
     * </p>
     *
     * @param batchPutPropertyValuesRequest
     * @return Result of the BatchPutPropertyValues operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.BatchPutPropertyValues
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/BatchPutPropertyValues"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchPutPropertyValuesResponse batchPutPropertyValues(BatchPutPropertyValuesRequest batchPutPropertyValuesRequest)
            throws InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException,
            AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchPutPropertyValuesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchPutPropertyValuesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchPutPropertyValuesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchPutPropertyValues");
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            return clientHandler
                    .execute(new ClientExecutionParams<BatchPutPropertyValuesRequest, BatchPutPropertyValuesResponse>()
                            .withOperationName("BatchPutPropertyValues").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withInput(batchPutPropertyValuesRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchPutPropertyValuesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a component type.
     * </p>
     *
     * @param createComponentTypeRequest
     * @return Result of the CreateComponentType operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConflictException
     *         A conflict occurred.
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.CreateComponentType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateComponentType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateComponentTypeResponse createComponentType(CreateComponentTypeRequest createComponentTypeRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateComponentTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateComponentTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createComponentTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateComponentType");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<CreateComponentTypeRequest, CreateComponentTypeResponse>()
                    .withOperationName("CreateComponentType").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(createComponentTypeRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateComponentTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an entity.
     * </p>
     *
     * @param createEntityRequest
     * @return Result of the CreateEntity operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConflictException
     *         A conflict occurred.
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.CreateEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateEntity" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateEntityResponse createEntity(CreateEntityRequest createEntityRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, ConflictException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateEntityResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateEntityResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEntityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEntity");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<CreateEntityRequest, CreateEntityResponse>()
                    .withOperationName("CreateEntity").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(createEntityRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateEntityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a scene.
     * </p>
     *
     * @param createSceneRequest
     * @return Result of the CreateScene operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConflictException
     *         A conflict occurred.
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.CreateScene
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateScene" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateSceneResponse createScene(CreateSceneRequest createSceneRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, ConflictException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSceneResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateSceneResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSceneRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateScene");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<CreateSceneRequest, CreateSceneResponse>()
                    .withOperationName("CreateScene").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(createSceneRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSceneRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This action creates a SyncJob.
     * </p>
     *
     * @param createSyncJobRequest
     * @return Result of the CreateSyncJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConflictException
     *         A conflict occurred.
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.CreateSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateSyncJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateSyncJobResponse createSyncJob(CreateSyncJobRequest createSyncJobRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, ConflictException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSyncJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateSyncJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSyncJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSyncJob");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<CreateSyncJobRequest, CreateSyncJobResponse>()
                    .withOperationName("CreateSyncJob").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(createSyncJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSyncJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a workplace.
     * </p>
     *
     * @param createWorkspaceRequest
     * @return Result of the CreateWorkspace operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConflictException
     *         A conflict occurred.
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.CreateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/CreateWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateWorkspaceResponse createWorkspace(CreateWorkspaceRequest createWorkspaceRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, ConflictException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWorkspaceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateWorkspaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkspaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkspace");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<CreateWorkspaceRequest, CreateWorkspaceResponse>()
                    .withOperationName("CreateWorkspace").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(createWorkspaceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateWorkspaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a component type.
     * </p>
     *
     * @param deleteComponentTypeRequest
     * @return Result of the DeleteComponentType operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.DeleteComponentType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteComponentType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteComponentTypeResponse deleteComponentType(DeleteComponentTypeRequest deleteComponentTypeRequest)
            throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteComponentTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteComponentTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteComponentTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteComponentType");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<DeleteComponentTypeRequest, DeleteComponentTypeResponse>()
                    .withOperationName("DeleteComponentType").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(deleteComponentTypeRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteComponentTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an entity.
     * </p>
     *
     * @param deleteEntityRequest
     * @return Result of the DeleteEntity operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.DeleteEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteEntity" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteEntityResponse deleteEntity(DeleteEntityRequest deleteEntityRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteEntityResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteEntityResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteEntityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteEntity");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<DeleteEntityRequest, DeleteEntityResponse>()
                    .withOperationName("DeleteEntity").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(deleteEntityRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteEntityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a scene.
     * </p>
     *
     * @param deleteSceneRequest
     * @return Result of the DeleteScene operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.DeleteScene
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteScene" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteSceneResponse deleteScene(DeleteSceneRequest deleteSceneRequest) throws InternalServerException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSceneResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteSceneResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSceneRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteScene");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<DeleteSceneRequest, DeleteSceneResponse>()
                    .withOperationName("DeleteScene").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(deleteSceneRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteSceneRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete the SyncJob.
     * </p>
     *
     * @param deleteSyncJobRequest
     * @return Result of the DeleteSyncJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.DeleteSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteSyncJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteSyncJobResponse deleteSyncJob(DeleteSyncJobRequest deleteSyncJobRequest) throws InternalServerException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSyncJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteSyncJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSyncJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSyncJob");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<DeleteSyncJobRequest, DeleteSyncJobResponse>()
                    .withOperationName("DeleteSyncJob").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(deleteSyncJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteSyncJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a workspace.
     * </p>
     *
     * @param deleteWorkspaceRequest
     * @return Result of the DeleteWorkspace operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.DeleteWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/DeleteWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteWorkspaceResponse deleteWorkspace(DeleteWorkspaceRequest deleteWorkspaceRequest) throws InternalServerException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteWorkspaceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteWorkspaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkspaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkspace");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<DeleteWorkspaceRequest, DeleteWorkspaceResponse>()
                    .withOperationName("DeleteWorkspace").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(deleteWorkspaceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteWorkspaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Run queries to access information from your knowledge graph of entities within individual workspaces.
     * </p>
     *
     * @param executeQueryRequest
     * @return Result of the ExecuteQuery operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws QueryTimeoutException
     *         The query timeout exception.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ExecuteQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ExecuteQuery" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ExecuteQueryResponse executeQuery(ExecuteQueryRequest executeQueryRequest) throws InternalServerException,
            AccessDeniedException, QueryTimeoutException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ExecuteQueryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ExecuteQueryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, executeQueryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ExecuteQuery");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<ExecuteQueryRequest, ExecuteQueryResponse>()
                    .withOperationName("ExecuteQuery").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(executeQueryRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ExecuteQueryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a component type.
     * </p>
     *
     * @param getComponentTypeRequest
     * @return Result of the GetComponentType operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetComponentType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetComponentType" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetComponentTypeResponse getComponentType(GetComponentTypeRequest getComponentTypeRequest)
            throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetComponentTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetComponentTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getComponentTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetComponentType");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<GetComponentTypeRequest, GetComponentTypeResponse>()
                    .withOperationName("GetComponentType").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(getComponentTypeRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetComponentTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about an entity.
     * </p>
     *
     * @param getEntityRequest
     * @return Result of the GetEntity operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetEntity" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetEntityResponse getEntity(GetEntityRequest getEntityRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEntityResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetEntityResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEntityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEntity");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<GetEntityRequest, GetEntityResponse>()
                    .withOperationName("GetEntity").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(getEntityRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetEntityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the pricing plan.
     * </p>
     *
     * @param getPricingPlanRequest
     * @return Result of the GetPricingPlan operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetPricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPricingPlan" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetPricingPlanResponse getPricingPlan(GetPricingPlanRequest getPricingPlanRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPricingPlanResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetPricingPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPricingPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPricingPlan");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<GetPricingPlanRequest, GetPricingPlanResponse>()
                    .withOperationName("GetPricingPlan").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(getPricingPlanRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetPricingPlanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the property values for a component, component type, entity, or workspace.
     * </p>
     * <p>
     * You must specify a value for either <code>componentName</code>, <code>componentTypeId</code>,
     * <code>entityId</code>, or <code>workspaceId</code>.
     * </p>
     *
     * @param getPropertyValueRequest
     * @return Result of the GetPropertyValue operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ConnectorFailureException
     *         The connector failed.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConnectorTimeoutException
     *         The connector timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetPropertyValue
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPropertyValue" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetPropertyValueResponse getPropertyValue(GetPropertyValueRequest getPropertyValueRequest)
            throws InternalServerException, ConnectorFailureException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, ValidationException, ConnectorTimeoutException, AwsServiceException, SdkClientException,
            IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPropertyValueResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetPropertyValueResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPropertyValueRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPropertyValue");
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            return clientHandler.execute(new ClientExecutionParams<GetPropertyValueRequest, GetPropertyValueResponse>()
                    .withOperationName("GetPropertyValue").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(getPropertyValueRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetPropertyValueRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the history of a time series property value for a component, component type, entity,
     * or workspace.
     * </p>
     * <p>
     * You must specify a value for <code>workspaceId</code>. For entity-specific queries, specify values for
     * <code>componentName</code> and <code>entityId</code>. For cross-entity quries, specify a value for
     * <code>componentTypeId</code>.
     * </p>
     *
     * @param getPropertyValueHistoryRequest
     * @return Result of the GetPropertyValueHistory operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ConnectorFailureException
     *         The connector failed.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConnectorTimeoutException
     *         The connector timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetPropertyValueHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetPropertyValueHistoryResponse getPropertyValueHistory(GetPropertyValueHistoryRequest getPropertyValueHistoryRequest)
            throws InternalServerException, ConnectorFailureException, AccessDeniedException, ResourceNotFoundException,
            ThrottlingException, ValidationException, ConnectorTimeoutException, AwsServiceException, SdkClientException,
            IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPropertyValueHistoryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetPropertyValueHistoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPropertyValueHistoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPropertyValueHistory");
            String hostPrefix = "data.";
            String resolvedHostExpression = "data.";

            return clientHandler
                    .execute(new ClientExecutionParams<GetPropertyValueHistoryRequest, GetPropertyValueHistoryResponse>()
                            .withOperationName("GetPropertyValueHistory").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withInput(getPropertyValueHistoryRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetPropertyValueHistoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a scene.
     * </p>
     *
     * @param getSceneRequest
     * @return Result of the GetScene operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetScene
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetScene" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetSceneResponse getScene(GetSceneRequest getSceneRequest) throws InternalServerException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSceneResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSceneResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSceneRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetScene");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<GetSceneRequest, GetSceneResponse>()
                    .withOperationName("GetScene").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(getSceneRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSceneRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the SyncJob.
     * </p>
     *
     * @param getSyncJobRequest
     * @return Result of the GetSyncJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetSyncJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetSyncJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetSyncJobResponse getSyncJob(GetSyncJobRequest getSyncJobRequest) throws InternalServerException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSyncJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSyncJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSyncJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSyncJob");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<GetSyncJobRequest, GetSyncJobResponse>()
                    .withOperationName("GetSyncJob").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(getSyncJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSyncJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a workspace.
     * </p>
     *
     * @param getWorkspaceRequest
     * @return Result of the GetWorkspace operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.GetWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/GetWorkspace" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetWorkspaceResponse getWorkspace(GetWorkspaceRequest getWorkspaceRequest) throws InternalServerException,
            ResourceNotFoundException, ThrottlingException, ValidationException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetWorkspaceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetWorkspaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWorkspaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorkspace");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<GetWorkspaceRequest, GetWorkspaceResponse>()
                    .withOperationName("GetWorkspace").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(getWorkspaceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetWorkspaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all component types in a workspace.
     * </p>
     *
     * @param listComponentTypesRequest
     * @return Result of the ListComponentTypes operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListComponentTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListComponentTypes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListComponentTypesResponse listComponentTypes(ListComponentTypesRequest listComponentTypesRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListComponentTypesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListComponentTypesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listComponentTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListComponentTypes");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<ListComponentTypesRequest, ListComponentTypesResponse>()
                    .withOperationName("ListComponentTypes").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(listComponentTypesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListComponentTypesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all entities in a workspace.
     * </p>
     *
     * @param listEntitiesRequest
     * @return Result of the ListEntities operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListEntities" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListEntitiesResponse listEntities(ListEntitiesRequest listEntitiesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListEntitiesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListEntitiesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEntitiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEntities");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<ListEntitiesRequest, ListEntitiesResponse>()
                    .withOperationName("ListEntities").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(listEntitiesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListEntitiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all scenes in a workspace.
     * </p>
     *
     * @param listScenesRequest
     * @return Result of the ListScenes operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListScenes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListScenes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListScenesResponse listScenes(ListScenesRequest listScenesRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListScenesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListScenesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listScenesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListScenes");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<ListScenesRequest, ListScenesResponse>()
                    .withOperationName("ListScenes").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(listScenesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListScenesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List all SyncJobs.
     * </p>
     *
     * @param listSyncJobsRequest
     * @return Result of the ListSyncJobs operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListSyncJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListSyncJobs" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListSyncJobsResponse listSyncJobs(ListSyncJobsRequest listSyncJobsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSyncJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListSyncJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSyncJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSyncJobs");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<ListSyncJobsRequest, ListSyncJobsResponse>()
                    .withOperationName("ListSyncJobs").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(listSyncJobsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListSyncJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the sync resources.
     * </p>
     *
     * @param listSyncResourcesRequest
     * @return Result of the ListSyncResources operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListSyncResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListSyncResources"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSyncResourcesResponse listSyncResources(ListSyncResourcesRequest listSyncResourcesRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSyncResourcesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListSyncResourcesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSyncResourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSyncResources");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<ListSyncResourcesRequest, ListSyncResourcesResponse>()
                    .withOperationName("ListSyncResources").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(listSyncResourcesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListSyncResourcesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all tags associated with a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(listTagsForResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about workspaces in the current account.
     * </p>
     *
     * @param listWorkspacesRequest
     * @return Result of the ListWorkspaces operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.ListWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/ListWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListWorkspacesResponse listWorkspaces(ListWorkspacesRequest listWorkspacesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListWorkspacesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListWorkspacesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorkspacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkspaces");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<ListWorkspacesRequest, ListWorkspacesResponse>()
                    .withOperationName("ListWorkspaces").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(listWorkspacesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListWorkspacesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws TooManyTagsException
     *         The number of tags exceeds the limit.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws TooManyTagsException,
            AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(untagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates information in a component type.
     * </p>
     *
     * @param updateComponentTypeRequest
     * @return Result of the UpdateComponentType operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.UpdateComponentType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateComponentType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateComponentTypeResponse updateComponentType(UpdateComponentTypeRequest updateComponentTypeRequest)
            throws InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateComponentTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateComponentTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateComponentTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateComponentType");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<UpdateComponentTypeRequest, UpdateComponentTypeResponse>()
                    .withOperationName("UpdateComponentType").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(updateComponentTypeRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateComponentTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an entity.
     * </p>
     *
     * @param updateEntityRequest
     * @return Result of the UpdateEntity operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ConflictException
     *         A conflict occurred.
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.UpdateEntity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateEntity" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateEntityResponse updateEntity(UpdateEntityRequest updateEntityRequest) throws InternalServerException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, ConflictException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateEntityResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateEntityResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEntityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEntity");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<UpdateEntityRequest, UpdateEntityResponse>()
                    .withOperationName("UpdateEntity").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(updateEntityRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateEntityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update the pricing plan.
     * </p>
     *
     * @param updatePricingPlanRequest
     * @return Result of the UpdatePricingPlan operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.UpdatePricingPlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdatePricingPlan"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdatePricingPlanResponse updatePricingPlan(UpdatePricingPlanRequest updatePricingPlanRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePricingPlanResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdatePricingPlanResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePricingPlanRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePricingPlan");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<UpdatePricingPlanRequest, UpdatePricingPlanResponse>()
                    .withOperationName("UpdatePricingPlan").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(updatePricingPlanRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdatePricingPlanRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a scene.
     * </p>
     *
     * @param updateSceneRequest
     * @return Result of the UpdateScene operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.UpdateScene
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateScene" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateSceneResponse updateScene(UpdateSceneRequest updateSceneRequest) throws InternalServerException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSceneResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateSceneResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSceneRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateScene");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<UpdateSceneRequest, UpdateSceneResponse>()
                    .withOperationName("UpdateScene").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(updateSceneRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateSceneRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a workspace.
     * </p>
     *
     * @param updateWorkspaceRequest
     * @return Result of the UpdateWorkspace operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error has occurred.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ResourceNotFoundException
     *         The resource wasn't found.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ValidationException
     *         Failed
     * @throws ServiceQuotaExceededException
     *         The service quota was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTTwinMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTTwinMakerClient.UpdateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iottwinmaker-2021-11-29/UpdateWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateWorkspaceResponse updateWorkspace(UpdateWorkspaceRequest updateWorkspaceRequest) throws InternalServerException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IoTTwinMakerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateWorkspaceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateWorkspaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWorkspaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTTwinMaker");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWorkspace");
            String hostPrefix = "api.";
            String resolvedHostExpression = "api.";

            return clientHandler.execute(new ClientExecutionParams<UpdateWorkspaceRequest, UpdateWorkspaceResponse>()
                    .withOperationName("UpdateWorkspace").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withInput(updateWorkspaceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateWorkspaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(IoTTwinMakerException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConnectorFailureException")
                                .exceptionBuilderSupplier(ConnectorFailureException::builder).httpStatusCode(424).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagsException")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConnectorTimeoutException")
                                .exceptionBuilderSupplier(ConnectorTimeoutException::builder).httpStatusCode(424).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("QueryTimeoutException")
                                .exceptionBuilderSupplier(QueryTimeoutException::builder).httpStatusCode(400).build());
    }

    @Override
    public final IoTTwinMakerServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
