/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerClient;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueHistoryResponse;

public class GetPropertyValueHistoryIterable
implements SdkIterable<GetPropertyValueHistoryResponse> {
    private final IoTTwinMakerClient client;
    private final GetPropertyValueHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetPropertyValueHistoryIterable(IoTTwinMakerClient client, GetPropertyValueHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetPropertyValueHistoryResponseFetcher();
    }

    public Iterator<GetPropertyValueHistoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetPropertyValueHistoryResponseFetcher
    implements SyncPageFetcher<GetPropertyValueHistoryResponse> {
        private GetPropertyValueHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetPropertyValueHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetPropertyValueHistoryResponse nextPage(GetPropertyValueHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetPropertyValueHistoryIterable.this.client.getPropertyValueHistory(GetPropertyValueHistoryIterable.this.firstRequest);
            }
            return GetPropertyValueHistoryIterable.this.client.getPropertyValueHistory((GetPropertyValueHistoryRequest)((Object)GetPropertyValueHistoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

