/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerAsyncClient;
import software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryResponse;

public class ExecuteQueryPublisher
implements SdkPublisher<ExecuteQueryResponse> {
    private final IoTTwinMakerAsyncClient client;
    private final ExecuteQueryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ExecuteQueryPublisher(IoTTwinMakerAsyncClient client, ExecuteQueryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ExecuteQueryPublisher(IoTTwinMakerAsyncClient client, ExecuteQueryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ExecuteQueryResponseFetcher();
    }

    public void subscribe(Subscriber<? super ExecuteQueryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ExecuteQueryResponseFetcher
    implements AsyncPageFetcher<ExecuteQueryResponse> {
        private ExecuteQueryResponseFetcher() {
        }

        public boolean hasNextPage(ExecuteQueryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ExecuteQueryResponse> nextPage(ExecuteQueryResponse previousPage) {
            if (previousPage == null) {
                return ExecuteQueryPublisher.this.client.executeQuery(ExecuteQueryPublisher.this.firstRequest);
            }
            return ExecuteQueryPublisher.this.client.executeQuery((ExecuteQueryRequest)((Object)ExecuteQueryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

