/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerClient;
import software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesResponse;

public class ListWorkspacesIterable
implements SdkIterable<ListWorkspacesResponse> {
    private final IoTTwinMakerClient client;
    private final ListWorkspacesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkspacesIterable(IoTTwinMakerClient client, ListWorkspacesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListWorkspacesResponseFetcher();
    }

    public Iterator<ListWorkspacesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListWorkspacesResponseFetcher
    implements SyncPageFetcher<ListWorkspacesResponse> {
        private ListWorkspacesResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkspacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkspacesResponse nextPage(ListWorkspacesResponse previousPage) {
            if (previousPage == null) {
                return ListWorkspacesIterable.this.client.listWorkspaces(ListWorkspacesIterable.this.firstRequest);
            }
            return ListWorkspacesIterable.this.client.listWorkspaces((ListWorkspacesRequest)((Object)ListWorkspacesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

