/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerResponse;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyValueHistory;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPropertyValueHistoryResponse
extends IoTTwinMakerResponse
implements ToCopyableBuilder<Builder, GetPropertyValueHistoryResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetPropertyValueHistoryResponse.getter(GetPropertyValueHistoryResponse::nextToken)).setter(GetPropertyValueHistoryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<PropertyValueHistory>> PROPERTY_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("propertyValues").getter(GetPropertyValueHistoryResponse.getter(GetPropertyValueHistoryResponse::propertyValues)).setter(GetPropertyValueHistoryResponse.setter(Builder::propertyValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyValueHistory::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PROPERTY_VALUES_FIELD));
    private final String nextToken;
    private final List<PropertyValueHistory> propertyValues;

    private GetPropertyValueHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.propertyValues = builder.propertyValues;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasPropertyValues() {
        return this.propertyValues != null && !(this.propertyValues instanceof SdkAutoConstructList);
    }

    public final List<PropertyValueHistory> propertyValues() {
        return this.propertyValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertyValues() ? this.propertyValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPropertyValueHistoryResponse)) {
            return false;
        }
        GetPropertyValueHistoryResponse other = (GetPropertyValueHistoryResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasPropertyValues() == other.hasPropertyValues() && Objects.equals(this.propertyValues(), other.propertyValues());
    }

    public final String toString() {
        return ToString.builder((String)"GetPropertyValueHistoryResponse").add("NextToken", (Object)this.nextToken()).add("PropertyValues", this.hasPropertyValues() ? this.propertyValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "propertyValues": {
                return Optional.ofNullable(clazz.cast(this.propertyValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPropertyValueHistoryResponse, T> g) {
        return obj -> g.apply((GetPropertyValueHistoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<PropertyValueHistory> propertyValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPropertyValueHistoryResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.propertyValues(model.propertyValues);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PropertyValueHistory.Builder> getPropertyValues() {
            List<PropertyValueHistory.Builder> result = PropertyValueListCopier.copyToBuilder(this.propertyValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPropertyValues(Collection<PropertyValueHistory.BuilderImpl> propertyValues) {
            this.propertyValues = PropertyValueListCopier.copyFromBuilder(propertyValues);
        }

        @Override
        @Transient
        public final Builder propertyValues(Collection<PropertyValueHistory> propertyValues) {
            this.propertyValues = PropertyValueListCopier.copy(propertyValues);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder propertyValues(PropertyValueHistory ... propertyValues) {
            this.propertyValues(Arrays.asList(propertyValues));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder propertyValues(Consumer<PropertyValueHistory.Builder> ... propertyValues) {
            this.propertyValues(Stream.of(propertyValues).map(c -> (PropertyValueHistory)((PropertyValueHistory.Builder)PropertyValueHistory.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetPropertyValueHistoryResponse build() {
            return new GetPropertyValueHistoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTTwinMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPropertyValueHistoryResponse> {
        public Builder nextToken(String var1);

        public Builder propertyValues(Collection<PropertyValueHistory> var1);

        public Builder propertyValues(PropertyValueHistory ... var1);

        public Builder propertyValues(Consumer<PropertyValueHistory.Builder> ... var1);
    }
}

