/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iottwinmaker.model.BatchPutPropertyErrorEntry;
import software.amazon.awssdk.services.iottwinmaker.model.ErrorEntriesCopier;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchPutPropertyValuesResponse
extends IoTTwinMakerResponse
implements ToCopyableBuilder<Builder, BatchPutPropertyValuesResponse> {
    private static final SdkField<List<BatchPutPropertyErrorEntry>> ERROR_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errorEntries").getter(BatchPutPropertyValuesResponse.getter(BatchPutPropertyValuesResponse::errorEntries)).setter(BatchPutPropertyValuesResponse.setter(Builder::errorEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchPutPropertyErrorEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_ENTRIES_FIELD));
    private final List<BatchPutPropertyErrorEntry> errorEntries;

    private BatchPutPropertyValuesResponse(BuilderImpl builder) {
        super(builder);
        this.errorEntries = builder.errorEntries;
    }

    public final boolean hasErrorEntries() {
        return this.errorEntries != null && !(this.errorEntries instanceof SdkAutoConstructList);
    }

    public final List<BatchPutPropertyErrorEntry> errorEntries() {
        return this.errorEntries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorEntries() ? this.errorEntries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutPropertyValuesResponse)) {
            return false;
        }
        BatchPutPropertyValuesResponse other = (BatchPutPropertyValuesResponse)((Object)obj);
        return this.hasErrorEntries() == other.hasErrorEntries() && Objects.equals(this.errorEntries(), other.errorEntries());
    }

    public final String toString() {
        return ToString.builder((String)"BatchPutPropertyValuesResponse").add("ErrorEntries", this.hasErrorEntries() ? this.errorEntries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errorEntries": {
                return Optional.ofNullable(clazz.cast(this.errorEntries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPutPropertyValuesResponse, T> g) {
        return obj -> g.apply((BatchPutPropertyValuesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerResponse.BuilderImpl
    implements Builder {
        private List<BatchPutPropertyErrorEntry> errorEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutPropertyValuesResponse model) {
            super(model);
            this.errorEntries(model.errorEntries);
        }

        public final List<BatchPutPropertyErrorEntry.Builder> getErrorEntries() {
            List<BatchPutPropertyErrorEntry.Builder> result = ErrorEntriesCopier.copyToBuilder(this.errorEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorEntries(Collection<BatchPutPropertyErrorEntry.BuilderImpl> errorEntries) {
            this.errorEntries = ErrorEntriesCopier.copyFromBuilder(errorEntries);
        }

        @Override
        @Transient
        public final Builder errorEntries(Collection<BatchPutPropertyErrorEntry> errorEntries) {
            this.errorEntries = ErrorEntriesCopier.copy(errorEntries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder errorEntries(BatchPutPropertyErrorEntry ... errorEntries) {
            this.errorEntries(Arrays.asList(errorEntries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder errorEntries(Consumer<BatchPutPropertyErrorEntry.Builder> ... errorEntries) {
            this.errorEntries(Stream.of(errorEntries).map(c -> (BatchPutPropertyErrorEntry)((BatchPutPropertyErrorEntry.Builder)BatchPutPropertyErrorEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchPutPropertyValuesResponse build() {
            return new BatchPutPropertyValuesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTTwinMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchPutPropertyValuesResponse> {
        public Builder errorEntries(Collection<BatchPutPropertyErrorEntry> var1);

        public Builder errorEntries(BatchPutPropertyErrorEntry ... var1);

        public Builder errorEntries(Consumer<BatchPutPropertyErrorEntry.Builder> ... var1);
    }
}

