/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iottwinmaker.model.EntriesCopier;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerRequest;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyValueEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchPutPropertyValuesRequest
extends IoTTwinMakerRequest
implements ToCopyableBuilder<Builder, BatchPutPropertyValuesRequest> {
    private static final SdkField<List<PropertyValueEntry>> ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("entries").getter(BatchPutPropertyValuesRequest.getter(BatchPutPropertyValuesRequest::entries)).setter(BatchPutPropertyValuesRequest.setter(Builder::entries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyValueEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(BatchPutPropertyValuesRequest.getter(BatchPutPropertyValuesRequest::workspaceId)).setter(BatchPutPropertyValuesRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRIES_FIELD, WORKSPACE_ID_FIELD));
    private final List<PropertyValueEntry> entries;
    private final String workspaceId;

    private BatchPutPropertyValuesRequest(BuilderImpl builder) {
        super(builder);
        this.entries = builder.entries;
        this.workspaceId = builder.workspaceId;
    }

    public final boolean hasEntries() {
        return this.entries != null && !(this.entries instanceof SdkAutoConstructList);
    }

    public final List<PropertyValueEntry> entries() {
        return this.entries;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntries() ? this.entries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutPropertyValuesRequest)) {
            return false;
        }
        BatchPutPropertyValuesRequest other = (BatchPutPropertyValuesRequest)((Object)obj);
        return this.hasEntries() == other.hasEntries() && Objects.equals(this.entries(), other.entries()) && Objects.equals(this.workspaceId(), other.workspaceId());
    }

    public final String toString() {
        return ToString.builder((String)"BatchPutPropertyValuesRequest").add("Entries", this.hasEntries() ? this.entries() : null).add("WorkspaceId", (Object)this.workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entries": {
                return Optional.ofNullable(clazz.cast(this.entries()));
            }
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchPutPropertyValuesRequest, T> g) {
        return obj -> g.apply((BatchPutPropertyValuesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerRequest.BuilderImpl
    implements Builder {
        private List<PropertyValueEntry> entries = DefaultSdkAutoConstructList.getInstance();
        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutPropertyValuesRequest model) {
            super(model);
            this.entries(model.entries);
            this.workspaceId(model.workspaceId);
        }

        public final List<PropertyValueEntry.Builder> getEntries() {
            List<PropertyValueEntry.Builder> result = EntriesCopier.copyToBuilder(this.entries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntries(Collection<PropertyValueEntry.BuilderImpl> entries) {
            this.entries = EntriesCopier.copyFromBuilder(entries);
        }

        @Override
        @Transient
        public final Builder entries(Collection<PropertyValueEntry> entries) {
            this.entries = EntriesCopier.copy(entries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entries(PropertyValueEntry ... entries) {
            this.entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entries(Consumer<PropertyValueEntry.Builder> ... entries) {
            this.entries(Stream.of(entries).map(c -> (PropertyValueEntry)((PropertyValueEntry.Builder)PropertyValueEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        @Transient
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchPutPropertyValuesRequest build() {
            return new BatchPutPropertyValuesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTTwinMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchPutPropertyValuesRequest> {
        public Builder entries(Collection<PropertyValueEntry> var1);

        public Builder entries(PropertyValueEntry ... var1);

        public Builder entries(Consumer<PropertyValueEntry.Builder> ... var1);

        public Builder workspaceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

