/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iotthingsgraph.model.EntityDescription;
import software.amazon.awssdk.services.iotthingsgraph.model.EntityDescriptionsCopier;
import software.amazon.awssdk.services.iotthingsgraph.model.IoTThingsGraphResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEntitiesResponse
extends IoTThingsGraphResponse
implements ToCopyableBuilder<Builder, GetEntitiesResponse> {
    private static final SdkField<List<EntityDescription>> DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetEntitiesResponse.getter(GetEntitiesResponse::descriptions)).setter(GetEntitiesResponse.setter(Builder::descriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("descriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EntityDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTIONS_FIELD));
    private final List<EntityDescription> descriptions;

    private GetEntitiesResponse(BuilderImpl builder) {
        super(builder);
        this.descriptions = builder.descriptions;
    }

    public List<EntityDescription> descriptions() {
        return this.descriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.descriptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEntitiesResponse)) {
            return false;
        }
        GetEntitiesResponse other = (GetEntitiesResponse)((Object)obj);
        return Objects.equals(this.descriptions(), other.descriptions());
    }

    public String toString() {
        return ToString.builder((String)"GetEntitiesResponse").add("Descriptions", this.descriptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "descriptions": {
                return Optional.ofNullable(clazz.cast(this.descriptions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEntitiesResponse, T> g) {
        return obj -> g.apply((GetEntitiesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTThingsGraphResponse.BuilderImpl
    implements Builder {
        private List<EntityDescription> descriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEntitiesResponse model) {
            super(model);
            this.descriptions(model.descriptions);
        }

        public final Collection<EntityDescription.Builder> getDescriptions() {
            return this.descriptions != null ? (Collection)this.descriptions.stream().map(EntityDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder descriptions(Collection<EntityDescription> descriptions) {
            this.descriptions = EntityDescriptionsCopier.copy(descriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder descriptions(EntityDescription ... descriptions) {
            this.descriptions(Arrays.asList(descriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder descriptions(Consumer<EntityDescription.Builder> ... descriptions) {
            this.descriptions(Stream.of(descriptions).map(c -> (EntityDescription)((EntityDescription.Builder)EntityDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDescriptions(Collection<EntityDescription.BuilderImpl> descriptions) {
            this.descriptions = EntityDescriptionsCopier.copyFromBuilder(descriptions);
        }

        @Override
        public GetEntitiesResponse build() {
            return new GetEntitiesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTThingsGraphResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEntitiesResponse> {
        public Builder descriptions(Collection<EntityDescription> var1);

        public Builder descriptions(EntityDescription ... var1);

        public Builder descriptions(Consumer<EntityDescription.Builder> ... var1);
    }
}

