/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotthingsgraph.model.DefinitionLanguage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DefinitionDocument
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DefinitionDocument> {
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("language").getter(DefinitionDocument.getter(DefinitionDocument::languageAsString)).setter(DefinitionDocument.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("text").getter(DefinitionDocument.getter(DefinitionDocument::text)).setter(DefinitionDocument.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_FIELD, TEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("language", LANGUAGE_FIELD);
            this.put("text", TEXT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String language;
    private final String text;

    private DefinitionDocument(BuilderImpl builder) {
        this.language = builder.language;
        this.text = builder.text;
    }

    public final DefinitionLanguage language() {
        return DefinitionLanguage.fromValue(this.language);
    }

    public final String languageAsString() {
        return this.language;
    }

    public final String text() {
        return this.text;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.languageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefinitionDocument)) {
            return false;
        }
        DefinitionDocument other = (DefinitionDocument)obj;
        return Objects.equals(this.languageAsString(), other.languageAsString()) && Objects.equals(this.text(), other.text());
    }

    public final String toString() {
        return ToString.builder((String)"DefinitionDocument").add("Language", (Object)this.languageAsString()).add("Text", (Object)this.text()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "language": {
                return Optional.ofNullable(clazz.cast(this.languageAsString()));
            }
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DefinitionDocument, T> g) {
        return obj -> g.apply((DefinitionDocument)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String language;
        private String text;

        private BuilderImpl() {
        }

        private BuilderImpl(DefinitionDocument model) {
            this.language(model.language);
            this.text(model.text);
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        @Override
        public final Builder language(DefinitionLanguage language) {
            this.language(language == null ? null : language.toString());
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public DefinitionDocument build() {
            return new DefinitionDocument(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DefinitionDocument> {
        public Builder language(String var1);

        public Builder language(DefinitionLanguage var1);

        public Builder text(String var1);
    }
}

