/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotthingsgraph.model.IoTThingsGraphResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SystemTemplateSummariesCopier;
import software.amazon.awssdk.services.iotthingsgraph.model.SystemTemplateSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSystemTemplateRevisionsResponse
extends IoTThingsGraphResponse
implements ToCopyableBuilder<Builder, GetSystemTemplateRevisionsResponse> {
    private static final SdkField<List<SystemTemplateSummary>> SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("summaries").getter(GetSystemTemplateRevisionsResponse.getter(GetSystemTemplateRevisionsResponse::summaries)).setter(GetSystemTemplateRevisionsResponse.setter(Builder::summaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SystemTemplateSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetSystemTemplateRevisionsResponse.getter(GetSystemTemplateRevisionsResponse::nextToken)).setter(GetSystemTemplateRevisionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<SystemTemplateSummary> summaries;
    private final String nextToken;

    private GetSystemTemplateRevisionsResponse(BuilderImpl builder) {
        super(builder);
        this.summaries = builder.summaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSummaries() {
        return this.summaries != null && !(this.summaries instanceof SdkAutoConstructList);
    }

    public final List<SystemTemplateSummary> summaries() {
        return this.summaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSummaries() ? this.summaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSystemTemplateRevisionsResponse)) {
            return false;
        }
        GetSystemTemplateRevisionsResponse other = (GetSystemTemplateRevisionsResponse)((Object)obj);
        return this.hasSummaries() == other.hasSummaries() && Objects.equals(this.summaries(), other.summaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetSystemTemplateRevisionsResponse").add("Summaries", this.hasSummaries() ? this.summaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "summaries": {
                return Optional.ofNullable(clazz.cast(this.summaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSystemTemplateRevisionsResponse, T> g) {
        return obj -> g.apply((GetSystemTemplateRevisionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTThingsGraphResponse.BuilderImpl
    implements Builder {
        private List<SystemTemplateSummary> summaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSystemTemplateRevisionsResponse model) {
            super(model);
            this.summaries(model.summaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<SystemTemplateSummary.Builder> getSummaries() {
            if (this.summaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.summaries != null ? (Collection)this.summaries.stream().map(SystemTemplateSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder summaries(Collection<SystemTemplateSummary> summaries) {
            this.summaries = SystemTemplateSummariesCopier.copy(summaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(SystemTemplateSummary ... summaries) {
            this.summaries(Arrays.asList(summaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(Consumer<SystemTemplateSummary.Builder> ... summaries) {
            this.summaries(Stream.of(summaries).map(c -> (SystemTemplateSummary)((SystemTemplateSummary.Builder)SystemTemplateSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSummaries(Collection<SystemTemplateSummary.BuilderImpl> summaries) {
            this.summaries = SystemTemplateSummariesCopier.copyFromBuilder(summaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetSystemTemplateRevisionsResponse build() {
            return new GetSystemTemplateRevisionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTThingsGraphResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSystemTemplateRevisionsResponse> {
        public Builder summaries(Collection<SystemTemplateSummary> var1);

        public Builder summaries(SystemTemplateSummary ... var1);

        public Builder summaries(Consumer<SystemTemplateSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

