/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains a system's definition document and summary information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SystemTemplateDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<SystemTemplateDescription.Builder, SystemTemplateDescription> {
    private static final SdkField<SystemTemplateSummary> SUMMARY_FIELD = SdkField
            .<SystemTemplateSummary> builder(MarshallingType.SDK_POJO).memberName("summary")
            .getter(getter(SystemTemplateDescription::summary)).setter(setter(Builder::summary))
            .constructor(SystemTemplateSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()).build();

    private static final SdkField<DefinitionDocument> DEFINITION_FIELD = SdkField
            .<DefinitionDocument> builder(MarshallingType.SDK_POJO).memberName("definition")
            .getter(getter(SystemTemplateDescription::definition)).setter(setter(Builder::definition))
            .constructor(DefinitionDocument::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<Long> VALIDATED_NAMESPACE_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("validatedNamespaceVersion").getter(getter(SystemTemplateDescription::validatedNamespaceVersion))
            .setter(setter(Builder::validatedNamespaceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validatedNamespaceVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARY_FIELD,
            DEFINITION_FIELD, VALIDATED_NAMESPACE_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final SystemTemplateSummary summary;

    private final DefinitionDocument definition;

    private final Long validatedNamespaceVersion;

    private SystemTemplateDescription(BuilderImpl builder) {
        this.summary = builder.summary;
        this.definition = builder.definition;
        this.validatedNamespaceVersion = builder.validatedNamespaceVersion;
    }

    /**
     * <p>
     * An object that contains summary information about a system.
     * </p>
     * 
     * @return An object that contains summary information about a system.
     */
    public final SystemTemplateSummary summary() {
        return summary;
    }

    /**
     * <p>
     * The definition document of a system.
     * </p>
     * 
     * @return The definition document of a system.
     */
    public final DefinitionDocument definition() {
        return definition;
    }

    /**
     * <p>
     * The namespace version against which the system was validated. Use this value in your system instance.
     * </p>
     * 
     * @return The namespace version against which the system was validated. Use this value in your system instance.
     */
    public final Long validatedNamespaceVersion() {
        return validatedNamespaceVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(validatedNamespaceVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SystemTemplateDescription)) {
            return false;
        }
        SystemTemplateDescription other = (SystemTemplateDescription) obj;
        return Objects.equals(summary(), other.summary()) && Objects.equals(definition(), other.definition())
                && Objects.equals(validatedNamespaceVersion(), other.validatedNamespaceVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SystemTemplateDescription").add("Summary", summary()).add("Definition", definition())
                .add("ValidatedNamespaceVersion", validatedNamespaceVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "summary":
            return Optional.ofNullable(clazz.cast(summary()));
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "validatedNamespaceVersion":
            return Optional.ofNullable(clazz.cast(validatedNamespaceVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SystemTemplateDescription, T> g) {
        return obj -> g.apply((SystemTemplateDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SystemTemplateDescription> {
        /**
         * <p>
         * An object that contains summary information about a system.
         * </p>
         * 
         * @param summary
         *        An object that contains summary information about a system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(SystemTemplateSummary summary);

        /**
         * <p>
         * An object that contains summary information about a system.
         * </p>
         * This is a convenience that creates an instance of the {@link SystemTemplateSummary.Builder} avoiding the need
         * to create one manually via {@link SystemTemplateSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link SystemTemplateSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #summary(SystemTemplateSummary)}.
         * 
         * @param summary
         *        a consumer that will call methods on {@link SystemTemplateSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summary(SystemTemplateSummary)
         */
        default Builder summary(Consumer<SystemTemplateSummary.Builder> summary) {
            return summary(SystemTemplateSummary.builder().applyMutation(summary).build());
        }

        /**
         * <p>
         * The definition document of a system.
         * </p>
         * 
         * @param definition
         *        The definition document of a system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(DefinitionDocument definition);

        /**
         * <p>
         * The definition document of a system.
         * </p>
         * This is a convenience that creates an instance of the {@link DefinitionDocument.Builder} avoiding the need to
         * create one manually via {@link DefinitionDocument#builder()}.
         *
         * When the {@link Consumer} completes, {@link DefinitionDocument.Builder#build()} is called immediately and its
         * result is passed to {@link #definition(DefinitionDocument)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link DefinitionDocument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(DefinitionDocument)
         */
        default Builder definition(Consumer<DefinitionDocument.Builder> definition) {
            return definition(DefinitionDocument.builder().applyMutation(definition).build());
        }

        /**
         * <p>
         * The namespace version against which the system was validated. Use this value in your system instance.
         * </p>
         * 
         * @param validatedNamespaceVersion
         *        The namespace version against which the system was validated. Use this value in your system instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validatedNamespaceVersion(Long validatedNamespaceVersion);
    }

    static final class BuilderImpl implements Builder {
        private SystemTemplateSummary summary;

        private DefinitionDocument definition;

        private Long validatedNamespaceVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(SystemTemplateDescription model) {
            summary(model.summary);
            definition(model.definition);
            validatedNamespaceVersion(model.validatedNamespaceVersion);
        }

        public final SystemTemplateSummary.Builder getSummary() {
            return summary != null ? summary.toBuilder() : null;
        }

        @Override
        public final Builder summary(SystemTemplateSummary summary) {
            this.summary = summary;
            return this;
        }

        public final void setSummary(SystemTemplateSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        public final DefinitionDocument.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        @Override
        public final Builder definition(DefinitionDocument definition) {
            this.definition = definition;
            return this;
        }

        public final void setDefinition(DefinitionDocument.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        public final Long getValidatedNamespaceVersion() {
            return validatedNamespaceVersion;
        }

        @Override
        public final Builder validatedNamespaceVersion(Long validatedNamespaceVersion) {
            this.validatedNamespaceVersion = validatedNamespaceVersion;
            return this;
        }

        public final void setValidatedNamespaceVersion(Long validatedNamespaceVersion) {
            this.validatedNamespaceVersion = validatedNamespaceVersion;
        }

        @Override
        public SystemTemplateDescription build() {
            return new SystemTemplateDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
