/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains summary information about a system instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SystemInstanceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SystemInstanceSummary.Builder, SystemInstanceSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(SystemInstanceSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(SystemInstanceSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(SystemInstanceSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("target")
            .getter(getter(SystemInstanceSummary::targetAsString)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<String> GREENGRASS_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("greengrassGroupName").getter(getter(SystemInstanceSummary::greengrassGroupName))
            .setter(setter(Builder::greengrassGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greengrassGroupName").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(SystemInstanceSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(SystemInstanceSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> GREENGRASS_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("greengrassGroupId").getter(getter(SystemInstanceSummary::greengrassGroupId))
            .setter(setter(Builder::greengrassGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greengrassGroupId").build()).build();

    private static final SdkField<String> GREENGRASS_GROUP_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("greengrassGroupVersionId").getter(getter(SystemInstanceSummary::greengrassGroupVersionId))
            .setter(setter(Builder::greengrassGroupVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greengrassGroupVersionId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            STATUS_FIELD, TARGET_FIELD, GREENGRASS_GROUP_NAME_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD,
            GREENGRASS_GROUP_ID_FIELD, GREENGRASS_GROUP_VERSION_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String status;

    private final String target;

    private final String greengrassGroupName;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String greengrassGroupId;

    private final String greengrassGroupVersionId;

    private SystemInstanceSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.status = builder.status;
        this.target = builder.target;
        this.greengrassGroupName = builder.greengrassGroupName;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.greengrassGroupId = builder.greengrassGroupId;
        this.greengrassGroupVersionId = builder.greengrassGroupVersionId;
    }

    /**
     * <p>
     * The ID of the system instance.
     * </p>
     * 
     * @return The ID of the system instance.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ARN of the system instance.
     * </p>
     * 
     * @return The ARN of the system instance.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The status of the system instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SystemInstanceDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the system instance.
     * @see SystemInstanceDeploymentStatus
     */
    public final SystemInstanceDeploymentStatus status() {
        return SystemInstanceDeploymentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the system instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SystemInstanceDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the system instance.
     * @see SystemInstanceDeploymentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The target of the system instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #target} will
     * return {@link DeploymentTarget#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetAsString}.
     * </p>
     * 
     * @return The target of the system instance.
     * @see DeploymentTarget
     */
    public final DeploymentTarget target() {
        return DeploymentTarget.fromValue(target);
    }

    /**
     * <p>
     * The target of the system instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #target} will
     * return {@link DeploymentTarget#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetAsString}.
     * </p>
     * 
     * @return The target of the system instance.
     * @see DeploymentTarget
     */
    public final String targetAsString() {
        return target;
    }

    /**
     * <p>
     * The ID of the Greengrass group where the system instance is deployed.
     * </p>
     * 
     * @return The ID of the Greengrass group where the system instance is deployed.
     */
    public final String greengrassGroupName() {
        return greengrassGroupName;
    }

    /**
     * <p>
     * The date when the system instance was created.
     * </p>
     * 
     * @return The date when the system instance was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time when the system instance was last updated.
     * </p>
     * 
     * @return The date and time when the system instance was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The ID of the Greengrass group where the system instance is deployed.
     * </p>
     * 
     * @return The ID of the Greengrass group where the system instance is deployed.
     */
    public final String greengrassGroupId() {
        return greengrassGroupId;
    }

    /**
     * <p>
     * The version of the Greengrass group where the system instance is deployed.
     * </p>
     * 
     * @return The version of the Greengrass group where the system instance is deployed.
     */
    public final String greengrassGroupVersionId() {
        return greengrassGroupVersionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(greengrassGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(greengrassGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(greengrassGroupVersionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SystemInstanceSummary)) {
            return false;
        }
        SystemInstanceSummary other = (SystemInstanceSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(targetAsString(), other.targetAsString())
                && Objects.equals(greengrassGroupName(), other.greengrassGroupName())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(greengrassGroupId(), other.greengrassGroupId())
                && Objects.equals(greengrassGroupVersionId(), other.greengrassGroupVersionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SystemInstanceSummary").add("Id", id()).add("Arn", arn()).add("Status", statusAsString())
                .add("Target", targetAsString()).add("GreengrassGroupName", greengrassGroupName()).add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt()).add("GreengrassGroupId", greengrassGroupId())
                .add("GreengrassGroupVersionId", greengrassGroupVersionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "target":
            return Optional.ofNullable(clazz.cast(targetAsString()));
        case "greengrassGroupName":
            return Optional.ofNullable(clazz.cast(greengrassGroupName()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "greengrassGroupId":
            return Optional.ofNullable(clazz.cast(greengrassGroupId()));
        case "greengrassGroupVersionId":
            return Optional.ofNullable(clazz.cast(greengrassGroupVersionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SystemInstanceSummary, T> g) {
        return obj -> g.apply((SystemInstanceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SystemInstanceSummary> {
        /**
         * <p>
         * The ID of the system instance.
         * </p>
         * 
         * @param id
         *        The ID of the system instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN of the system instance.
         * </p>
         * 
         * @param arn
         *        The ARN of the system instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status of the system instance.
         * </p>
         * 
         * @param status
         *        The status of the system instance.
         * @see SystemInstanceDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SystemInstanceDeploymentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the system instance.
         * </p>
         * 
         * @param status
         *        The status of the system instance.
         * @see SystemInstanceDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SystemInstanceDeploymentStatus
         */
        Builder status(SystemInstanceDeploymentStatus status);

        /**
         * <p>
         * The target of the system instance.
         * </p>
         * 
         * @param target
         *        The target of the system instance.
         * @see DeploymentTarget
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentTarget
         */
        Builder target(String target);

        /**
         * <p>
         * The target of the system instance.
         * </p>
         * 
         * @param target
         *        The target of the system instance.
         * @see DeploymentTarget
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentTarget
         */
        Builder target(DeploymentTarget target);

        /**
         * <p>
         * The ID of the Greengrass group where the system instance is deployed.
         * </p>
         * 
         * @param greengrassGroupName
         *        The ID of the Greengrass group where the system instance is deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greengrassGroupName(String greengrassGroupName);

        /**
         * <p>
         * The date when the system instance was created.
         * </p>
         * 
         * @param createdAt
         *        The date when the system instance was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time when the system instance was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time when the system instance was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The ID of the Greengrass group where the system instance is deployed.
         * </p>
         * 
         * @param greengrassGroupId
         *        The ID of the Greengrass group where the system instance is deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greengrassGroupId(String greengrassGroupId);

        /**
         * <p>
         * The version of the Greengrass group where the system instance is deployed.
         * </p>
         * 
         * @param greengrassGroupVersionId
         *        The version of the Greengrass group where the system instance is deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greengrassGroupVersionId(String greengrassGroupVersionId);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String status;

        private String target;

        private String greengrassGroupName;

        private Instant createdAt;

        private Instant updatedAt;

        private String greengrassGroupId;

        private String greengrassGroupVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(SystemInstanceSummary model) {
            id(model.id);
            arn(model.arn);
            status(model.status);
            target(model.target);
            greengrassGroupName(model.greengrassGroupName);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            greengrassGroupId(model.greengrassGroupId);
            greengrassGroupVersionId(model.greengrassGroupVersionId);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SystemInstanceDeploymentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getTarget() {
            return target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        @Override
        public final Builder target(DeploymentTarget target) {
            this.target(target == null ? null : target.toString());
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public final String getGreengrassGroupName() {
            return greengrassGroupName;
        }

        @Override
        public final Builder greengrassGroupName(String greengrassGroupName) {
            this.greengrassGroupName = greengrassGroupName;
            return this;
        }

        public final void setGreengrassGroupName(String greengrassGroupName) {
            this.greengrassGroupName = greengrassGroupName;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        public final String getGreengrassGroupId() {
            return greengrassGroupId;
        }

        @Override
        public final Builder greengrassGroupId(String greengrassGroupId) {
            this.greengrassGroupId = greengrassGroupId;
            return this;
        }

        public final void setGreengrassGroupId(String greengrassGroupId) {
            this.greengrassGroupId = greengrassGroupId;
        }

        public final String getGreengrassGroupVersionId() {
            return greengrassGroupVersionId;
        }

        @Override
        public final Builder greengrassGroupVersionId(String greengrassGroupVersionId) {
            this.greengrassGroupVersionId = greengrassGroupVersionId;
            return this;
        }

        public final void setGreengrassGroupVersionId(String greengrassGroupVersionId) {
            this.greengrassGroupVersionId = greengrassGroupVersionId;
        }

        @Override
        public SystemInstanceSummary build() {
            return new SystemInstanceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
