/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphClient;
import software.amazon.awssdk.services.iotthingsgraph.model.AssociateEntityToThingRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.AssociateEntityToThingResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteNamespaceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteNamespaceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeploySystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeploySystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DissociateEntityFromThingRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DissociateEntityFromThingResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetEntitiesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetEntitiesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetNamespaceDeletionStatusRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetNamespaceDeletionStatusResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetUploadStatusRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetUploadStatusResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.InternalFailureException;
import software.amazon.awssdk.services.iotthingsgraph.model.InvalidRequestException;
import software.amazon.awssdk.services.iotthingsgraph.model.IoTThingsGraphException;
import software.amazon.awssdk.services.iotthingsgraph.model.IoTThingsGraphRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.LimitExceededException;
import software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.iotthingsgraph.model.ResourceInUseException;
import software.amazon.awssdk.services.iotthingsgraph.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.TagResourceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.TagResourceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.ThrottlingException;
import software.amazon.awssdk.services.iotthingsgraph.model.UndeploySystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UndeploySystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UploadEntityDefinitionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UploadEntityDefinitionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.paginators.GetFlowTemplateRevisionsIterable;
import software.amazon.awssdk.services.iotthingsgraph.paginators.GetSystemTemplateRevisionsIterable;
import software.amazon.awssdk.services.iotthingsgraph.paginators.ListFlowExecutionMessagesIterable;
import software.amazon.awssdk.services.iotthingsgraph.paginators.ListTagsForResourceIterable;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchEntitiesIterable;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowExecutionsIterable;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowTemplatesIterable;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemInstancesIterable;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemTemplatesIterable;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchThingsIterable;
import software.amazon.awssdk.services.iotthingsgraph.transform.AssociateEntityToThingRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.CreateFlowTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.CreateSystemInstanceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.CreateSystemTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeleteFlowTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeleteNamespaceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeleteSystemInstanceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeleteSystemTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeploySystemInstanceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeprecateFlowTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeprecateSystemTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DescribeNamespaceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DissociateEntityFromThingRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetEntitiesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetFlowTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetFlowTemplateRevisionsRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetNamespaceDeletionStatusRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetSystemInstanceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetSystemTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetSystemTemplateRevisionsRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetUploadStatusRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.ListFlowExecutionMessagesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchEntitiesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchFlowExecutionsRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchFlowTemplatesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchSystemInstancesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchSystemTemplatesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchThingsRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.UndeploySystemInstanceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.UpdateFlowTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.UpdateSystemTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.UploadEntityDefinitionsRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultIoTThingsGraphClient
implements IoTThingsGraphClient {
    private static final Logger log = Logger.loggerFor(DefaultIoTThingsGraphClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultIoTThingsGraphClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "iotthingsgraph";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateEntityToThingResponse associateEntityToThing(AssociateEntityToThingRequest associateEntityToThingRequest) throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateEntityToThingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, associateEntityToThingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateEntityToThing");
            AssociateEntityToThingResponse associateEntityToThingResponse = (AssociateEntityToThingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateEntityToThing").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateEntityToThingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateEntityToThingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateEntityToThingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$associateEntityToThing$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateFlowTemplateResponse createFlowTemplate(CreateFlowTemplateRequest createFlowTemplateRequest) throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFlowTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, createFlowTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFlowTemplate");
            CreateFlowTemplateResponse createFlowTemplateResponse = (CreateFlowTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFlowTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFlowTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateFlowTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createFlowTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$createFlowTemplate$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSystemInstanceResponse createSystemInstance(CreateSystemInstanceRequest createSystemInstanceRequest) throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException, LimitExceededException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSystemInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, createSystemInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSystemInstance");
            CreateSystemInstanceResponse createSystemInstanceResponse = (CreateSystemInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSystemInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSystemInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSystemInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSystemInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$createSystemInstance$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSystemTemplateResponse createSystemTemplate(CreateSystemTemplateRequest createSystemTemplateRequest) throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSystemTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, createSystemTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSystemTemplate");
            CreateSystemTemplateResponse createSystemTemplateResponse = (CreateSystemTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSystemTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSystemTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSystemTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSystemTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$createSystemTemplate$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteFlowTemplateResponse deleteFlowTemplate(DeleteFlowTemplateRequest deleteFlowTemplateRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceInUseException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFlowTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, deleteFlowTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFlowTemplate");
            DeleteFlowTemplateResponse deleteFlowTemplateResponse = (DeleteFlowTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFlowTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFlowTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteFlowTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteFlowTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$deleteFlowTemplate$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteNamespaceResponse deleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest) throws InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteNamespaceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, deleteNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteNamespace");
            DeleteNamespaceResponse deleteNamespaceResponse = (DeleteNamespaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteNamespace").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteNamespaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteNamespaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$deleteNamespace$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSystemInstanceResponse deleteSystemInstance(DeleteSystemInstanceRequest deleteSystemInstanceRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceInUseException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSystemInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, deleteSystemInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSystemInstance");
            DeleteSystemInstanceResponse deleteSystemInstanceResponse = (DeleteSystemInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSystemInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSystemInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSystemInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSystemInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$deleteSystemInstance$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSystemTemplateResponse deleteSystemTemplate(DeleteSystemTemplateRequest deleteSystemTemplateRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceInUseException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSystemTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, deleteSystemTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSystemTemplate");
            DeleteSystemTemplateResponse deleteSystemTemplateResponse = (DeleteSystemTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSystemTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSystemTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSystemTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSystemTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$deleteSystemTemplate$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploySystemInstanceResponse deploySystemInstance(DeploySystemInstanceRequest deploySystemInstanceRequest) throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, InternalFailureException, ResourceInUseException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeploySystemInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, deploySystemInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeploySystemInstance");
            DeploySystemInstanceResponse deploySystemInstanceResponse = (DeploySystemInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeploySystemInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deploySystemInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeploySystemInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deploySystemInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$deploySystemInstance$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeprecateFlowTemplateResponse deprecateFlowTemplate(DeprecateFlowTemplateRequest deprecateFlowTemplateRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeprecateFlowTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, deprecateFlowTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeprecateFlowTemplate");
            DeprecateFlowTemplateResponse deprecateFlowTemplateResponse = (DeprecateFlowTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeprecateFlowTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deprecateFlowTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeprecateFlowTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deprecateFlowTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$deprecateFlowTemplate$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeprecateSystemTemplateResponse deprecateSystemTemplate(DeprecateSystemTemplateRequest deprecateSystemTemplateRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeprecateSystemTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, deprecateSystemTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeprecateSystemTemplate");
            DeprecateSystemTemplateResponse deprecateSystemTemplateResponse = (DeprecateSystemTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeprecateSystemTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deprecateSystemTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeprecateSystemTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deprecateSystemTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$deprecateSystemTemplate$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeNamespaceResponse describeNamespace(DescribeNamespaceRequest describeNamespaceRequest) throws ResourceNotFoundException, InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeNamespaceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, describeNamespaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeNamespace");
            DescribeNamespaceResponse describeNamespaceResponse = (DescribeNamespaceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeNamespace").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeNamespaceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeNamespaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeNamespaceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$describeNamespace$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DissociateEntityFromThingResponse dissociateEntityFromThing(DissociateEntityFromThingRequest dissociateEntityFromThingRequest) throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DissociateEntityFromThingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, dissociateEntityFromThingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DissociateEntityFromThing");
            DissociateEntityFromThingResponse dissociateEntityFromThingResponse = (DissociateEntityFromThingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DissociateEntityFromThing").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)dissociateEntityFromThingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DissociateEntityFromThingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return dissociateEntityFromThingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$dissociateEntityFromThing$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEntitiesResponse getEntities(GetEntitiesRequest getEntitiesRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEntitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, getEntitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEntities");
            GetEntitiesResponse getEntitiesResponse = (GetEntitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEntities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEntitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEntitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$getEntities$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFlowTemplateResponse getFlowTemplate(GetFlowTemplateRequest getFlowTemplateRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFlowTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, getFlowTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFlowTemplate");
            GetFlowTemplateResponse getFlowTemplateResponse = (GetFlowTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFlowTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFlowTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetFlowTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getFlowTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$getFlowTemplate$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFlowTemplateRevisionsResponse getFlowTemplateRevisions(GetFlowTemplateRevisionsRequest getFlowTemplateRevisionsRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFlowTemplateRevisionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, getFlowTemplateRevisionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFlowTemplateRevisions");
            GetFlowTemplateRevisionsResponse getFlowTemplateRevisionsResponse = (GetFlowTemplateRevisionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFlowTemplateRevisions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFlowTemplateRevisionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetFlowTemplateRevisionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getFlowTemplateRevisionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$getFlowTemplateRevisions$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetFlowTemplateRevisionsIterable getFlowTemplateRevisionsPaginator(GetFlowTemplateRevisionsRequest getFlowTemplateRevisionsRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return new GetFlowTemplateRevisionsIterable(this, this.applyPaginatorUserAgent(getFlowTemplateRevisionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetNamespaceDeletionStatusResponse getNamespaceDeletionStatus(GetNamespaceDeletionStatusRequest getNamespaceDeletionStatusRequest) throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetNamespaceDeletionStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, getNamespaceDeletionStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetNamespaceDeletionStatus");
            GetNamespaceDeletionStatusResponse getNamespaceDeletionStatusResponse = (GetNamespaceDeletionStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetNamespaceDeletionStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getNamespaceDeletionStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetNamespaceDeletionStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getNamespaceDeletionStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$getNamespaceDeletionStatus$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSystemInstanceResponse getSystemInstance(GetSystemInstanceRequest getSystemInstanceRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSystemInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, getSystemInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSystemInstance");
            GetSystemInstanceResponse getSystemInstanceResponse = (GetSystemInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSystemInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSystemInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSystemInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSystemInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$getSystemInstance$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSystemTemplateResponse getSystemTemplate(GetSystemTemplateRequest getSystemTemplateRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSystemTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, getSystemTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSystemTemplate");
            GetSystemTemplateResponse getSystemTemplateResponse = (GetSystemTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSystemTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSystemTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSystemTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSystemTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$getSystemTemplate$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSystemTemplateRevisionsResponse getSystemTemplateRevisions(GetSystemTemplateRevisionsRequest getSystemTemplateRevisionsRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSystemTemplateRevisionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, getSystemTemplateRevisionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSystemTemplateRevisions");
            GetSystemTemplateRevisionsResponse getSystemTemplateRevisionsResponse = (GetSystemTemplateRevisionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSystemTemplateRevisions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSystemTemplateRevisionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSystemTemplateRevisionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSystemTemplateRevisionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$getSystemTemplateRevisions$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetSystemTemplateRevisionsIterable getSystemTemplateRevisionsPaginator(GetSystemTemplateRevisionsRequest getSystemTemplateRevisionsRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return new GetSystemTemplateRevisionsIterable(this, this.applyPaginatorUserAgent(getSystemTemplateRevisionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetUploadStatusResponse getUploadStatus(GetUploadStatusRequest getUploadStatusRequest) throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUploadStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, getUploadStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUploadStatus");
            GetUploadStatusResponse getUploadStatusResponse = (GetUploadStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUploadStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getUploadStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetUploadStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getUploadStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$getUploadStatus$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFlowExecutionMessagesResponse listFlowExecutionMessages(ListFlowExecutionMessagesRequest listFlowExecutionMessagesRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFlowExecutionMessagesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, listFlowExecutionMessagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFlowExecutionMessages");
            ListFlowExecutionMessagesResponse listFlowExecutionMessagesResponse = (ListFlowExecutionMessagesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFlowExecutionMessages").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFlowExecutionMessagesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListFlowExecutionMessagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFlowExecutionMessagesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$listFlowExecutionMessages$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListFlowExecutionMessagesIterable listFlowExecutionMessagesPaginator(ListFlowExecutionMessagesRequest listFlowExecutionMessagesRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return new ListFlowExecutionMessagesIterable(this, this.applyPaginatorUserAgent(listFlowExecutionMessagesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$listTagsForResource$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return new ListTagsForResourceIterable(this, this.applyPaginatorUserAgent(listTagsForResourceRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchEntitiesResponse searchEntities(SearchEntitiesRequest searchEntitiesRequest) throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchEntitiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, searchEntitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchEntities");
            SearchEntitiesResponse searchEntitiesResponse = (SearchEntitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchEntities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchEntitiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SearchEntitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return searchEntitiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$searchEntities$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public SearchEntitiesIterable searchEntitiesPaginator(SearchEntitiesRequest searchEntitiesRequest) throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return new SearchEntitiesIterable(this, this.applyPaginatorUserAgent(searchEntitiesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchFlowExecutionsResponse searchFlowExecutions(SearchFlowExecutionsRequest searchFlowExecutionsRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchFlowExecutionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, searchFlowExecutionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchFlowExecutions");
            SearchFlowExecutionsResponse searchFlowExecutionsResponse = (SearchFlowExecutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchFlowExecutions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchFlowExecutionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SearchFlowExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return searchFlowExecutionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$searchFlowExecutions$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public SearchFlowExecutionsIterable searchFlowExecutionsPaginator(SearchFlowExecutionsRequest searchFlowExecutionsRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return new SearchFlowExecutionsIterable(this, this.applyPaginatorUserAgent(searchFlowExecutionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchFlowTemplatesResponse searchFlowTemplates(SearchFlowTemplatesRequest searchFlowTemplatesRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchFlowTemplatesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, searchFlowTemplatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchFlowTemplates");
            SearchFlowTemplatesResponse searchFlowTemplatesResponse = (SearchFlowTemplatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchFlowTemplates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchFlowTemplatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SearchFlowTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return searchFlowTemplatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$searchFlowTemplates$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public SearchFlowTemplatesIterable searchFlowTemplatesPaginator(SearchFlowTemplatesRequest searchFlowTemplatesRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return new SearchFlowTemplatesIterable(this, this.applyPaginatorUserAgent(searchFlowTemplatesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchSystemInstancesResponse searchSystemInstances(SearchSystemInstancesRequest searchSystemInstancesRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchSystemInstancesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, searchSystemInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchSystemInstances");
            SearchSystemInstancesResponse searchSystemInstancesResponse = (SearchSystemInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchSystemInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchSystemInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SearchSystemInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return searchSystemInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$searchSystemInstances$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public SearchSystemInstancesIterable searchSystemInstancesPaginator(SearchSystemInstancesRequest searchSystemInstancesRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return new SearchSystemInstancesIterable(this, this.applyPaginatorUserAgent(searchSystemInstancesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchSystemTemplatesResponse searchSystemTemplates(SearchSystemTemplatesRequest searchSystemTemplatesRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchSystemTemplatesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, searchSystemTemplatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchSystemTemplates");
            SearchSystemTemplatesResponse searchSystemTemplatesResponse = (SearchSystemTemplatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchSystemTemplates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchSystemTemplatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SearchSystemTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return searchSystemTemplatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$searchSystemTemplates$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public SearchSystemTemplatesIterable searchSystemTemplatesPaginator(SearchSystemTemplatesRequest searchSystemTemplatesRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return new SearchSystemTemplatesIterable(this, this.applyPaginatorUserAgent(searchSystemTemplatesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SearchThingsResponse searchThings(SearchThingsRequest searchThingsRequest) throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchThingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, searchThingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchThings");
            SearchThingsResponse searchThingsResponse = (SearchThingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchThings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchThingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SearchThingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return searchThingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$searchThings$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public SearchThingsIterable searchThingsPaginator(SearchThingsRequest searchThingsRequest) throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return new SearchThingsIterable(this, this.applyPaginatorUserAgent(searchThingsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$tagResource$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UndeploySystemInstanceResponse undeploySystemInstance(UndeploySystemInstanceRequest undeploySystemInstanceRequest) throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UndeploySystemInstanceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, undeploySystemInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UndeploySystemInstance");
            UndeploySystemInstanceResponse undeploySystemInstanceResponse = (UndeploySystemInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UndeploySystemInstance").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)undeploySystemInstanceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UndeploySystemInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return undeploySystemInstanceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$undeploySystemInstance$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$untagResource$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFlowTemplateResponse updateFlowTemplate(UpdateFlowTemplateRequest updateFlowTemplateRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFlowTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, updateFlowTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFlowTemplate");
            UpdateFlowTemplateResponse updateFlowTemplateResponse = (UpdateFlowTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFlowTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFlowTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFlowTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFlowTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$updateFlowTemplate$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSystemTemplateResponse updateSystemTemplate(UpdateSystemTemplateRequest updateSystemTemplateRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSystemTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, updateSystemTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSystemTemplate");
            UpdateSystemTemplateResponse updateSystemTemplateResponse = (UpdateSystemTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSystemTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateSystemTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSystemTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSystemTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$updateSystemTemplate$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadEntityDefinitionsResponse uploadEntityDefinitions(UploadEntityDefinitionsRequest uploadEntityDefinitionsRequest) throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UploadEntityDefinitionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIoTThingsGraphClient.resolveMetricPublishers(this.clientConfiguration, uploadEntityDefinitionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UploadEntityDefinitions");
            UploadEntityDefinitionsResponse uploadEntityDefinitionsResponse = (UploadEntityDefinitionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UploadEntityDefinitions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)uploadEntityDefinitionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UploadEntityDefinitionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return uploadEntityDefinitionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIoTThingsGraphClient.lambda$uploadEntityDefinitions$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(IoTThingsGraphException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InternalFailureException").exceptionBuilderSupplier(InternalFailureException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUseException").exceptionBuilderSupplier(ResourceInUseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends IoTThingsGraphRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.15.54").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((IoTThingsGraphRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$uploadEntityDefinitions$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSystemTemplate$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFlowTemplate$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$undeploySystemInstance$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchThings$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchSystemTemplates$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchSystemInstances$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchFlowTemplates$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchFlowExecutions$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchEntities$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFlowExecutionMessages$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getUploadStatus$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSystemTemplateRevisions$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSystemTemplate$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSystemInstance$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getNamespaceDeletionStatus$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFlowTemplateRevisions$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFlowTemplate$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getEntities$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$dissociateEntityFromThing$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeNamespace$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deprecateSystemTemplate$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deprecateFlowTemplate$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deploySystemInstance$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSystemTemplate$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSystemInstance$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteNamespace$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFlowTemplate$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSystemTemplate$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSystemInstance$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFlowTemplate$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateEntityToThing$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

