/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionMessage;
import software.amazon.awssdk.services.iotthingsgraph.model.FlowExecutionMessagesCopier;
import software.amazon.awssdk.services.iotthingsgraph.model.IoTThingsGraphResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFlowExecutionMessagesResponse
extends IoTThingsGraphResponse
implements ToCopyableBuilder<Builder, ListFlowExecutionMessagesResponse> {
    private static final SdkField<List<FlowExecutionMessage>> MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("messages").getter(ListFlowExecutionMessagesResponse.getter(ListFlowExecutionMessagesResponse::messages)).setter(ListFlowExecutionMessagesResponse.setter(Builder::messages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FlowExecutionMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListFlowExecutionMessagesResponse.getter(ListFlowExecutionMessagesResponse::nextToken)).setter(ListFlowExecutionMessagesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGES_FIELD, NEXT_TOKEN_FIELD));
    private final List<FlowExecutionMessage> messages;
    private final String nextToken;

    private ListFlowExecutionMessagesResponse(BuilderImpl builder) {
        super(builder);
        this.messages = builder.messages;
        this.nextToken = builder.nextToken;
    }

    public boolean hasMessages() {
        return this.messages != null && !(this.messages instanceof SdkAutoConstructList);
    }

    public List<FlowExecutionMessage> messages() {
        return this.messages;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessages() ? this.messages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFlowExecutionMessagesResponse)) {
            return false;
        }
        ListFlowExecutionMessagesResponse other = (ListFlowExecutionMessagesResponse)((Object)obj);
        return this.hasMessages() == other.hasMessages() && Objects.equals(this.messages(), other.messages()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListFlowExecutionMessagesResponse").add("Messages", this.hasMessages() ? this.messages() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "messages": {
                return Optional.ofNullable(clazz.cast(this.messages()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFlowExecutionMessagesResponse, T> g) {
        return obj -> g.apply((ListFlowExecutionMessagesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTThingsGraphResponse.BuilderImpl
    implements Builder {
        private List<FlowExecutionMessage> messages = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFlowExecutionMessagesResponse model) {
            super(model);
            this.messages(model.messages);
            this.nextToken(model.nextToken);
        }

        public final Collection<FlowExecutionMessage.Builder> getMessages() {
            if (this.messages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.messages != null ? (Collection)this.messages.stream().map(FlowExecutionMessage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder messages(Collection<FlowExecutionMessage> messages) {
            this.messages = FlowExecutionMessagesCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(FlowExecutionMessage ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<FlowExecutionMessage.Builder> ... messages) {
            this.messages(Stream.of(messages).map(c -> (FlowExecutionMessage)((FlowExecutionMessage.Builder)FlowExecutionMessage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMessages(Collection<FlowExecutionMessage.BuilderImpl> messages) {
            this.messages = FlowExecutionMessagesCopier.copyFromBuilder(messages);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListFlowExecutionMessagesResponse build() {
            return new ListFlowExecutionMessagesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTThingsGraphResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFlowExecutionMessagesResponse> {
        public Builder messages(Collection<FlowExecutionMessage> var1);

        public Builder messages(FlowExecutionMessage ... var1);

        public Builder messages(Consumer<FlowExecutionMessage.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

