/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotthingsgraph.model.IoTThingsGraphResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteNamespaceResponse
extends IoTThingsGraphResponse
implements ToCopyableBuilder<Builder, DeleteNamespaceResponse> {
    private static final SdkField<String> NAMESPACE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceArn").getter(DeleteNamespaceResponse.getter(DeleteNamespaceResponse::namespaceArn)).setter(DeleteNamespaceResponse.setter(Builder::namespaceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceArn").build()}).build();
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceName").getter(DeleteNamespaceResponse.getter(DeleteNamespaceResponse::namespaceName)).setter(DeleteNamespaceResponse.setter(Builder::namespaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_ARN_FIELD, NAMESPACE_NAME_FIELD));
    private final String namespaceArn;
    private final String namespaceName;

    private DeleteNamespaceResponse(BuilderImpl builder) {
        super(builder);
        this.namespaceArn = builder.namespaceArn;
        this.namespaceName = builder.namespaceName;
    }

    public String namespaceArn() {
        return this.namespaceArn;
    }

    public String namespaceName() {
        return this.namespaceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteNamespaceResponse)) {
            return false;
        }
        DeleteNamespaceResponse other = (DeleteNamespaceResponse)((Object)obj);
        return Objects.equals(this.namespaceArn(), other.namespaceArn()) && Objects.equals(this.namespaceName(), other.namespaceName());
    }

    public String toString() {
        return ToString.builder((String)"DeleteNamespaceResponse").add("NamespaceArn", (Object)this.namespaceArn()).add("NamespaceName", (Object)this.namespaceName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "namespaceArn": {
                return Optional.ofNullable(clazz.cast(this.namespaceArn()));
            }
            case "namespaceName": {
                return Optional.ofNullable(clazz.cast(this.namespaceName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteNamespaceResponse, T> g) {
        return obj -> g.apply((DeleteNamespaceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTThingsGraphResponse.BuilderImpl
    implements Builder {
        private String namespaceArn;
        private String namespaceName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteNamespaceResponse model) {
            super(model);
            this.namespaceArn(model.namespaceArn);
            this.namespaceName(model.namespaceName);
        }

        public final String getNamespaceArn() {
            return this.namespaceArn;
        }

        @Override
        public final Builder namespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
            return this;
        }

        public final void setNamespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
        }

        public final String getNamespaceName() {
            return this.namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public DeleteNamespaceResponse build() {
            return new DeleteNamespaceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTThingsGraphResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteNamespaceResponse> {
        public Builder namespaceArn(String var1);

        public Builder namespaceName(String var1);
    }
}

