/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploySystemInstanceResponse extends IoTThingsGraphResponse implements
        ToCopyableBuilder<DeploySystemInstanceResponse.Builder, DeploySystemInstanceResponse> {
    private static final SdkField<SystemInstanceSummary> SUMMARY_FIELD = SdkField
            .<SystemInstanceSummary> builder(MarshallingType.SDK_POJO).getter(getter(DeploySystemInstanceResponse::summary))
            .setter(setter(Builder::summary)).constructor(SystemInstanceSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()).build();

    private static final SdkField<String> GREENGRASS_DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeploySystemInstanceResponse::greengrassDeploymentId)).setter(setter(Builder::greengrassDeploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greengrassDeploymentId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARY_FIELD,
            GREENGRASS_DEPLOYMENT_ID_FIELD));

    private final SystemInstanceSummary summary;

    private final String greengrassDeploymentId;

    private DeploySystemInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.summary = builder.summary;
        this.greengrassDeploymentId = builder.greengrassDeploymentId;
    }

    /**
     * <p>
     * An object that contains summary information about a system instance that was deployed.
     * </p>
     * 
     * @return An object that contains summary information about a system instance that was deployed.
     */
    public SystemInstanceSummary summary() {
        return summary;
    }

    /**
     * <p>
     * The ID of the Greengrass deployment used to deploy the system instance.
     * </p>
     * 
     * @return The ID of the Greengrass deployment used to deploy the system instance.
     */
    public String greengrassDeploymentId() {
        return greengrassDeploymentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        hashCode = 31 * hashCode + Objects.hashCode(greengrassDeploymentId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploySystemInstanceResponse)) {
            return false;
        }
        DeploySystemInstanceResponse other = (DeploySystemInstanceResponse) obj;
        return Objects.equals(summary(), other.summary())
                && Objects.equals(greengrassDeploymentId(), other.greengrassDeploymentId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeploySystemInstanceResponse").add("Summary", summary())
                .add("GreengrassDeploymentId", greengrassDeploymentId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "summary":
            return Optional.ofNullable(clazz.cast(summary()));
        case "greengrassDeploymentId":
            return Optional.ofNullable(clazz.cast(greengrassDeploymentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploySystemInstanceResponse, T> g) {
        return obj -> g.apply((DeploySystemInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTThingsGraphResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeploySystemInstanceResponse> {
        /**
         * <p>
         * An object that contains summary information about a system instance that was deployed.
         * </p>
         * 
         * @param summary
         *        An object that contains summary information about a system instance that was deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(SystemInstanceSummary summary);

        /**
         * <p>
         * An object that contains summary information about a system instance that was deployed.
         * </p>
         * This is a convenience that creates an instance of the {@link SystemInstanceSummary.Builder} avoiding the need
         * to create one manually via {@link SystemInstanceSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link SystemInstanceSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #summary(SystemInstanceSummary)}.
         * 
         * @param summary
         *        a consumer that will call methods on {@link SystemInstanceSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summary(SystemInstanceSummary)
         */
        default Builder summary(Consumer<SystemInstanceSummary.Builder> summary) {
            return summary(SystemInstanceSummary.builder().applyMutation(summary).build());
        }

        /**
         * <p>
         * The ID of the Greengrass deployment used to deploy the system instance.
         * </p>
         * 
         * @param greengrassDeploymentId
         *        The ID of the Greengrass deployment used to deploy the system instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greengrassDeploymentId(String greengrassDeploymentId);
    }

    static final class BuilderImpl extends IoTThingsGraphResponse.BuilderImpl implements Builder {
        private SystemInstanceSummary summary;

        private String greengrassDeploymentId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploySystemInstanceResponse model) {
            super(model);
            summary(model.summary);
            greengrassDeploymentId(model.greengrassDeploymentId);
        }

        public final SystemInstanceSummary.Builder getSummary() {
            return summary != null ? summary.toBuilder() : null;
        }

        @Override
        public final Builder summary(SystemInstanceSummary summary) {
            this.summary = summary;
            return this;
        }

        public final void setSummary(SystemInstanceSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        public final String getGreengrassDeploymentId() {
            return greengrassDeploymentId;
        }

        @Override
        public final Builder greengrassDeploymentId(String greengrassDeploymentId) {
            this.greengrassDeploymentId = greengrassDeploymentId;
            return this;
        }

        public final void setGreengrassDeploymentId(String greengrassDeploymentId) {
            this.greengrassDeploymentId = greengrassDeploymentId;
        }

        @Override
        public DeploySystemInstanceResponse build() {
            return new DeploySystemInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
