/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSystemInstanceRequest extends IoTThingsGraphRequest implements
        ToCopyableBuilder<CreateSystemInstanceRequest.Builder, CreateSystemInstanceRequest> {
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateSystemInstanceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DefinitionDocument> DEFINITION_FIELD = SdkField
            .<DefinitionDocument> builder(MarshallingType.SDK_POJO).getter(getter(CreateSystemInstanceRequest::definition))
            .setter(setter(Builder::definition)).constructor(DefinitionDocument::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSystemInstanceRequest::targetAsString)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()).build();

    private static final SdkField<String> GREENGRASS_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSystemInstanceRequest::greengrassGroupName)).setter(setter(Builder::greengrassGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greengrassGroupName").build())
            .build();

    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSystemInstanceRequest::s3BucketName)).setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketName").build()).build();

    private static final SdkField<MetricsConfiguration> METRICS_CONFIGURATION_FIELD = SdkField
            .<MetricsConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateSystemInstanceRequest::metricsConfiguration)).setter(setter(Builder::metricsConfiguration))
            .constructor(MetricsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsConfiguration").build())
            .build();

    private static final SdkField<String> FLOW_ACTIONS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateSystemInstanceRequest::flowActionsRoleArn)).setter(setter(Builder::flowActionsRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowActionsRoleArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGS_FIELD, DEFINITION_FIELD,
            TARGET_FIELD, GREENGRASS_GROUP_NAME_FIELD, S3_BUCKET_NAME_FIELD, METRICS_CONFIGURATION_FIELD,
            FLOW_ACTIONS_ROLE_ARN_FIELD));

    private final List<Tag> tags;

    private final DefinitionDocument definition;

    private final String target;

    private final String greengrassGroupName;

    private final String s3BucketName;

    private final MetricsConfiguration metricsConfiguration;

    private final String flowActionsRoleArn;

    private CreateSystemInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.tags = builder.tags;
        this.definition = builder.definition;
        this.target = builder.target;
        this.greengrassGroupName = builder.greengrassGroupName;
        this.s3BucketName = builder.s3BucketName;
        this.metricsConfiguration = builder.metricsConfiguration;
        this.flowActionsRoleArn = builder.flowActionsRoleArn;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata, consisting of key-value pairs, that can be used to categorize your system instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Metadata, consisting of key-value pairs, that can be used to categorize your system instances.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * Returns the value of the Definition property for this object.
     * 
     * @return The value of the Definition property for this object.
     */
    public DefinitionDocument definition() {
        return definition;
    }

    /**
     * <p>
     * The target type of the deployment. Valid values are <code>GREENGRASS</code> and <code>CLOUD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #target} will
     * return {@link DeploymentTarget#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetAsString}.
     * </p>
     * 
     * @return The target type of the deployment. Valid values are <code>GREENGRASS</code> and <code>CLOUD</code>.
     * @see DeploymentTarget
     */
    public DeploymentTarget target() {
        return DeploymentTarget.fromValue(target);
    }

    /**
     * <p>
     * The target type of the deployment. Valid values are <code>GREENGRASS</code> and <code>CLOUD</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #target} will
     * return {@link DeploymentTarget#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #targetAsString}.
     * </p>
     * 
     * @return The target type of the deployment. Valid values are <code>GREENGRASS</code> and <code>CLOUD</code>.
     * @see DeploymentTarget
     */
    public String targetAsString() {
        return target;
    }

    /**
     * <p>
     * The name of the Greengrass group where the system instance will be deployed. This value is required if the value
     * of the <code>target</code> parameter is <code>GREENGRASS</code>.
     * </p>
     * 
     * @return The name of the Greengrass group where the system instance will be deployed. This value is required if
     *         the value of the <code>target</code> parameter is <code>GREENGRASS</code>.
     */
    public String greengrassGroupName() {
        return greengrassGroupName;
    }

    /**
     * <p>
     * The name of the Amazon Simple Storage Service bucket that will be used to store and deploy the system instance's
     * resource file. This value is required if the value of the <code>target</code> parameter is
     * <code>GREENGRASS</code>.
     * </p>
     * 
     * @return The name of the Amazon Simple Storage Service bucket that will be used to store and deploy the system
     *         instance's resource file. This value is required if the value of the <code>target</code> parameter is
     *         <code>GREENGRASS</code>.
     */
    public String s3BucketName() {
        return s3BucketName;
    }

    /**
     * Returns the value of the MetricsConfiguration property for this object.
     * 
     * @return The value of the MetricsConfiguration property for this object.
     */
    public MetricsConfiguration metricsConfiguration() {
        return metricsConfiguration;
    }

    /**
     * <p>
     * The ARN of the IAM role that AWS IoT Things Graph will assume when it executes the flow. This role must have read
     * and write access to AWS Lambda and AWS IoT and any other AWS services that the flow uses when it executes. This
     * value is required if the value of the <code>target</code> parameter is <code>CLOUD</code>.
     * </p>
     * 
     * @return The ARN of the IAM role that AWS IoT Things Graph will assume when it executes the flow. This role must
     *         have read and write access to AWS Lambda and AWS IoT and any other AWS services that the flow uses when
     *         it executes. This value is required if the value of the <code>target</code> parameter is
     *         <code>CLOUD</code>.
     */
    public String flowActionsRoleArn() {
        return flowActionsRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(targetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(greengrassGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(metricsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(flowActionsRoleArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSystemInstanceRequest)) {
            return false;
        }
        CreateSystemInstanceRequest other = (CreateSystemInstanceRequest) obj;
        return Objects.equals(tags(), other.tags()) && Objects.equals(definition(), other.definition())
                && Objects.equals(targetAsString(), other.targetAsString())
                && Objects.equals(greengrassGroupName(), other.greengrassGroupName())
                && Objects.equals(s3BucketName(), other.s3BucketName())
                && Objects.equals(metricsConfiguration(), other.metricsConfiguration())
                && Objects.equals(flowActionsRoleArn(), other.flowActionsRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateSystemInstanceRequest").add("Tags", tags()).add("Definition", definition())
                .add("Target", targetAsString()).add("GreengrassGroupName", greengrassGroupName())
                .add("S3BucketName", s3BucketName()).add("MetricsConfiguration", metricsConfiguration())
                .add("FlowActionsRoleArn", flowActionsRoleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "target":
            return Optional.ofNullable(clazz.cast(targetAsString()));
        case "greengrassGroupName":
            return Optional.ofNullable(clazz.cast(greengrassGroupName()));
        case "s3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "metricsConfiguration":
            return Optional.ofNullable(clazz.cast(metricsConfiguration()));
        case "flowActionsRoleArn":
            return Optional.ofNullable(clazz.cast(flowActionsRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSystemInstanceRequest, T> g) {
        return obj -> g.apply((CreateSystemInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTThingsGraphRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSystemInstanceRequest> {
        /**
         * <p>
         * Metadata, consisting of key-value pairs, that can be used to categorize your system instances.
         * </p>
         * 
         * @param tags
         *        Metadata, consisting of key-value pairs, that can be used to categorize your system instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Metadata, consisting of key-value pairs, that can be used to categorize your system instances.
         * </p>
         * 
         * @param tags
         *        Metadata, consisting of key-value pairs, that can be used to categorize your system instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Metadata, consisting of key-value pairs, that can be used to categorize your system instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * Sets the value of the Definition property for this object.
         *
         * @param definition
         *        The new value for the Definition property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(DefinitionDocument definition);

        /**
         * Sets the value of the Definition property for this object.
         *
         * This is a convenience that creates an instance of the {@link DefinitionDocument.Builder} avoiding the need to
         * create one manually via {@link DefinitionDocument#builder()}.
         *
         * When the {@link Consumer} completes, {@link DefinitionDocument.Builder#build()} is called immediately and its
         * result is passed to {@link #definition(DefinitionDocument)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link DefinitionDocument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(DefinitionDocument)
         */
        default Builder definition(Consumer<DefinitionDocument.Builder> definition) {
            return definition(DefinitionDocument.builder().applyMutation(definition).build());
        }

        /**
         * <p>
         * The target type of the deployment. Valid values are <code>GREENGRASS</code> and <code>CLOUD</code>.
         * </p>
         * 
         * @param target
         *        The target type of the deployment. Valid values are <code>GREENGRASS</code> and <code>CLOUD</code>.
         * @see DeploymentTarget
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentTarget
         */
        Builder target(String target);

        /**
         * <p>
         * The target type of the deployment. Valid values are <code>GREENGRASS</code> and <code>CLOUD</code>.
         * </p>
         * 
         * @param target
         *        The target type of the deployment. Valid values are <code>GREENGRASS</code> and <code>CLOUD</code>.
         * @see DeploymentTarget
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentTarget
         */
        Builder target(DeploymentTarget target);

        /**
         * <p>
         * The name of the Greengrass group where the system instance will be deployed. This value is required if the
         * value of the <code>target</code> parameter is <code>GREENGRASS</code>.
         * </p>
         * 
         * @param greengrassGroupName
         *        The name of the Greengrass group where the system instance will be deployed. This value is required if
         *        the value of the <code>target</code> parameter is <code>GREENGRASS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greengrassGroupName(String greengrassGroupName);

        /**
         * <p>
         * The name of the Amazon Simple Storage Service bucket that will be used to store and deploy the system
         * instance's resource file. This value is required if the value of the <code>target</code> parameter is
         * <code>GREENGRASS</code>.
         * </p>
         * 
         * @param s3BucketName
         *        The name of the Amazon Simple Storage Service bucket that will be used to store and deploy the system
         *        instance's resource file. This value is required if the value of the <code>target</code> parameter is
         *        <code>GREENGRASS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * Sets the value of the MetricsConfiguration property for this object.
         *
         * @param metricsConfiguration
         *        The new value for the MetricsConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsConfiguration(MetricsConfiguration metricsConfiguration);

        /**
         * Sets the value of the MetricsConfiguration property for this object.
         *
         * This is a convenience that creates an instance of the {@link MetricsConfiguration.Builder} avoiding the need
         * to create one manually via {@link MetricsConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetricsConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #metricsConfiguration(MetricsConfiguration)}.
         * 
         * @param metricsConfiguration
         *        a consumer that will call methods on {@link MetricsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricsConfiguration(MetricsConfiguration)
         */
        default Builder metricsConfiguration(Consumer<MetricsConfiguration.Builder> metricsConfiguration) {
            return metricsConfiguration(MetricsConfiguration.builder().applyMutation(metricsConfiguration).build());
        }

        /**
         * <p>
         * The ARN of the IAM role that AWS IoT Things Graph will assume when it executes the flow. This role must have
         * read and write access to AWS Lambda and AWS IoT and any other AWS services that the flow uses when it
         * executes. This value is required if the value of the <code>target</code> parameter is <code>CLOUD</code>.
         * </p>
         * 
         * @param flowActionsRoleArn
         *        The ARN of the IAM role that AWS IoT Things Graph will assume when it executes the flow. This role
         *        must have read and write access to AWS Lambda and AWS IoT and any other AWS services that the flow
         *        uses when it executes. This value is required if the value of the <code>target</code> parameter is
         *        <code>CLOUD</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowActionsRoleArn(String flowActionsRoleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTThingsGraphRequest.BuilderImpl implements Builder {
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private DefinitionDocument definition;

        private String target;

        private String greengrassGroupName;

        private String s3BucketName;

        private MetricsConfiguration metricsConfiguration;

        private String flowActionsRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSystemInstanceRequest model) {
            super(model);
            tags(model.tags);
            definition(model.definition);
            target(model.target);
            greengrassGroupName(model.greengrassGroupName);
            s3BucketName(model.s3BucketName);
            metricsConfiguration(model.metricsConfiguration);
            flowActionsRoleArn(model.flowActionsRoleArn);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final DefinitionDocument.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        @Override
        public final Builder definition(DefinitionDocument definition) {
            this.definition = definition;
            return this;
        }

        public final void setDefinition(DefinitionDocument.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        public final String getTarget() {
            return target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        @Override
        public final Builder target(DeploymentTarget target) {
            this.target(target == null ? null : target.toString());
            return this;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        public final String getGreengrassGroupName() {
            return greengrassGroupName;
        }

        @Override
        public final Builder greengrassGroupName(String greengrassGroupName) {
            this.greengrassGroupName = greengrassGroupName;
            return this;
        }

        public final void setGreengrassGroupName(String greengrassGroupName) {
            this.greengrassGroupName = greengrassGroupName;
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        public final MetricsConfiguration.Builder getMetricsConfiguration() {
            return metricsConfiguration != null ? metricsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder metricsConfiguration(MetricsConfiguration metricsConfiguration) {
            this.metricsConfiguration = metricsConfiguration;
            return this;
        }

        public final void setMetricsConfiguration(MetricsConfiguration.BuilderImpl metricsConfiguration) {
            this.metricsConfiguration = metricsConfiguration != null ? metricsConfiguration.build() : null;
        }

        public final String getFlowActionsRoleArn() {
            return flowActionsRoleArn;
        }

        @Override
        public final Builder flowActionsRoleArn(String flowActionsRoleArn) {
            this.flowActionsRoleArn = flowActionsRoleArn;
            return this;
        }

        public final void setFlowActionsRoleArn(String flowActionsRoleArn) {
            this.flowActionsRoleArn = flowActionsRoleArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSystemInstanceRequest build() {
            return new CreateSystemInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
