/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsecuretunneling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsecuretunneling.model.IoTSecureTunnelingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RotateTunnelAccessTokenResponse
extends IoTSecureTunnelingResponse
implements ToCopyableBuilder<Builder, RotateTunnelAccessTokenResponse> {
    private static final SdkField<String> TUNNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tunnelArn").getter(RotateTunnelAccessTokenResponse.getter(RotateTunnelAccessTokenResponse::tunnelArn)).setter(RotateTunnelAccessTokenResponse.setter(Builder::tunnelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tunnelArn").build()}).build();
    private static final SdkField<String> SOURCE_ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceAccessToken").getter(RotateTunnelAccessTokenResponse.getter(RotateTunnelAccessTokenResponse::sourceAccessToken)).setter(RotateTunnelAccessTokenResponse.setter(Builder::sourceAccessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAccessToken").build()}).build();
    private static final SdkField<String> DESTINATION_ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationAccessToken").getter(RotateTunnelAccessTokenResponse.getter(RotateTunnelAccessTokenResponse::destinationAccessToken)).setter(RotateTunnelAccessTokenResponse.setter(Builder::destinationAccessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationAccessToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TUNNEL_ARN_FIELD, SOURCE_ACCESS_TOKEN_FIELD, DESTINATION_ACCESS_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("tunnelArn", TUNNEL_ARN_FIELD);
            this.put("sourceAccessToken", SOURCE_ACCESS_TOKEN_FIELD);
            this.put("destinationAccessToken", DESTINATION_ACCESS_TOKEN_FIELD);
        }
    });
    private final String tunnelArn;
    private final String sourceAccessToken;
    private final String destinationAccessToken;

    private RotateTunnelAccessTokenResponse(BuilderImpl builder) {
        super(builder);
        this.tunnelArn = builder.tunnelArn;
        this.sourceAccessToken = builder.sourceAccessToken;
        this.destinationAccessToken = builder.destinationAccessToken;
    }

    public final String tunnelArn() {
        return this.tunnelArn;
    }

    public final String sourceAccessToken() {
        return this.sourceAccessToken;
    }

    public final String destinationAccessToken() {
        return this.destinationAccessToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tunnelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAccessToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationAccessToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RotateTunnelAccessTokenResponse)) {
            return false;
        }
        RotateTunnelAccessTokenResponse other = (RotateTunnelAccessTokenResponse)((Object)obj);
        return Objects.equals(this.tunnelArn(), other.tunnelArn()) && Objects.equals(this.sourceAccessToken(), other.sourceAccessToken()) && Objects.equals(this.destinationAccessToken(), other.destinationAccessToken());
    }

    public final String toString() {
        return ToString.builder((String)"RotateTunnelAccessTokenResponse").add("TunnelArn", (Object)this.tunnelArn()).add("SourceAccessToken", (Object)(this.sourceAccessToken() == null ? null : "*** Sensitive Data Redacted ***")).add("DestinationAccessToken", (Object)(this.destinationAccessToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tunnelArn": {
                return Optional.ofNullable(clazz.cast(this.tunnelArn()));
            }
            case "sourceAccessToken": {
                return Optional.ofNullable(clazz.cast(this.sourceAccessToken()));
            }
            case "destinationAccessToken": {
                return Optional.ofNullable(clazz.cast(this.destinationAccessToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RotateTunnelAccessTokenResponse, T> g) {
        return obj -> g.apply((RotateTunnelAccessTokenResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSecureTunnelingResponse.BuilderImpl
    implements Builder {
        private String tunnelArn;
        private String sourceAccessToken;
        private String destinationAccessToken;

        private BuilderImpl() {
        }

        private BuilderImpl(RotateTunnelAccessTokenResponse model) {
            super(model);
            this.tunnelArn(model.tunnelArn);
            this.sourceAccessToken(model.sourceAccessToken);
            this.destinationAccessToken(model.destinationAccessToken);
        }

        public final String getTunnelArn() {
            return this.tunnelArn;
        }

        public final void setTunnelArn(String tunnelArn) {
            this.tunnelArn = tunnelArn;
        }

        @Override
        public final Builder tunnelArn(String tunnelArn) {
            this.tunnelArn = tunnelArn;
            return this;
        }

        public final String getSourceAccessToken() {
            return this.sourceAccessToken;
        }

        public final void setSourceAccessToken(String sourceAccessToken) {
            this.sourceAccessToken = sourceAccessToken;
        }

        @Override
        public final Builder sourceAccessToken(String sourceAccessToken) {
            this.sourceAccessToken = sourceAccessToken;
            return this;
        }

        public final String getDestinationAccessToken() {
            return this.destinationAccessToken;
        }

        public final void setDestinationAccessToken(String destinationAccessToken) {
            this.destinationAccessToken = destinationAccessToken;
        }

        @Override
        public final Builder destinationAccessToken(String destinationAccessToken) {
            this.destinationAccessToken = destinationAccessToken;
            return this;
        }

        @Override
        public RotateTunnelAccessTokenResponse build() {
            return new RotateTunnelAccessTokenResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTSecureTunnelingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RotateTunnelAccessTokenResponse> {
        public Builder tunnelArn(String var1);

        public Builder sourceAccessToken(String var1);

        public Builder destinationAccessToken(String var1);
    }
}

